/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.MergeContent;
import org.apache.nifi.stream.io.BufferedInputStream;
import org.apache.nifi.stream.io.BufferedOutputStream;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.util.FlowFileUnpackager;
import org.apache.nifi.util.FlowFileUnpackagerV1;
import org.apache.nifi.util.FlowFileUnpackagerV2;
import org.apache.nifi.util.FlowFileUnpackagerV3;

@EventDriven
@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"Unpack", "un-merge", "tar", "zip", "archive", "flowfile-stream", "flowfile-stream-v3"})
@CapabilityDescription(value="Unpacks the content of FlowFiles that have been packaged with one of several different Packaging Formats, emitting one to many FlowFiles for each input FlowFile")
@ReadsAttribute(attribute="mime.type", description="If the <Packaging Format> property is set to use mime.type attribute, this attribute is used to determine the FlowFile's MIME Type. In this case, if the attribute is set to application/tar, the TAR Packaging Format will be used. If the attribute is set to application/zip, the ZIP Packaging Format will be used. If the attribute is set to application/flowfile-v3 or application/flowfile-v2 or application/flowfile-v1, the appropriate FlowFile Packaging Format will be used. If this attribute is missing, the FlowFile will be routed to 'failure'. Otherwise, if the attribute's value is not one of those mentioned above, the FlowFile will be routed to 'success' without being unpacked. Use the File Filter property only extract files matching a specific regular expression.")
@WritesAttributes(value={@WritesAttribute(attribute="mime.type", description="If the FlowFile is successfully unpacked, its MIME Type is no longer known, so the mime.type attribute is set to application/octet-stream."), @WritesAttribute(attribute="fragment.identifier", description="All unpacked FlowFiles produced from the same parent FlowFile will have the same randomly generated UUID added for this attribute"), @WritesAttribute(attribute="fragment.index", description="A one-up number that indicates the ordering of the unpacked FlowFiles that were created from a single parent FlowFile"), @WritesAttribute(attribute="fragment.count", description="The number of unpacked FlowFiles generated from the parent FlowFile"), @WritesAttribute(attribute="segment.original.filename ", description="The filename of the parent FlowFile. Extensions of .tar, .zip or .pkg are removed because the MergeContent processor automatically adds those extensions if it is used to rebuild the original FlowFile")})
@SeeAlso(value={MergeContent.class})
public class UnpackContent
extends AbstractProcessor {
    public static final String FRAGMENT_ID = "fragment.identifier";
    public static final String FRAGMENT_INDEX = "fragment.index";
    public static final String FRAGMENT_COUNT = "fragment.count";
    public static final String SEGMENT_ORIGINAL_FILENAME = "segment.original.filename";
    public static final String AUTO_DETECT_FORMAT_NAME = "use mime.type attribute";
    public static final String TAR_FORMAT_NAME = "tar";
    public static final String ZIP_FORMAT_NAME = "zip";
    public static final String FLOWFILE_STREAM_FORMAT_V3_NAME = "flowfile-stream-v3";
    public static final String FLOWFILE_STREAM_FORMAT_V2_NAME = "flowfile-stream-v2";
    public static final String FLOWFILE_TAR_FORMAT_NAME = "flowfile-tar-v1";
    public static final String OCTET_STREAM = "application/octet-stream";
    public static final PropertyDescriptor PACKAGING_FORMAT = new PropertyDescriptor.Builder().name("Packaging Format").description("The Packaging Format used to create the file").required(true).allowableValues(new String[]{PackageFormat.AUTO_DETECT_FORMAT.toString(), PackageFormat.TAR_FORMAT.toString(), PackageFormat.ZIP_FORMAT.toString(), PackageFormat.FLOWFILE_STREAM_FORMAT_V3.toString(), PackageFormat.FLOWFILE_STREAM_FORMAT_V2.toString(), PackageFormat.FLOWFILE_TAR_FORMAT.toString()}).defaultValue(PackageFormat.AUTO_DETECT_FORMAT.toString()).build();
    public static final PropertyDescriptor FILE_FILTER = new PropertyDescriptor.Builder().name("File Filter").description("Only files whose names match the given regular expression will be extracted (tar/zip only)").required(true).defaultValue(".*").addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Unpacked FlowFiles are sent to this relationship").build();
    public static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").description("The original FlowFile is sent to this relationship after it has been successfully unpacked").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("The original FlowFile is sent to this relationship when it cannot be unpacked for some reason").build();
    private Set<Relationship> relationships;
    private List<PropertyDescriptor> properties;
    private Pattern fileFilter;
    private Unpacker tarUnpacker;
    private Unpacker zipUnpacker;

    protected void init(ProcessorInitializationContext context) {
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        relationships.add(REL_ORIGINAL);
        relationships.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(relationships);
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(PACKAGING_FORMAT);
        properties.add(FILE_FILTER);
        this.properties = Collections.unmodifiableList(properties);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    @OnStopped
    public void onStopped() {
        this.fileFilter = null;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) throws ProcessException {
        if (this.fileFilter == null) {
            this.fileFilter = Pattern.compile(context.getProperty(FILE_FILTER).getValue());
            this.tarUnpacker = new TarUnpacker(this.fileFilter);
            this.zipUnpacker = new ZipUnpacker(this.fileFilter);
        }
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        boolean addFragmentAttrs;
        Unpacker unpacker;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        ComponentLog logger = this.getLogger();
        PackageFormat packagingFormat = PackageFormat.getFormat(context.getProperty(PACKAGING_FORMAT).getValue().toLowerCase());
        if (packagingFormat == PackageFormat.AUTO_DETECT_FORMAT) {
            packagingFormat = null;
            String mimeType = flowFile.getAttribute(CoreAttributes.MIME_TYPE.key());
            if (mimeType == null) {
                logger.error("No mime.type attribute set for {}; routing to failure", new Object[]{flowFile});
                session.transfer(flowFile, REL_FAILURE);
                return;
            }
            for (PackageFormat format : PackageFormat.values()) {
                if (!mimeType.toLowerCase().equals(format.getMimeType())) continue;
                packagingFormat = format;
            }
            if (packagingFormat == null) {
                logger.info("Cannot unpack {} because its mime.type attribute is set to '{}', which is not a format that can be unpacked; routing to 'success'", new Object[]{flowFile, mimeType});
                session.transfer(flowFile, REL_SUCCESS);
                return;
            }
        }
        switch (packagingFormat) {
            case TAR_FORMAT: 
            case X_TAR_FORMAT: {
                unpacker = this.tarUnpacker;
                addFragmentAttrs = true;
                break;
            }
            case ZIP_FORMAT: {
                unpacker = this.zipUnpacker;
                addFragmentAttrs = true;
                break;
            }
            case FLOWFILE_STREAM_FORMAT_V2: {
                unpacker = new FlowFileStreamUnpacker((FlowFileUnpackager)new FlowFileUnpackagerV2());
                addFragmentAttrs = false;
                break;
            }
            case FLOWFILE_STREAM_FORMAT_V3: {
                unpacker = new FlowFileStreamUnpacker((FlowFileUnpackager)new FlowFileUnpackagerV3());
                addFragmentAttrs = false;
                break;
            }
            case FLOWFILE_TAR_FORMAT: {
                unpacker = new FlowFileStreamUnpacker((FlowFileUnpackager)new FlowFileUnpackagerV1());
                addFragmentAttrs = false;
                break;
            }
            default: {
                throw new ProcessException((Object)((Object)packagingFormat) + " is not a valid packaging format");
            }
        }
        ArrayList<FlowFile> unpacked = new ArrayList<FlowFile>();
        try {
            unpacker.unpack(session, flowFile, unpacked);
            if (unpacked.isEmpty()) {
                logger.error("Unable to unpack {} because it does not appear to have any entries; routing to failure", new Object[]{flowFile});
                session.transfer(flowFile, REL_FAILURE);
                return;
            }
            if (addFragmentAttrs) {
                this.finishFragmentAttributes(session, flowFile, unpacked);
            }
            session.transfer(unpacked, REL_SUCCESS);
            session.transfer(flowFile, REL_ORIGINAL);
            session.getProvenanceReporter().fork(flowFile, unpacked);
            logger.info("Unpacked {} into {} and transferred to success", new Object[]{flowFile, unpacked});
        }
        catch (InvalidPathException | ProcessException e) {
            logger.error("Unable to unpack {} due to {}; routing to failure", new Object[]{flowFile, e});
            session.transfer(flowFile, REL_FAILURE);
            session.remove(unpacked);
        }
    }

    private static void mapAttributes(Map<String, String> attributes, String oldKey, String newKey) {
        if (!attributes.containsKey(newKey) && attributes.containsKey(oldKey)) {
            attributes.put(newKey, attributes.get(oldKey));
        }
    }

    private void finishFragmentAttributes(ProcessSession session, FlowFile source, List<FlowFile> unpacked) {
        int fragmentCount = 0;
        for (FlowFile ff : unpacked) {
            String fragmentIndex = ff.getAttribute(FRAGMENT_INDEX);
            if (fragmentIndex != null) {
                ++fragmentCount;
                continue;
            }
            return;
        }
        String originalFilename = source.getAttribute(CoreAttributes.FILENAME.key());
        if (originalFilename.endsWith(".tar") || originalFilename.endsWith(".zip") || originalFilename.endsWith(".pkg")) {
            originalFilename = originalFilename.substring(0, originalFilename.length() - 4);
        }
        ArrayList<FlowFile> newList = new ArrayList<FlowFile>(unpacked);
        unpacked.clear();
        for (FlowFile ff : newList) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put(FRAGMENT_COUNT, String.valueOf(fragmentCount));
            attributes.put(SEGMENT_ORIGINAL_FILENAME, originalFilename);
            FlowFile newFF = session.putAllAttributes(ff, attributes);
            unpacked.add(newFF);
        }
    }

    protected static enum PackageFormat {
        AUTO_DETECT_FORMAT("use mime.type attribute"),
        TAR_FORMAT("tar", "application/tar"),
        X_TAR_FORMAT("tar", "application/x-tar"),
        ZIP_FORMAT("zip", "application/zip"),
        FLOWFILE_STREAM_FORMAT_V3("flowfile-stream-v3", "application/flowfile-v3"),
        FLOWFILE_STREAM_FORMAT_V2("flowfile-stream-v2", "application/flowfile-v2"),
        FLOWFILE_TAR_FORMAT("flowfile-tar-v1", "application/flowfile-v1");

        private final String textValue;
        private String mimeType;

        private PackageFormat(String textValue, String mimeType) {
            this.textValue = textValue;
            this.mimeType = mimeType;
        }

        private PackageFormat(String textValue) {
            this.textValue = textValue;
        }

        public String toString() {
            return this.textValue;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public static PackageFormat getFormat(String textValue) {
            switch (textValue) {
                case "use mime.type attribute": {
                    return AUTO_DETECT_FORMAT;
                }
                case "tar": {
                    return TAR_FORMAT;
                }
                case "zip": {
                    return ZIP_FORMAT;
                }
                case "flowfile-stream-v3": {
                    return FLOWFILE_STREAM_FORMAT_V3;
                }
                case "flowfile-stream-v2": {
                    return FLOWFILE_STREAM_FORMAT_V2;
                }
                case "flowfile-tar-v1": {
                    return FLOWFILE_TAR_FORMAT;
                }
            }
            return null;
        }
    }

    private static class FlowFileStreamUnpacker
    extends Unpacker {
        private final FlowFileUnpackager unpackager;

        public FlowFileStreamUnpacker(FlowFileUnpackager unpackager) {
            this.unpackager = unpackager;
        }

        @Override
        public void unpack(final ProcessSession session, final FlowFile source, final List<FlowFile> unpacked) {
            session.read(source, new InputStreamCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void process(InputStream rawIn) throws IOException {
                    try (BufferedInputStream in = new BufferedInputStream(rawIn);){
                        while (unpackager.hasMoreData()) {
                            AtomicReference<Object> attributesRef = new AtomicReference<Object>(null);
                            FlowFile unpackedFile = session.create(source);
                            try {
                                unpackedFile = session.write(unpackedFile, new OutputStreamCallback((InputStream)in, attributesRef){
                                    final /* synthetic */ InputStream val$in;
                                    final /* synthetic */ AtomicReference val$attributesRef;
                                    {
                                        this.val$in = inputStream;
                                        this.val$attributesRef = atomicReference;
                                    }

                                    public void process(OutputStream rawOut) throws IOException {
                                        try (BufferedOutputStream out = new BufferedOutputStream(rawOut);){
                                            Map attributes = unpackager.unpackageFlowFile(this.val$in, (OutputStream)out);
                                            if (attributes == null) {
                                                throw new IOException("Failed to unpack " + source + ": stream had no Attributes");
                                            }
                                            this.val$attributesRef.set(attributes);
                                        }
                                    }
                                });
                                Map attributes = attributesRef.get();
                                attributes.remove(CoreAttributes.UUID.key());
                                UnpackContent.mapAttributes(attributes, "nf.file.name", CoreAttributes.FILENAME.key());
                                UnpackContent.mapAttributes(attributes, "nf.file.path", CoreAttributes.PATH.key());
                                UnpackContent.mapAttributes(attributes, "content-encoding", CoreAttributes.MIME_TYPE.key());
                                UnpackContent.mapAttributes(attributes, "content-type", CoreAttributes.MIME_TYPE.key());
                                if (!attributes.containsKey(CoreAttributes.MIME_TYPE.key())) {
                                    attributes.put(CoreAttributes.MIME_TYPE.key(), UnpackContent.OCTET_STREAM);
                                }
                                unpackedFile = session.putAllAttributes(unpackedFile, attributes);
                            }
                            finally {
                                unpacked.add(unpackedFile);
                            }
                        }
                    }
                }
            });
        }
    }

    private static class ZipUnpacker
    extends Unpacker {
        public ZipUnpacker(Pattern fileFilter) {
            super(fileFilter);
        }

        @Override
        public void unpack(final ProcessSession session, final FlowFile source, final List<FlowFile> unpacked) {
            final String fragmentId = UUID.randomUUID().toString();
            session.read(source, new InputStreamCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void process(InputStream in) throws IOException {
                    int fragmentCount = 0;
                    try (final ZipArchiveInputStream zipIn = new ZipArchiveInputStream((InputStream)new BufferedInputStream(in));){
                        ArchiveEntry zipEntry;
                        while ((zipEntry = zipIn.getNextEntry()) != null) {
                            if (zipEntry.isDirectory() || !this.fileMatches(zipEntry)) continue;
                            File file = new File(zipEntry.getName());
                            String parentDirectory = file.getParent() == null ? "/" : file.getParent();
                            Path absPath = file.toPath().toAbsolutePath();
                            String absPathString = absPath.getParent().toString() + "/";
                            FlowFile unpackedFile = session.create(source);
                            try {
                                HashMap<String, String> attributes = new HashMap<String, String>();
                                attributes.put(CoreAttributes.FILENAME.key(), file.getName());
                                attributes.put(CoreAttributes.PATH.key(), parentDirectory);
                                attributes.put(CoreAttributes.ABSOLUTE_PATH.key(), absPathString);
                                attributes.put(CoreAttributes.MIME_TYPE.key(), UnpackContent.OCTET_STREAM);
                                attributes.put(UnpackContent.FRAGMENT_ID, fragmentId);
                                attributes.put(UnpackContent.FRAGMENT_INDEX, String.valueOf(++fragmentCount));
                                unpackedFile = session.putAllAttributes(unpackedFile, attributes);
                                unpackedFile = session.write(unpackedFile, new OutputStreamCallback(){

                                    public void process(OutputStream out) throws IOException {
                                        StreamUtils.copy((InputStream)zipIn, (OutputStream)out);
                                    }
                                });
                            }
                            finally {
                                unpacked.add(unpackedFile);
                            }
                        }
                    }
                }
            });
        }
    }

    private static class TarUnpacker
    extends Unpacker {
        public TarUnpacker(Pattern fileFilter) {
            super(fileFilter);
        }

        @Override
        public void unpack(final ProcessSession session, final FlowFile source, final List<FlowFile> unpacked) {
            final String fragmentId = UUID.randomUUID().toString();
            session.read(source, new InputStreamCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void process(InputStream in) throws IOException {
                    int fragmentCount = 0;
                    try (final TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)new BufferedInputStream(in));){
                        TarArchiveEntry tarEntry;
                        while ((tarEntry = tarIn.getNextTarEntry()) != null) {
                            if (tarEntry.isDirectory() || !this.fileMatches((ArchiveEntry)tarEntry)) continue;
                            File file = new File(tarEntry.getName());
                            Path filePath = file.toPath();
                            String filePathString = filePath.getParent() + "/";
                            Path absPath = filePath.toAbsolutePath();
                            String absPathString = absPath.getParent().toString() + "/";
                            FlowFile unpackedFile = session.create(source);
                            try {
                                HashMap<String, String> attributes = new HashMap<String, String>();
                                attributes.put(CoreAttributes.FILENAME.key(), file.getName());
                                attributes.put(CoreAttributes.PATH.key(), filePathString);
                                attributes.put(CoreAttributes.ABSOLUTE_PATH.key(), absPathString);
                                attributes.put(CoreAttributes.MIME_TYPE.key(), UnpackContent.OCTET_STREAM);
                                attributes.put(UnpackContent.FRAGMENT_ID, fragmentId);
                                attributes.put(UnpackContent.FRAGMENT_INDEX, String.valueOf(++fragmentCount));
                                unpackedFile = session.putAllAttributes(unpackedFile, attributes);
                                final long fileSize = tarEntry.getSize();
                                unpackedFile = session.write(unpackedFile, new OutputStreamCallback(){

                                    public void process(OutputStream out) throws IOException {
                                        StreamUtils.copy((InputStream)tarIn, (OutputStream)out, (long)fileSize);
                                    }
                                });
                            }
                            finally {
                                unpacked.add(unpackedFile);
                            }
                        }
                    }
                }
            });
        }
    }

    private static abstract class Unpacker {
        private Pattern fileFilter = null;

        public Unpacker() {
        }

        public Unpacker(Pattern fileFilter) {
            this.fileFilter = fileFilter;
        }

        abstract void unpack(ProcessSession var1, FlowFile var2, List<FlowFile> var3);

        protected boolean fileMatches(ArchiveEntry entry) {
            return this.fileFilter == null || this.fileFilter.matcher(entry.getName()).find();
        }
    }
}

