/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.behavior.TriggerSerially;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processors.standard.FetchSFTP;
import org.apache.nifi.processors.standard.GetSFTP;
import org.apache.nifi.processors.standard.ListFileTransfer;
import org.apache.nifi.processors.standard.PutSFTP;
import org.apache.nifi.processors.standard.util.FileTransfer;
import org.apache.nifi.processors.standard.util.SFTPTransfer;

@TriggerSerially
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@Tags(value={"list", "sftp", "remote", "ingest", "source", "input", "files"})
@CapabilityDescription(value="Performs a listing of the files residing on an SFTP server. For each file that is found on the remote server, a new FlowFile will be created with the filename attribute set to the name of the file on the remote server. This can then be used in conjunction with FetchSFTP in order to fetch those files.")
@SeeAlso(value={FetchSFTP.class, GetSFTP.class, PutSFTP.class})
@WritesAttributes(value={@WritesAttribute(attribute="sftp.remote.host", description="The hostname of the SFTP Server"), @WritesAttribute(attribute="sftp.remote.port", description="The port that was connected to on the SFTP Server"), @WritesAttribute(attribute="sftp.listing.user", description="The username of the user that performed the SFTP Listing"), @WritesAttribute(attribute="file.owner", description="The numeric owner id of the source file"), @WritesAttribute(attribute="file.group", description="The numeric group id of the source file"), @WritesAttribute(attribute="file.permissions", description="The read/write/execute permissions of the source file"), @WritesAttribute(attribute="file.lastModifiedTime", description="The timestamp of when the file in the filesystem waslast modified as 'yyyy-MM-dd'T'HH:mm:ssZ'"), @WritesAttribute(attribute="filename", description="The name of the file on the SFTP Server"), @WritesAttribute(attribute="path", description="The fully qualified name of the directory on the SFTP Server from which the file was pulled")})
@Stateful(scopes={Scope.CLUSTER}, description="After performing a listing of files, the timestamp of the newest file is stored. This allows the Processor to list only files that have been added or modified after this date the next time that the Processor is run. State is stored across the cluster so that this Processor can be run on Primary Node only and if a new Primary Node is selected, the new node will not duplicate the data that was listed by the previous Primary Node.")
public class ListSFTP
extends ListFileTransfer {
    @Override
    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        PropertyDescriptor port = new PropertyDescriptor.Builder().fromPropertyDescriptor(UNDEFAULTED_PORT).defaultValue("22").build();
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(HOSTNAME);
        properties.add(port);
        properties.add(USERNAME);
        properties.add(SFTPTransfer.PASSWORD);
        properties.add(SFTPTransfer.PRIVATE_KEY_PATH);
        properties.add(SFTPTransfer.PRIVATE_KEY_PASSPHRASE);
        properties.add(REMOTE_PATH);
        properties.add(DISTRIBUTED_CACHE_SERVICE);
        properties.add(SFTPTransfer.RECURSIVE_SEARCH);
        properties.add(SFTPTransfer.FILE_FILTER_REGEX);
        properties.add(SFTPTransfer.PATH_FILTER_REGEX);
        properties.add(SFTPTransfer.IGNORE_DOTTED_FILES);
        properties.add(SFTPTransfer.STRICT_HOST_KEY_CHECKING);
        properties.add(SFTPTransfer.HOST_KEY_FILE);
        properties.add(SFTPTransfer.CONNECTION_TIMEOUT);
        properties.add(SFTPTransfer.DATA_TIMEOUT);
        properties.add(SFTPTransfer.USE_KEEPALIVE_ON_TIMEOUT);
        return properties;
    }

    @Override
    protected FileTransfer getFileTransfer(ProcessContext context) {
        return new SFTPTransfer(context, this.getLogger());
    }

    @Override
    protected String getProtocolName() {
        return "sftp";
    }

    @Override
    protected Scope getStateScope(ProcessContext context) {
        return Scope.CLUSTER;
    }
}

