/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.relp.frame;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import org.apache.nifi.processors.standard.relp.frame.RELPFrame;

public class RELPEncoder {
    private final Charset charset;

    public RELPEncoder(Charset charset) {
        this.charset = charset;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public byte[] encode(RELPFrame frame) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] txnr = String.format("%s", frame.getTxnr()).getBytes(this.charset);
        buffer.write(txnr, 0, txnr.length);
        buffer.write(32);
        byte[] command = frame.getCommand().getBytes(this.charset);
        buffer.write(command, 0, command.length);
        buffer.write(32);
        byte[] dataLength = String.format("%s", frame.getDataLength()).getBytes(this.charset);
        buffer.write(dataLength, 0, dataLength.length);
        if (frame.getDataLength() > 0) {
            buffer.write(32);
            buffer.write(frame.getData(), 0, frame.getDataLength());
        }
        buffer.write(10);
        return buffer.toByteArray();
    }
}

