/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.AbstractDatabaseFetchProcessor;
import org.apache.nifi.processors.standard.ExecuteSQL;
import org.apache.nifi.processors.standard.GenerateTableFetch;
import org.apache.nifi.processors.standard.db.DatabaseAdapter;
import org.apache.nifi.processors.standard.util.JdbcCommon;
import org.apache.nifi.util.StopWatch;

@EventDriven
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@Tags(value={"sql", "select", "jdbc", "query", "database"})
@SeeAlso(value={GenerateTableFetch.class, ExecuteSQL.class})
@CapabilityDescription(value="Generates and executes a SQL select query to fetch all rows whose values in the specified Maximum Value column(s) are larger than the previously-seen maxima. Query result will be converted to Avro format. Expression Language is supported for several properties, but no incoming connections are permitted. The Variable Registry may be used to provide values for any property containing Expression Language. If it is desired to leverage flow file attributes to perform these queries, the GenerateTableFetch and/or ExecuteSQL processors can be used for this purpose. Streaming is used so arbitrarily large result sets are supported. This processor can be scheduled to run on a timer or cron expression, using the standard scheduling methods. This processor is intended to be run on the Primary Node only. FlowFile attribute 'querydbtable.row.count' indicates how many rows were selected.")
@Stateful(scopes={Scope.CLUSTER}, description="After performing a query on the specified table, the maximum values for the specified column(s) will be retained for use in future executions of the query. This allows the Processor to fetch only those records that have max values greater than the retained values. This can be used for incremental fetching, fetching of newly added rows, etc. To clear the maximum values, clear the state of the processor per the State Management documentation")
@WritesAttributes(value={@WritesAttribute(attribute="tablename", description="Name of the table being queried"), @WritesAttribute(attribute="querydbtable.row.count", description="The number of rows selected by the query"), @WritesAttribute(attribute="fragment.identifier", description="If 'Max Rows Per Flow File' is set then all FlowFiles from the same query result set will have the same value for the fragment.identifier attribute. This can then be used to correlate the results."), @WritesAttribute(attribute="fragment.count", description="If 'Max Rows Per Flow File' is set then this is the total number of  FlowFiles produced by a single ResultSet. This can be used in conjunction with the fragment.identifier attribute in order to know how many FlowFiles belonged to the same incoming ResultSet."), @WritesAttribute(attribute="fragment.index", description="If 'Max Rows Per Flow File' is set then the position of this FlowFile in the list of outgoing FlowFiles that were all derived from the same result set FlowFile. This can be used in conjunction with the fragment.identifier attribute to know which FlowFiles originated from the same query result set and in what order  FlowFiles were produced"), @WritesAttribute(attribute="maxvalue.*", description="Each attribute contains the observed maximum value of a specified 'Maximum-value Column'. The suffix of the attribute is the name of the column")})
@DynamicProperty(name="Initial Max Value", value="Attribute Expression Language", supportsExpressionLanguage=false, description="Specifies an initial max value for max value columns. Properties should be added in the format `initial.maxvalue.{max_value_column}`.")
public class QueryDatabaseTable
extends AbstractDatabaseFetchProcessor {
    public static final String RESULT_TABLENAME = "tablename";
    public static final String RESULT_ROW_COUNT = "querydbtable.row.count";
    public static final PropertyDescriptor FETCH_SIZE = new PropertyDescriptor.Builder().name("Fetch Size").description("The number of result rows to be fetched from the result set at a time. This is a hint to the driver and may not be honored and/or exact. If the value specified is zero, then the hint is ignored.").defaultValue("0").required(true).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(true).build();
    public static final PropertyDescriptor MAX_ROWS_PER_FLOW_FILE = new PropertyDescriptor.Builder().name("qdbt-max-rows").displayName("Max Rows Per Flow File").description("The maximum number of result rows that will be included in a single FlowFile. This will allow you to break up very large result sets into multiple FlowFiles. If the value specified is zero, then all rows are returned in a single FlowFile.").defaultValue("0").required(true).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(true).build();
    public static final PropertyDescriptor MAX_FRAGMENTS = new PropertyDescriptor.Builder().name("qdbt-max-frags").displayName("Maximum Number of Fragments").description("The maximum number of fragments. If the value specified is zero, then all fragments are returned. This prevents OutOfMemoryError when this processor ingests huge table.").defaultValue("0").required(true).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(true).build();

    public QueryDatabaseTable() {
        HashSet<Relationship> r = new HashSet<Relationship>();
        r.add(REL_SUCCESS);
        this.relationships = Collections.unmodifiableSet(r);
        ArrayList<PropertyDescriptor> pds = new ArrayList<PropertyDescriptor>();
        pds.add(DBCP_SERVICE);
        pds.add(DB_TYPE);
        pds.add(TABLE_NAME);
        pds.add(COLUMN_NAMES);
        pds.add(MAX_VALUE_COLUMN_NAMES);
        pds.add(QUERY_TIMEOUT);
        pds.add(FETCH_SIZE);
        pds.add(MAX_ROWS_PER_FLOW_FILE);
        pds.add(MAX_FRAGMENTS);
        pds.add(JdbcCommon.NORMALIZE_NAMES_FOR_AVRO);
        pds.add(JdbcCommon.USE_AVRO_LOGICAL_TYPES);
        pds.add(JdbcCommon.DEFAULT_PRECISION);
        pds.add(JdbcCommon.DEFAULT_SCALE);
        pds.add(WHERE_CLAUSE);
        this.propDescriptors = Collections.unmodifiableList(pds);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.propDescriptors;
    }

    @Override
    @OnScheduled
    public void setup(ProcessContext context) {
        this.maxValueProperties = this.getDefaultMaxValueProperties(context.getProperties());
        super.setup(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) throws ProcessException {
        block54: {
            StateMap stateMap;
            ProcessSession session = sessionFactory.createSession();
            ArrayList<FlowFile> resultSetFlowFiles = new ArrayList<FlowFile>();
            ComponentLog logger = this.getLogger();
            DBCPService dbcpService = (DBCPService)context.getProperty(DBCP_SERVICE).asControllerService(DBCPService.class);
            DatabaseAdapter dbAdapter = (DatabaseAdapter)dbAdapters.get(context.getProperty(DB_TYPE).getValue());
            String tableName = context.getProperty(TABLE_NAME).evaluateAttributeExpressions().getValue();
            String columnNames = context.getProperty(COLUMN_NAMES).evaluateAttributeExpressions().getValue();
            String maxValueColumnNames = context.getProperty(MAX_VALUE_COLUMN_NAMES).evaluateAttributeExpressions().getValue();
            String customWhereClause = context.getProperty(WHERE_CLAUSE).evaluateAttributeExpressions().getValue();
            Integer fetchSize = context.getProperty(FETCH_SIZE).evaluateAttributeExpressions().asInteger();
            Integer maxRowsPerFlowFile = context.getProperty(MAX_ROWS_PER_FLOW_FILE).evaluateAttributeExpressions().asInteger();
            Integer maxFragments = context.getProperty(MAX_FRAGMENTS).isSet() ? context.getProperty(MAX_FRAGMENTS).evaluateAttributeExpressions().asInteger() : 0;
            JdbcCommon.AvroConversionOptions options = JdbcCommon.AvroConversionOptions.builder().recordName(tableName).maxRows(maxRowsPerFlowFile).convertNames(context.getProperty(JdbcCommon.NORMALIZE_NAMES_FOR_AVRO).asBoolean()).useLogicalTypes(context.getProperty(JdbcCommon.USE_AVRO_LOGICAL_TYPES).asBoolean()).defaultPrecision(context.getProperty(JdbcCommon.DEFAULT_PRECISION).evaluateAttributeExpressions().asInteger()).defaultScale(context.getProperty(JdbcCommon.DEFAULT_SCALE).evaluateAttributeExpressions().asInteger()).build();
            StateManager stateManager = context.getStateManager();
            try {
                stateMap = stateManager.getState(Scope.CLUSTER);
            }
            catch (IOException ioe) {
                this.getLogger().error("Failed to retrieve observed maximum values from the State Manager. Will not perform query until this is accomplished.", (Throwable)ioe);
                context.yield();
                return;
            }
            HashMap<String, String> statePropertyMap = new HashMap<String, String>(stateMap.toMap());
            for (Map.Entry maxProp : this.maxValueProperties.entrySet()) {
                String maxPropKey = ((String)maxProp.getKey()).toLowerCase();
                String fullyQualifiedMaxPropKey = QueryDatabaseTable.getStateKey(tableName, maxPropKey);
                if (statePropertyMap.containsKey(fullyQualifiedMaxPropKey)) continue;
                String newMaxPropValue = statePropertyMap.containsKey(maxPropKey) ? (String)statePropertyMap.get(maxPropKey) : (String)maxProp.getValue();
                statePropertyMap.put(fullyQualifiedMaxPropKey, newMaxPropValue);
            }
            List<String> maxValueColumnNameList = StringUtils.isEmpty((CharSequence)maxValueColumnNames) ? null : Arrays.asList(maxValueColumnNames.split("\\s*,\\s*"));
            String selectQuery = this.getQuery(dbAdapter, tableName, columnNames, maxValueColumnNameList, customWhereClause, statePropertyMap);
            StopWatch stopWatch = new StopWatch(true);
            String fragmentIdentifier = UUID.randomUUID().toString();
            try (Connection con = dbcpService.getConnection();
                 Statement st = con.createStatement();){
                if (fetchSize != null && fetchSize > 0) {
                    try {
                        st.setFetchSize(fetchSize);
                    }
                    catch (SQLException se) {
                        logger.debug("Cannot set fetch size to {} due to {}", new Object[]{fetchSize, se.getLocalizedMessage()}, (Throwable)se);
                    }
                }
                String jdbcURL = "DBCPService";
                try {
                    DatabaseMetaData databaseMetaData = con.getMetaData();
                    if (databaseMetaData != null) {
                        jdbcURL = databaseMetaData.getURL();
                    }
                }
                catch (SQLException databaseMetaData) {
                    // empty catch block
                }
                Integer queryTimeout = context.getProperty(QUERY_TIMEOUT).evaluateAttributeExpressions().asTimePeriod(TimeUnit.SECONDS).intValue();
                st.setQueryTimeout(queryTimeout);
                logger.debug("Executing query {}", new Object[]{selectQuery});
                ResultSet resultSet = st.executeQuery(selectQuery);
                int fragmentIndex = 0;
                do {
                    AtomicLong nrOfRows = new AtomicLong(0L);
                    FlowFile fileToProcess = session.create();
                    try {
                        fileToProcess = session.write(fileToProcess, out -> {
                            MaxValueResultSetRowCollector maxValCollector = new MaxValueResultSetRowCollector(tableName, statePropertyMap, dbAdapter);
                            try {
                                nrOfRows.set(JdbcCommon.convertToAvroStream(resultSet, out, options, maxValCollector));
                            }
                            catch (RuntimeException | SQLException e) {
                                throw new ProcessException("Error during database query or conversion of records to Avro.", (Throwable)e);
                            }
                        });
                    }
                    catch (ProcessException e) {
                        resultSetFlowFiles.add(fileToProcess);
                        throw e;
                    }
                    if (nrOfRows.get() <= 0L) {
                        session.remove(fileToProcess);
                        context.yield();
                        break;
                    }
                    fileToProcess = session.putAttribute(fileToProcess, RESULT_ROW_COUNT, String.valueOf(nrOfRows.get()));
                    fileToProcess = session.putAttribute(fileToProcess, RESULT_TABLENAME, tableName);
                    fileToProcess = session.putAttribute(fileToProcess, CoreAttributes.MIME_TYPE.key(), "application/avro-binary");
                    if (maxRowsPerFlowFile > 0) {
                        fileToProcess = session.putAttribute(fileToProcess, "fragment.identifier", fragmentIdentifier);
                        fileToProcess = session.putAttribute(fileToProcess, "fragment.index", String.valueOf(fragmentIndex));
                    }
                    logger.info("{} contains {} Avro records; transferring to 'success'", new Object[]{fileToProcess, nrOfRows.get()});
                    session.getProvenanceReporter().receive(fileToProcess, jdbcURL, stopWatch.getElapsed(TimeUnit.MILLISECONDS));
                    resultSetFlowFiles.add(fileToProcess);
                } while (maxFragments <= 0 || ++fragmentIndex < maxFragments);
                for (int i = 0; i < resultSetFlowFiles.size(); ++i) {
                    for (Map.Entry entry : statePropertyMap.entrySet()) {
                        String key = (String)entry.getKey();
                        String colName = key.substring(key.lastIndexOf("@!@") + "@!@".length());
                        resultSetFlowFiles.set(i, session.putAttribute((FlowFile)resultSetFlowFiles.get(i), "maxvalue." + colName, (String)entry.getValue()));
                    }
                    if (maxRowsPerFlowFile <= 0) continue;
                    resultSetFlowFiles.set(i, session.putAttribute((FlowFile)resultSetFlowFiles.get(i), "fragment.count", Integer.toString(fragmentIndex)));
                }
                session.transfer(resultSetFlowFiles, REL_SUCCESS);
            }
            session.commit();
            try {
                stateManager.setState(statePropertyMap, Scope.CLUSTER);
            }
            catch (IOException ioe) {
                this.getLogger().error("{} failed to update State Manager, maximum observed values will not be recorded", new Object[]{this, ioe});
            }
            break block54;
            catch (SQLException | ProcessException e) {
                try {
                    logger.error("Unable to execute SQL select query {} due to {}", new Object[]{selectQuery, e});
                    if (!resultSetFlowFiles.isEmpty()) {
                        session.remove(resultSetFlowFiles);
                    }
                    context.yield();
                }
                catch (Throwable throwable) {
                    session.commit();
                    try {
                        stateManager.setState(statePropertyMap, Scope.CLUSTER);
                    }
                    catch (IOException ioe) {
                        this.getLogger().error("{} failed to update State Manager, maximum observed values will not be recorded", new Object[]{this, ioe});
                    }
                    throw throwable;
                }
                session.commit();
                try {
                    stateManager.setState(statePropertyMap, Scope.CLUSTER);
                }
                catch (IOException ioe) {
                    this.getLogger().error("{} failed to update State Manager, maximum observed values will not be recorded", new Object[]{this, ioe});
                }
            }
        }
    }

    protected String getQuery(DatabaseAdapter dbAdapter, String tableName, String columnNames, List<String> maxValColumnNames, String customWhereClause, Map<String, String> stateMap) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new IllegalArgumentException("Table name must be specified");
        }
        StringBuilder query = new StringBuilder(dbAdapter.getSelectStatement(tableName, columnNames, null, null, null, null));
        ArrayList<String> whereClauses = new ArrayList<String>();
        if (stateMap != null && !stateMap.isEmpty() && maxValColumnNames != null) {
            IntStream.range(0, maxValColumnNames.size()).forEach(index -> {
                String colName = (String)maxValColumnNames.get(index);
                String maxValueKey = QueryDatabaseTable.getStateKey(tableName, colName);
                String maxValue = (String)stateMap.get(maxValueKey);
                if (StringUtils.isEmpty((CharSequence)maxValue)) {
                    maxValue = (String)stateMap.get(colName.toLowerCase());
                }
                if (!StringUtils.isEmpty((CharSequence)maxValue)) {
                    Integer type = (Integer)this.columnTypeMap.get(maxValueKey);
                    if (type == null) {
                        throw new IllegalArgumentException("No column type found for: " + colName);
                    }
                    whereClauses.add(colName + (index == 0 ? " > " : " >= ") + QueryDatabaseTable.getLiteralByType(type, maxValue, dbAdapter.getName()));
                }
            });
        }
        if (customWhereClause != null) {
            whereClauses.add("(" + customWhereClause + ")");
        }
        if (!whereClauses.isEmpty()) {
            query.append(" WHERE ");
            query.append(StringUtils.join(whereClauses, (String)" AND "));
        }
        return query.toString();
    }

    protected class MaxValueResultSetRowCollector
    implements JdbcCommon.ResultSetRowCallback {
        DatabaseAdapter dbAdapter;
        Map<String, String> newColMap;
        String tableName;

        public MaxValueResultSetRowCollector(String tableName, Map<String, String> stateMap, DatabaseAdapter dbAdapter) {
            this.dbAdapter = dbAdapter;
            this.newColMap = stateMap;
            this.tableName = tableName;
        }

        @Override
        public void processRow(ResultSet resultSet) throws IOException {
            if (resultSet == null) {
                return;
            }
            try {
                ResultSetMetaData meta = resultSet.getMetaData();
                int nrOfColumns = meta.getColumnCount();
                if (nrOfColumns > 0) {
                    for (int i = 1; i <= nrOfColumns; ++i) {
                        String newMaxValueString;
                        String colName = meta.getColumnName(i).toLowerCase();
                        String fullyQualifiedMaxValueKey = AbstractDatabaseFetchProcessor.getStateKey(this.tableName, colName);
                        Integer type = (Integer)QueryDatabaseTable.this.columnTypeMap.get(fullyQualifiedMaxValueKey);
                        if (type == null || resultSet.getObject(i) == null) continue;
                        String maxValueString = this.newColMap.get(fullyQualifiedMaxValueKey);
                        if (StringUtils.isEmpty((CharSequence)maxValueString)) {
                            maxValueString = this.newColMap.get(colName);
                        }
                        if ((newMaxValueString = AbstractDatabaseFetchProcessor.getMaxValueFromRow(resultSet, i, type, maxValueString, this.dbAdapter.getName())) == null) continue;
                        this.newColMap.put(fullyQualifiedMaxValueKey, newMaxValueString);
                    }
                }
            }
            catch (SQLException | ParseException e) {
                throw new IOException(e);
            }
        }
    }
}

