/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.xml.sax.SAXException;

@EventDriven
@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"xml", "schema", "validation", "xsd"})
@WritesAttributes(value={@WritesAttribute(attribute="validatexml.invalid.error", description="If the flow file is routed to the invalid relationship the attribute will contain the error message resulting from the validation failure.")})
@CapabilityDescription(value="Validates the contents of FlowFiles against a user-specified XML Schema file")
public class ValidateXml
extends AbstractProcessor {
    public static final String ERROR_ATTRIBUTE_KEY = "validatexml.invalid.error";
    public static final PropertyDescriptor SCHEMA_FILE = new PropertyDescriptor.Builder().name("Schema File").description("The path to the Schema file that is to be used for validation").required(true).addValidator(StandardValidators.FILE_EXISTS_VALIDATOR).build();
    public static final Relationship REL_VALID = new Relationship.Builder().name("valid").description("FlowFiles that are successfully validated against the schema are routed to this relationship").build();
    public static final Relationship REL_INVALID = new Relationship.Builder().name("invalid").description("FlowFiles that are not valid according to the specified schema are routed to this relationship").build();
    private static final String SCHEMA_LANGUAGE = "http://www.w3.org/2001/XMLSchema";
    private List<PropertyDescriptor> properties;
    private Set<Relationship> relationships;
    private final AtomicReference<Schema> schemaRef = new AtomicReference();

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(SCHEMA_FILE);
        this.properties = Collections.unmodifiableList(properties);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_VALID);
        relationships.add(REL_INVALID);
        this.relationships = Collections.unmodifiableSet(relationships);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    @OnScheduled
    public void parseSchema(ProcessContext context) throws IOException, SAXException {
        File file = new File(context.getProperty(SCHEMA_FILE).getValue());
        SchemaFactory schemaFactory = SchemaFactory.newInstance(SCHEMA_LANGUAGE);
        Schema schema = schemaFactory.newSchema(file);
        this.schemaRef.set(schema);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        List flowFiles = session.get(50);
        if (flowFiles.isEmpty()) {
            return;
        }
        Schema schema = this.schemaRef.get();
        final Validator validator = schema.newValidator();
        ComponentLog logger = this.getLogger();
        for (FlowFile flowFile : flowFiles) {
            final AtomicBoolean valid = new AtomicBoolean(true);
            final AtomicReference<Object> exception = new AtomicReference<Object>(null);
            session.read(flowFile, new InputStreamCallback(){

                public void process(InputStream in) throws IOException {
                    try {
                        validator.validate(new StreamSource(in));
                    }
                    catch (IllegalArgumentException | SAXException e) {
                        valid.set(false);
                        exception.set(e);
                    }
                }
            });
            if (valid.get()) {
                logger.debug("Successfully validated {} against schema; routing to 'valid'", new Object[]{flowFile});
                session.getProvenanceReporter().route(flowFile, REL_VALID);
                session.transfer(flowFile, REL_VALID);
                continue;
            }
            flowFile = session.putAttribute(flowFile, ERROR_ATTRIBUTE_KEY, ((Exception)exception.get()).getLocalizedMessage());
            logger.info("Failed to validate {} against schema due to {}; routing to 'invalid'", new Object[]{flowFile, ((Exception)exception.get()).getLocalizedMessage()});
            session.getProvenanceReporter().route(flowFile, REL_INVALID);
            session.transfer(flowFile, REL_INVALID);
        }
    }
}

