/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.wnameless.json.flattener.FlattenMode;
import com.github.wnameless.json.flattener.JsonFlattener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.expression.ExpressionLanguageCompiler;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;

@Tags(value={"json", "flatten"})
@CapabilityDescription(value="Provides the user with the ability to take a nested JSON document and flatten it into a simple key/value pair document. The keys are combined at each level with a user-defined separator that defaults to '.'")
@SideEffectFree
public class FlattenJson
extends AbstractProcessor {
    static final Relationship REL_SUCCESS = new Relationship.Builder().description("Successfully flattened files go to this relationship.").name("success").build();
    static final Relationship REL_FAILURE = new Relationship.Builder().description("Files that cannot be flattened go to this relationship.").name("failure").build();
    static final PropertyDescriptor SEPARATOR = new PropertyDescriptor.Builder().name("flatten-json-separator").displayName("Separator").defaultValue(".").description("The separator character used for joining keys. Must be a JSON-legal character.").addValidator((subject, input, context) -> {
        if (context.isExpressionLanguagePresent(input)) {
            ExpressionLanguageCompiler elc = context.newExpressionLanguageCompiler();
            boolean validExpression = elc.isValidExpression(input);
            return new ValidationResult.Builder().subject(subject).input(input).valid(validExpression).explanation(validExpression ? "" : "Not a valid Expression").build();
        }
        boolean valid = input != null && input.length() == 1;
        String message = !valid ? "The separator must be a single character in length." : "";
        ObjectMapper mapper = new ObjectMapper();
        String test = String.format("{ \"prop%sprop\": \"test\" }", input);
        try {
            mapper.readValue(test, Map.class);
        }
        catch (IOException e) {
            message = e.getLocalizedMessage();
            valid = false;
        }
        return new ValidationResult.Builder().subject(subject).input(input).valid(valid).explanation(message).build();
    }).expressionLanguageSupported(true).build();
    private List<PropertyDescriptor> properties;
    private Set<Relationship> relationships;

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(SEPARATOR);
        this.properties = Collections.unmodifiableList(props);
        HashSet<Relationship> rels = new HashSet<Relationship>();
        rels.add(REL_SUCCESS);
        rels.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(rels);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String separator = context.getProperty(SEPARATOR).evaluateAttributeExpressions(flowFile).getValue();
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            session.exportTo(flowFile, (OutputStream)bos);
            bos.close();
            String raw = new String(bos.toByteArray());
            String flattened = new JsonFlattener(raw).withFlattenMode(FlattenMode.KEEP_ARRAYS).withSeparator(separator.charAt(0)).flatten();
            flowFile = session.write(flowFile, os -> os.write(flattened.getBytes()));
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (Exception ex) {
            session.transfer(flowFile, REL_FAILURE);
        }
    }
}

