/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.burgstaller.okhttp.AuthenticationCacheInterceptor;
import com.burgstaller.okhttp.CachingAuthenticatorDecorator;
import com.burgstaller.okhttp.digest.Credentials;
import com.burgstaller.okhttp.digest.DigestAuthenticator;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.tls.OkHostnameVerifier;
import okio.BufferedSink;
import org.apache.commons.io.input.TeeInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.util.ProxyAuthenticator;
import org.apache.nifi.processors.standard.util.SoftLimitBoundedByteArrayOutputStream;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.stream.io.StreamUtils;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@SupportsBatching
@Tags(value={"http", "https", "rest", "client"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_ALLOWED)
@CapabilityDescription(value="An HTTP client processor which can interact with a configurable HTTP Endpoint. The destination URL and HTTP Method are configurable. FlowFile attributes are converted to HTTP headers and the FlowFile contents are included as the body of the request (if the HTTP Method is PUT, POST or PATCH).")
@WritesAttributes(value={@WritesAttribute(attribute="invokehttp.status.code", description="The status code that is returned"), @WritesAttribute(attribute="invokehttp.status.message", description="The status message that is returned"), @WritesAttribute(attribute="invokehttp.response.body", description="In the instance where the status code received is not a success (2xx) then the response body will be put to the 'invokehttp.response.body' attribute of the request FlowFile."), @WritesAttribute(attribute="invokehttp.request.url", description="The request URL"), @WritesAttribute(attribute="invokehttp.tx.id", description="The transaction ID that is returned after reading the response"), @WritesAttribute(attribute="invokehttp.remote.dn", description="The DN of the remote server"), @WritesAttribute(attribute="invokehttp.java.exception.class", description="The Java exception class raised when the processor fails"), @WritesAttribute(attribute="invokehttp.java.exception.message", description="The Java exception message raised when the processor fails"), @WritesAttribute(attribute="user-defined", description="If the 'Put Response Body In Attribute' property is set then whatever it is set to will become the attribute key and the value would be the body of the HTTP response.")})
@DynamicProperty(name="Header Name", value="Attribute Expression Language", supportsExpressionLanguage=true, description="Send request header with a key matching the Dynamic Property Key and a value created by evaluating the Attribute Expression Language set in the value of the Dynamic Property.")
public final class InvokeHTTP
extends AbstractProcessor {
    public static final String STATUS_CODE = "invokehttp.status.code";
    public static final String STATUS_MESSAGE = "invokehttp.status.message";
    public static final String RESPONSE_BODY = "invokehttp.response.body";
    public static final String REQUEST_URL = "invokehttp.request.url";
    public static final String TRANSACTION_ID = "invokehttp.tx.id";
    public static final String REMOTE_DN = "invokehttp.remote.dn";
    public static final String EXCEPTION_CLASS = "invokehttp.java.exception.class";
    public static final String EXCEPTION_MESSAGE = "invokehttp.java.exception.message";
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    public static final Set<String> IGNORED_ATTRIBUTES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("invokehttp.status.code", "invokehttp.status.message", "invokehttp.response.body", "invokehttp.request.url", "invokehttp.tx.id", "invokehttp.remote.dn", "invokehttp.java.exception.class", "invokehttp.java.exception.message", "uuid", "filename", "path")));
    public static final PropertyDescriptor PROP_METHOD = new PropertyDescriptor.Builder().name("HTTP Method").description("HTTP request method (GET, POST, PUT, PATCH, DELETE, HEAD, OPTIONS). Arbitrary methods are also supported. Methods other than POST, PUT and PATCH will be sent without a message body.").required(true).defaultValue("GET").expressionLanguageSupported(true).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING)).build();
    public static final PropertyDescriptor PROP_URL = new PropertyDescriptor.Builder().name("Remote URL").description("Remote URL which will be connected to, including scheme, host, port, path.").required(true).expressionLanguageSupported(true).addValidator(StandardValidators.URL_VALIDATOR).build();
    public static final PropertyDescriptor PROP_CONNECT_TIMEOUT = new PropertyDescriptor.Builder().name("Connection Timeout").description("Max wait time for connection to remote service.").required(true).defaultValue("5 secs").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor PROP_READ_TIMEOUT = new PropertyDescriptor.Builder().name("Read Timeout").description("Max wait time for response from remote service.").required(true).defaultValue("15 secs").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();
    public static final PropertyDescriptor PROP_DATE_HEADER = new PropertyDescriptor.Builder().name("Include Date Header").description("Include an RFC-2616 Date header in the request.").required(true).defaultValue("True").allowableValues(new String[]{"True", "False"}).addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    public static final PropertyDescriptor PROP_FOLLOW_REDIRECTS = new PropertyDescriptor.Builder().name("Follow Redirects").description("Follow HTTP redirects issued by remote server.").required(true).defaultValue("True").allowableValues(new String[]{"True", "False"}).addValidator(StandardValidators.BOOLEAN_VALIDATOR).build();
    public static final PropertyDescriptor PROP_ATTRIBUTES_TO_SEND = new PropertyDescriptor.Builder().name("Attributes to Send").description("Regular expression that defines which attributes to send as HTTP headers in the request. If not defined, no attributes are sent as headers. Also any dynamic properties set will be sent as headers. The dynamic property key will be the header key and the dynamic property value will be interpreted as expression language will be the header value.").required(false).addValidator(StandardValidators.REGULAR_EXPRESSION_VALIDATOR).build();
    public static final PropertyDescriptor PROP_SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("The SSL Context Service used to provide client certificate information for TLS/SSL (https) connections.").required(false).identifiesControllerService(SSLContextService.class).build();
    public static final PropertyDescriptor PROP_PROXY_HOST = new PropertyDescriptor.Builder().name("Proxy Host").description("The fully qualified hostname or IP address of the proxy server").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(true).build();
    public static final PropertyDescriptor PROP_PROXY_PORT = new PropertyDescriptor.Builder().name("Proxy Port").description("The port of the proxy server").required(false).addValidator(StandardValidators.PORT_VALIDATOR).expressionLanguageSupported(true).build();
    public static final PropertyDescriptor PROP_PROXY_USER = new PropertyDescriptor.Builder().name("invokehttp-proxy-user").displayName("Proxy Username").description("Username to set when authenticating against proxy").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(true).build();
    public static final PropertyDescriptor PROP_PROXY_PASSWORD = new PropertyDescriptor.Builder().name("invokehttp-proxy-password").displayName("Proxy Password").description("Password to set when authenticating against proxy").required(false).sensitive(true).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(true).build();
    public static final PropertyDescriptor PROP_CONTENT_TYPE = new PropertyDescriptor.Builder().name("Content-Type").description("The Content-Type to specify for when content is being transmitted through a PUT, POST or PATCH. In the case of an empty value after evaluating an expression language expression, Content-Type defaults to application/octet-stream").required(true).expressionLanguageSupported(true).defaultValue("${" + CoreAttributes.MIME_TYPE.key() + "}").addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING)).build();
    public static final PropertyDescriptor PROP_SEND_BODY = new PropertyDescriptor.Builder().name("send-message-body").displayName("Send Message Body").description("If true, sends the HTTP message body on POST/PUT/PATCH requests (default).  If false, suppresses the message body and content-type header for these requests.").defaultValue("true").allowableValues(new String[]{"true", "false"}).required(false).build();
    public static final PropertyDescriptor PROP_BASIC_AUTH_USERNAME = new PropertyDescriptor.Builder().name("Basic Authentication Username").displayName("Basic Authentication Username").description("The username to be used by the client to authenticate against the Remote URL.  Cannot include control characters (0-31), ':', or DEL (127).").required(false).addValidator(StandardValidators.createRegexMatchingValidator((Pattern)Pattern.compile("^[\\x20-\\x39\\x3b-\\x7e\\x80-\\xff]+$"))).build();
    public static final PropertyDescriptor PROP_BASIC_AUTH_PASSWORD = new PropertyDescriptor.Builder().name("Basic Authentication Password").displayName("Basic Authentication Password").description("The password to be used by the client to authenticate against the Remote URL.").required(false).sensitive(true).addValidator(StandardValidators.createRegexMatchingValidator((Pattern)Pattern.compile("^[\\x20-\\x7e\\x80-\\xff]+$"))).build();
    public static final PropertyDescriptor PROP_PUT_OUTPUT_IN_ATTRIBUTE = new PropertyDescriptor.Builder().name("Put Response Body In Attribute").description("If set, the response body received back will be put into an attribute of the original FlowFile instead of a separate FlowFile. The attribute key to put to is determined by evaluating value of this property. ").addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING)).expressionLanguageSupported(true).build();
    public static final PropertyDescriptor PROP_PUT_ATTRIBUTE_MAX_LENGTH = new PropertyDescriptor.Builder().name("Max Length To Put In Attribute").description("If routing the response body to an attribute of the original (by setting the \"Put response body in attribute\" property or by receiving an error status code), the number of characters put to the attribute value will be at most this amount. This is important because attributes are held in memory and large attributes will quickly cause out of memory issues. If the output goes longer than this value, it will be truncated to fit. Consider making this smaller if able.").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).defaultValue("256").build();
    public static final PropertyDescriptor PROP_DIGEST_AUTH = new PropertyDescriptor.Builder().name("Digest Authentication").displayName("Use Digest Authentication").description("Whether to communicate with the website using Digest Authentication. 'Basic Authentication Username' and 'Basic Authentication Password' are used for authentication.").required(false).defaultValue("false").allowableValues(new String[]{"true", "false"}).build();
    public static final PropertyDescriptor PROP_OUTPUT_RESPONSE_REGARDLESS = new PropertyDescriptor.Builder().name("Always Output Response").description("Will force a response FlowFile to be generated and routed to the 'Response' relationship regardless of what the server status code received is or if the processor is configured to put the server response body in the request attribute. In the later configuration a request FlowFile with the response body in the attribute and a typical response FlowFile will be emitted to their respective relationships.").required(false).defaultValue("false").allowableValues(new String[]{"true", "false"}).build();
    public static final PropertyDescriptor PROP_TRUSTED_HOSTNAME = new PropertyDescriptor.Builder().name("Trusted Hostname").description("Bypass the normal truststore hostname verifier to allow the specified remote hostname as trusted. Enabling this property has MITM security implications, use wisely. Will still accept other connections based on the normal truststore hostname verifier. Only valid with SSL (HTTPS) connections.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).required(false).build();
    public static final PropertyDescriptor PROP_ADD_HEADERS_TO_REQUEST = new PropertyDescriptor.Builder().name("Add Response Headers to Request").description("Enabling this property saves all the response headers to the original request. This may be when the response headers are needed but a response is not generated due to the status code received.").required(false).defaultValue("false").allowableValues(new String[]{"true", "false"}).build();
    public static final PropertyDescriptor PROP_USE_CHUNKED_ENCODING = new PropertyDescriptor.Builder().name("Use Chunked Encoding").description("When POST'ing, PUT'ing or PATCH'ing content set this property to true in order to not pass the 'Content-length' header and instead send 'Transfer-Encoding' with a value of 'chunked'. This will enable the data transfer mechanism which was introduced in HTTP 1.1 to pass data of unknown lengths in chunks.").required(true).defaultValue("false").allowableValues(new String[]{"true", "false"}).build();
    public static final PropertyDescriptor PROP_PENALIZE_NO_RETRY = new PropertyDescriptor.Builder().name("Penalize on \"No Retry\"").description("Enabling this property will penalize FlowFiles that are routed to the \"No Retry\" relationship.").required(false).defaultValue("false").allowableValues(new String[]{"true", "false"}).build();
    public static final List<PropertyDescriptor> PROPERTIES = Collections.unmodifiableList(Arrays.asList(PROP_METHOD, PROP_URL, PROP_SSL_CONTEXT_SERVICE, PROP_CONNECT_TIMEOUT, PROP_READ_TIMEOUT, PROP_DATE_HEADER, PROP_FOLLOW_REDIRECTS, PROP_ATTRIBUTES_TO_SEND, PROP_BASIC_AUTH_USERNAME, PROP_BASIC_AUTH_PASSWORD, PROP_PROXY_HOST, PROP_PROXY_PORT, PROP_PROXY_USER, PROP_PROXY_PASSWORD, PROP_PUT_OUTPUT_IN_ATTRIBUTE, PROP_PUT_ATTRIBUTE_MAX_LENGTH, PROP_DIGEST_AUTH, PROP_OUTPUT_RESPONSE_REGARDLESS, PROP_TRUSTED_HOSTNAME, PROP_ADD_HEADERS_TO_REQUEST, PROP_CONTENT_TYPE, PROP_SEND_BODY, PROP_USE_CHUNKED_ENCODING, PROP_PENALIZE_NO_RETRY));
    public static final Relationship REL_SUCCESS_REQ = new Relationship.Builder().name("Original").description("The original FlowFile will be routed upon success (2xx status codes). It will have new attributes detailing the success of the request.").build();
    public static final Relationship REL_RESPONSE = new Relationship.Builder().name("Response").description("A Response FlowFile will be routed upon success (2xx status codes). If the 'Output Response Regardless' property is true then the response will be sent to this relationship regardless of the status code received.").build();
    public static final Relationship REL_RETRY = new Relationship.Builder().name("Retry").description("The original FlowFile will be routed on any status code that can be retried (5xx status codes). It will have new attributes detailing the request.").build();
    public static final Relationship REL_NO_RETRY = new Relationship.Builder().name("No Retry").description("The original FlowFile will be routed on any status code that should NOT be retried (1xx, 3xx, 4xx status codes).  It will have new attributes detailing the request.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("Failure").description("The original FlowFile will be routed on any type of connection failure, timeout or general exception. It will have new attributes detailing the request.").build();
    public static final Set<Relationship> RELATIONSHIPS = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_SUCCESS_REQ, REL_RESPONSE, REL_RETRY, REL_NO_RETRY, REL_FAILURE)));
    private volatile Set<String> dynamicPropertyNames = new HashSet<String>();
    private static final String RFC_1123 = "EEE, dd MMM yyyy HH:mm:ss 'GMT'";
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss 'GMT'").withLocale(Locale.US).withZoneUTC();
    private final AtomicReference<OkHttpClient> okHttpClientAtomicReference = new AtomicReference();
    private volatile Pattern regexAttributesToSend = null;
    private volatile boolean useChunked = false;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().required(false).name(propertyDescriptorName).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).dynamic(true).expressionLanguageSupported(true).build();
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        if (descriptor.isDynamic()) {
            HashSet<String> newDynamicPropertyNames = new HashSet<String>(this.dynamicPropertyNames);
            if (newValue == null) {
                newDynamicPropertyNames.remove(descriptor.getName());
            } else if (oldValue == null) {
                newDynamicPropertyNames.add(descriptor.getName());
            }
            this.dynamicPropertyNames = Collections.unmodifiableSet(newDynamicPropertyNames);
        } else if (PROP_ATTRIBUTES_TO_SEND.getName().equalsIgnoreCase(descriptor.getName())) {
            if (newValue == null || newValue.isEmpty()) {
                this.regexAttributesToSend = null;
            } else {
                String trimmedValue = StringUtils.trimToEmpty((String)newValue);
                this.regexAttributesToSend = Pattern.compile(trimmedValue);
            }
        }
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(3);
        boolean proxyHostSet = validationContext.getProperty(PROP_PROXY_HOST).isSet();
        boolean proxyPortSet = validationContext.getProperty(PROP_PROXY_PORT).isSet();
        if (proxyHostSet && !proxyPortSet || !proxyHostSet && proxyPortSet) {
            results.add(new ValidationResult.Builder().subject("Proxy Host and Port").valid(false).explanation("If Proxy Host or Proxy Port is set, both must be set").build());
        }
        boolean proxyUserSet = validationContext.getProperty(PROP_PROXY_USER).isSet();
        boolean proxyPwdSet = validationContext.getProperty(PROP_PROXY_PASSWORD).isSet();
        if (proxyUserSet && !proxyPwdSet || !proxyUserSet && proxyPwdSet) {
            results.add(new ValidationResult.Builder().subject("Proxy User and Password").valid(false).explanation("If Proxy Username or Proxy Password is set, both must be set").build());
        }
        if (proxyUserSet && !proxyHostSet) {
            results.add(new ValidationResult.Builder().subject("Proxy").valid(false).explanation("If Proxy username is set, proxy host must be set").build());
        }
        return results;
    }

    @OnScheduled
    public void setUpClient(ProcessContext context) throws IOException, UnrecoverableKeyException, CertificateException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        String trustedHostname;
        SSLContext sslContext;
        this.okHttpClientAtomicReference.set(null);
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient().newBuilder();
        String proxyHost = context.getProperty(PROP_PROXY_HOST).evaluateAttributeExpressions().getValue();
        Integer proxyPort = context.getProperty(PROP_PROXY_PORT).evaluateAttributeExpressions().asInteger();
        if (proxyHost != null && proxyPort != null) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, (int)proxyPort));
            okHttpClientBuilder.proxy(proxy);
        }
        okHttpClientBuilder.connectTimeout((long)context.getProperty(PROP_CONNECT_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue(), TimeUnit.MILLISECONDS);
        okHttpClientBuilder.readTimeout((long)context.getProperty(PROP_READ_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue(), TimeUnit.MILLISECONDS);
        okHttpClientBuilder.followRedirects(context.getProperty(PROP_FOLLOW_REDIRECTS).asBoolean().booleanValue());
        SSLContextService sslService = (SSLContextService)context.getProperty(PROP_SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
        SSLContext sSLContext = sslContext = sslService == null ? null : sslService.createSSLContext(SSLContextService.ClientAuth.NONE);
        if (sslContext != null) {
            this.setSslSocketFactory(okHttpClientBuilder, sslService, sslContext);
        }
        if (!(trustedHostname = StringUtils.trimToEmpty((String)context.getProperty(PROP_TRUSTED_HOSTNAME).getValue())).isEmpty()) {
            okHttpClientBuilder.hostnameVerifier((HostnameVerifier)new OverrideHostnameVerifier(trustedHostname, (HostnameVerifier)OkHostnameVerifier.INSTANCE));
        }
        this.setAuthenticator(okHttpClientBuilder, context);
        this.useChunked = context.getProperty(PROP_USE_CHUNKED_ENCODING).asBoolean();
        this.okHttpClientAtomicReference.set(okHttpClientBuilder.build());
    }

    private void setSslSocketFactory(OkHttpClient.Builder okHttpClientBuilder, SSLContextService sslService, SSLContext sslContext) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException {
        TrustManager[] trustManagers;
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("X509");
        KeyManager[] keyManagers = null;
        if (sslService.isKeyStoreConfigured()) {
            String keystoreLocation = sslService.getKeyStoreFile();
            String keystorePass = sslService.getKeyStorePassword();
            String keystoreType = sslService.getKeyStoreType();
            KeyStore keyStore = KeyStore.getInstance(keystoreType);
            try (FileInputStream keyStoreStream = new FileInputStream(keystoreLocation);){
                keyStore.load(keyStoreStream, keystorePass.toCharArray());
            }
            keyManagerFactory.init(keyStore, keystorePass.toCharArray());
            keyManagers = keyManagerFactory.getKeyManagers();
        }
        if (sslService.isTrustStoreConfigured()) {
            String truststoreLocation = sslService.getTrustStoreFile();
            String truststorePass = sslService.getTrustStorePassword();
            String truststoreType = sslService.getTrustStoreType();
            KeyStore truststore = KeyStore.getInstance(truststoreType);
            truststore.load(new FileInputStream(truststoreLocation), truststorePass.toCharArray());
            trustManagerFactory.init(truststore);
        }
        if ((trustManagers = trustManagerFactory.getTrustManagers())[0] == null) {
            throw new IllegalStateException("List of trust managers is null");
        }
        X509TrustManager x509TrustManager = (X509TrustManager)trustManagers[0];
        sslContext.init(keyManagers, trustManagerFactory.getTrustManagers(), null);
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        okHttpClientBuilder.sslSocketFactory(sslSocketFactory, x509TrustManager);
    }

    private void setAuthenticator(OkHttpClient.Builder okHttpClientBuilder, ProcessContext context) {
        String authUser = StringUtils.trimToEmpty((String)context.getProperty(PROP_BASIC_AUTH_USERNAME).getValue());
        String proxyUsername = StringUtils.trimToEmpty((String)context.getProperty(PROP_PROXY_USER).evaluateAttributeExpressions().getValue());
        if (!authUser.isEmpty() && "true".equalsIgnoreCase(context.getProperty(PROP_DIGEST_AUTH).getValue())) {
            String authPass = StringUtils.trimToEmpty((String)context.getProperty(PROP_BASIC_AUTH_PASSWORD).getValue());
            ConcurrentHashMap authCache = new ConcurrentHashMap();
            Credentials credentials = new Credentials(authUser, authPass);
            DigestAuthenticator digestAuthenticator = new DigestAuthenticator(credentials);
            if (!proxyUsername.isEmpty()) {
                String proxyPassword = context.getProperty(PROP_PROXY_PASSWORD).evaluateAttributeExpressions().getValue();
                ProxyAuthenticator proxyAuthenticator = new ProxyAuthenticator(proxyUsername, proxyPassword);
                okHttpClientBuilder.proxyAuthenticator((Authenticator)proxyAuthenticator);
            }
            okHttpClientBuilder.interceptors().add(new AuthenticationCacheInterceptor(authCache));
            okHttpClientBuilder.authenticator((Authenticator)new CachingAuthenticatorDecorator((Authenticator)digestAuthenticator, authCache));
        } else if (!proxyUsername.isEmpty()) {
            String proxyPassword = context.getProperty(PROP_PROXY_PASSWORD).evaluateAttributeExpressions().getValue();
            ProxyAuthenticator proxyAuthenticator = new ProxyAuthenticator(proxyUsername, proxyPassword);
            okHttpClientBuilder.proxyAuthenticator((Authenticator)proxyAuthenticator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        OkHttpClient okHttpClient = this.okHttpClientAtomicReference.get();
        FlowFile requestFlowFile = session.get();
        boolean putToAttribute = context.getProperty(PROP_PUT_OUTPUT_IN_ATTRIBUTE).isSet();
        if (requestFlowFile == null) {
            if (context.hasNonLoopConnection()) {
                return;
            }
            String request = context.getProperty(PROP_METHOD).evaluateAttributeExpressions().getValue().toUpperCase();
            if ("POST".equals(request) || "PUT".equals(request) || "PATCH".equals(request)) {
                return;
            }
            if (putToAttribute) {
                requestFlowFile = session.create();
            }
        }
        int maxAttributeSize = context.getProperty(PROP_PUT_ATTRIBUTE_MAX_LENGTH).asInteger();
        ComponentLog logger = this.getLogger();
        UUID txId = UUID.randomUUID();
        FlowFile responseFlowFile = null;
        try {
            String urlstr = StringUtils.trimToEmpty((String)context.getProperty(PROP_URL).evaluateAttributeExpressions(requestFlowFile).getValue());
            URL url = new URL(urlstr);
            Request httpRequest = this.configureRequest(context, session, requestFlowFile, url);
            this.logRequest(logger, httpRequest);
            if (httpRequest.body() != null) {
                session.getProvenanceReporter().send(requestFlowFile, url.toExternalForm(), true);
            }
            long startNanos = System.nanoTime();
            Response responseHttp = okHttpClient.newCall(httpRequest).execute();
            this.logResponse(logger, url, responseHttp);
            int statusCode = responseHttp.code();
            String statusMessage = responseHttp.message();
            if (statusCode == 0) {
                throw new IllegalStateException("Status code unknown, connection hasn't been attempted.");
            }
            HashMap<String, String> statusAttributes = new HashMap<String, String>();
            statusAttributes.put(STATUS_CODE, String.valueOf(statusCode));
            statusAttributes.put(STATUS_MESSAGE, statusMessage);
            statusAttributes.put(REQUEST_URL, url.toExternalForm());
            statusAttributes.put(TRANSACTION_ID, txId.toString());
            if (requestFlowFile != null) {
                requestFlowFile = session.putAllAttributes(requestFlowFile, statusAttributes);
            }
            if (context.getProperty(PROP_ADD_HEADERS_TO_REQUEST).asBoolean().booleanValue() && requestFlowFile != null) {
                requestFlowFile = session.putAllAttributes(requestFlowFile, this.convertAttributesFromHeaders(url, responseHttp));
            }
            boolean outputBodyToRequestAttribute = (!this.isSuccess(statusCode) || putToAttribute) && requestFlowFile != null;
            boolean outputBodyToResponseContent = this.isSuccess(statusCode) && !putToAttribute || context.getProperty(PROP_OUTPUT_RESPONSE_REGARDLESS).asBoolean() != false;
            ResponseBody responseBody = responseHttp.body();
            boolean bodyExists = responseBody != null;
            InputStream responseBodyStream = null;
            OutputStream outputStreamToRequestAttribute = null;
            TeeInputStream teeInputStream = null;
            try {
                InputStream inputStream = responseBodyStream = bodyExists ? responseBody.byteStream() : null;
                if (responseBodyStream != null && outputBodyToRequestAttribute && outputBodyToResponseContent) {
                    outputStreamToRequestAttribute = new SoftLimitBoundedByteArrayOutputStream(maxAttributeSize);
                    teeInputStream = new TeeInputStream(responseBodyStream, outputStreamToRequestAttribute);
                }
                if (outputBodyToResponseContent) {
                    responseFlowFile = requestFlowFile != null ? session.create(requestFlowFile) : session.create();
                    responseFlowFile = session.putAllAttributes(responseFlowFile, statusAttributes);
                    responseFlowFile = session.putAllAttributes(responseFlowFile, this.convertAttributesFromHeaders(url, responseHttp));
                    if (bodyExists) {
                        if (responseBody.contentType() != null) {
                            responseFlowFile = session.putAttribute(responseFlowFile, CoreAttributes.MIME_TYPE.key(), responseBody.contentType().toString());
                        }
                        responseFlowFile = teeInputStream != null ? session.importFrom((InputStream)teeInputStream, responseFlowFile) : session.importFrom(responseBodyStream, responseFlowFile);
                        long millis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
                        if (requestFlowFile != null) {
                            session.getProvenanceReporter().fetch(responseFlowFile, url.toExternalForm(), millis);
                        } else {
                            session.getProvenanceReporter().receive(responseFlowFile, url.toExternalForm(), millis);
                        }
                    }
                }
                if (outputBodyToRequestAttribute && bodyExists) {
                    int size;
                    byte[] outputBuffer;
                    String attributeKey = context.getProperty(PROP_PUT_OUTPUT_IN_ATTRIBUTE).evaluateAttributeExpressions(requestFlowFile).getValue();
                    if (attributeKey == null) {
                        attributeKey = RESPONSE_BODY;
                    }
                    if (outputStreamToRequestAttribute != null) {
                        outputBuffer = ((SoftLimitBoundedByteArrayOutputStream)outputStreamToRequestAttribute).getBuffer();
                        size = ((SoftLimitBoundedByteArrayOutputStream)outputStreamToRequestAttribute).size();
                    } else {
                        outputBuffer = new byte[maxAttributeSize];
                        size = StreamUtils.fillBuffer((InputStream)responseBodyStream, (byte[])outputBuffer, (boolean)false);
                    }
                    String bodyString = new String(outputBuffer, 0, size, this.getCharsetFromMediaType(responseBody.contentType()));
                    requestFlowFile = session.putAttribute(requestFlowFile, attributeKey, bodyString);
                    long millis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
                    session.getProvenanceReporter().modifyAttributes(requestFlowFile, "The " + attributeKey + " has been added. The value of which is the body of a http call to " + url.toExternalForm() + ". It took " + millis + "millis,");
                }
            }
            finally {
                if (outputStreamToRequestAttribute != null) {
                    outputStreamToRequestAttribute.close();
                    outputStreamToRequestAttribute = null;
                }
                if (teeInputStream != null) {
                    teeInputStream.close();
                    teeInputStream = null;
                } else if (responseBodyStream != null) {
                    responseBodyStream.close();
                    responseBodyStream = null;
                }
            }
            this.route(requestFlowFile, responseFlowFile, session, context, statusCode);
        }
        catch (Exception e) {
            if (requestFlowFile != null) {
                logger.error("Routing to {} due to exception: {}", new Object[]{REL_FAILURE.getName(), e}, (Throwable)e);
                requestFlowFile = session.penalize(requestFlowFile);
                requestFlowFile = session.putAttribute(requestFlowFile, EXCEPTION_CLASS, e.getClass().getName());
                requestFlowFile = session.putAttribute(requestFlowFile, EXCEPTION_MESSAGE, e.getMessage());
                session.transfer(requestFlowFile, REL_FAILURE);
            } else {
                logger.error("Yielding processor due to exception encountered as a source processor: {}", (Throwable)e);
                context.yield();
            }
            try {
                if (responseFlowFile != null) {
                    session.remove(responseFlowFile);
                }
            }
            catch (Exception e1) {
                logger.error("Could not cleanup response flowfile due to exception: {}", new Object[]{e1}, (Throwable)e1);
            }
        }
    }

    private Request configureRequest(ProcessContext context, ProcessSession session, FlowFile requestFlowFile, URL url) {
        String method;
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder = requestBuilder.url(url);
        String authUser = StringUtils.trimToEmpty((String)context.getProperty(PROP_BASIC_AUTH_USERNAME).getValue());
        if (!authUser.isEmpty() && "false".equalsIgnoreCase(context.getProperty(PROP_DIGEST_AUTH).getValue())) {
            String authPass = StringUtils.trimToEmpty((String)context.getProperty(PROP_BASIC_AUTH_PASSWORD).getValue());
            String credential = okhttp3.Credentials.basic((String)authUser, (String)authPass);
            requestBuilder = requestBuilder.header("Authorization", credential);
        }
        switch (method = StringUtils.trimToEmpty((String)context.getProperty(PROP_METHOD).evaluateAttributeExpressions(requestFlowFile).getValue()).toUpperCase()) {
            case "GET": {
                requestBuilder = requestBuilder.get();
                break;
            }
            case "POST": {
                RequestBody requestBody = this.getRequestBodyToSend(session, context, requestFlowFile);
                requestBuilder = requestBuilder.post(requestBody);
                break;
            }
            case "PUT": {
                RequestBody requestBody = this.getRequestBodyToSend(session, context, requestFlowFile);
                requestBuilder = requestBuilder.put(requestBody);
                break;
            }
            case "PATCH": {
                RequestBody requestBody = this.getRequestBodyToSend(session, context, requestFlowFile);
                requestBuilder = requestBuilder.patch(requestBody);
                break;
            }
            case "HEAD": {
                requestBuilder = requestBuilder.head();
                break;
            }
            case "DELETE": {
                requestBuilder = requestBuilder.delete();
                break;
            }
            default: {
                requestBuilder = requestBuilder.method(method, null);
            }
        }
        requestBuilder = this.setHeaderProperties(context, requestBuilder, requestFlowFile);
        return requestBuilder.build();
    }

    private RequestBody getRequestBodyToSend(final ProcessSession session, final ProcessContext context, final FlowFile requestFlowFile) {
        if (context.getProperty(PROP_SEND_BODY).asBoolean().booleanValue()) {
            return new RequestBody(){

                public MediaType contentType() {
                    String contentType = context.getProperty(PROP_CONTENT_TYPE).evaluateAttributeExpressions(requestFlowFile).getValue();
                    contentType = StringUtils.isBlank((CharSequence)contentType) ? InvokeHTTP.DEFAULT_CONTENT_TYPE : contentType;
                    return MediaType.parse((String)contentType);
                }

                public void writeTo(BufferedSink sink) throws IOException {
                    session.exportTo(requestFlowFile, sink.outputStream());
                }

                public long contentLength() {
                    return InvokeHTTP.this.useChunked ? -1L : requestFlowFile.getSize();
                }
            };
        }
        return RequestBody.create(null, (byte[])new byte[0]);
    }

    private Request.Builder setHeaderProperties(ProcessContext context, Request.Builder requestBuilder, FlowFile requestFlowFile) {
        if (context.getProperty(PROP_DATE_HEADER).asBoolean().booleanValue()) {
            requestBuilder = requestBuilder.addHeader("Date", DATE_FORMAT.print(System.currentTimeMillis()));
        }
        for (String headerKey : this.dynamicPropertyNames) {
            String headerValue = context.getProperty(headerKey).evaluateAttributeExpressions(requestFlowFile).getValue();
            requestBuilder = requestBuilder.addHeader(headerKey, headerValue);
        }
        if (this.regexAttributesToSend != null && requestFlowFile != null) {
            Map attributes = requestFlowFile.getAttributes();
            Matcher m = this.regexAttributesToSend.matcher("");
            for (Map.Entry entry : attributes.entrySet()) {
                String headerKey = StringUtils.trimToEmpty((String)((String)entry.getKey()));
                if (IGNORED_ATTRIBUTES.contains(headerKey)) continue;
                m.reset(headerKey);
                if (!m.matches()) continue;
                String headerVal = StringUtils.trimToEmpty((String)((String)entry.getValue()));
                requestBuilder = requestBuilder.addHeader(headerKey, headerVal);
            }
        }
        return requestBuilder;
    }

    private void route(FlowFile request, FlowFile response, ProcessSession session, ProcessContext context, int statusCode) {
        if (!this.isSuccess(statusCode) && request == null) {
            context.yield();
        }
        boolean responseSent = false;
        if (context.getProperty(PROP_OUTPUT_RESPONSE_REGARDLESS).asBoolean().booleanValue()) {
            session.transfer(response, REL_RESPONSE);
            responseSent = true;
        }
        if (this.isSuccess(statusCode)) {
            if (request != null) {
                session.transfer(request, REL_SUCCESS_REQ);
            }
            if (response != null && !responseSent) {
                session.transfer(response, REL_RESPONSE);
            }
        } else if (statusCode / 100 == 5) {
            if (request != null) {
                request = session.penalize(request);
                session.transfer(request, REL_RETRY);
            }
        } else if (request != null) {
            if (context.getProperty(PROP_PENALIZE_NO_RETRY).asBoolean().booleanValue()) {
                request = session.penalize(request);
            }
            session.transfer(request, REL_NO_RETRY);
        }
    }

    private boolean isSuccess(int statusCode) {
        return statusCode / 100 == 2;
    }

    private void logRequest(ComponentLog logger, Request request) {
        logger.debug("\nRequest to remote service:\n\t{}\n{}", new Object[]{request.url().url().toExternalForm(), this.getLogString(request.headers().toMultimap())});
    }

    private void logResponse(ComponentLog logger, URL url, Response response) {
        logger.debug("\nResponse from remote service:\n\t{}\n{}", new Object[]{url.toExternalForm(), this.getLogString(response.headers().toMultimap())});
    }

    private String getLogString(Map<String, List<String>> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            List<String> list = entry.getValue();
            if (list.isEmpty()) continue;
            sb.append("\t");
            sb.append(entry.getKey());
            sb.append(": ");
            if (list.size() == 1) {
                sb.append(list.get(0));
            } else {
                sb.append(list.toString());
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private String csv(Collection<String> values) {
        if (values == null || values.isEmpty()) {
            return "";
        }
        if (values.size() == 1) {
            return values.iterator().next();
        }
        StringBuilder sb = new StringBuilder();
        for (String value : values) {
            if ((value = value.trim()).isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(value);
        }
        return sb.toString().trim();
    }

    private Map<String, String> convertAttributesFromHeaders(URL url, Response responseHttp) {
        HashMap<String, String> map = new HashMap<String, String>();
        responseHttp.headers().names().forEach(key -> {
            if (key == null) {
                return;
            }
            List values = responseHttp.headers().values(key);
            if (values == null || values.isEmpty()) {
                return;
            }
            String value = this.csv(values);
            map.put((String)key, value);
        });
        if ("HTTPS".equals(url.getProtocol().toUpperCase())) {
            map.put(REMOTE_DN, responseHttp.handshake().peerPrincipal().getName());
        }
        return map;
    }

    private Charset getCharsetFromMediaType(MediaType contentType) {
        return contentType != null ? contentType.charset(StandardCharsets.UTF_8) : StandardCharsets.UTF_8;
    }

    private static class OverrideHostnameVerifier
    implements HostnameVerifier {
        private final String trustedHostname;
        private final HostnameVerifier delegate;

        private OverrideHostnameVerifier(String trustedHostname, HostnameVerifier delegate) {
            this.trustedHostname = trustedHostname;
            this.delegate = delegate;
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            if (this.trustedHostname.equalsIgnoreCase(hostname)) {
                return true;
            }
            return this.delegate.verify(hostname, session);
        }
    }
}

