/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.db.impl;

import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.processors.standard.db.DatabaseAdapter;

public class MSSQL2008DatabaseAdapter
implements DatabaseAdapter {
    @Override
    public String getName() {
        return "MS SQL 2008";
    }

    @Override
    public String getDescription() {
        return "Generates MS SQL Compatible SQL for version 2008";
    }

    @Override
    public String getSelectStatement(String tableName, String columnNames, String whereClause, String orderByClause, Long limit, Long offset) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new IllegalArgumentException("Table name cannot be null or empty");
        }
        StringBuilder query = new StringBuilder("SELECT ");
        if (limit != null) {
            long effectiveOffset;
            if (offset != null) {
                query.append("* FROM (SELECT ");
            }
            long l = effectiveOffset = offset == null ? 0L : offset;
            if (effectiveOffset + limit > 0L) {
                query.append("TOP ");
                query.append(effectiveOffset + limit);
                query.append(" ");
            }
        }
        if (StringUtils.isEmpty((CharSequence)columnNames) || columnNames.trim().equals("*")) {
            query.append("*");
        } else {
            query.append(columnNames);
        }
        if (limit != null && offset != null && orderByClause != null) {
            query.append(", ROW_NUMBER() OVER(ORDER BY ");
            query.append(orderByClause);
            query.append(" asc) rnum");
        }
        query.append(" FROM ");
        query.append(tableName);
        if (!StringUtils.isEmpty((CharSequence)whereClause)) {
            query.append(" WHERE ");
            query.append(whereClause);
        }
        if (!StringUtils.isEmpty((CharSequence)orderByClause)) {
            query.append(" ORDER BY ");
            query.append(orderByClause);
        }
        if (limit != null && offset != null) {
            query.append(") A WHERE rnum > ");
            query.append(offset);
            query.append(" AND rnum <= ");
            query.append(offset + limit);
        }
        return query.toString();
    }
}

