/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.eclipse.jetty.util.StringUtil;

@EventDriven
@SideEffectFree
@SupportsBatching
@Tags(value={"attributes", "logging"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Emits a log message at the specified log level")
public class LogMessage
extends AbstractProcessor {
    public static final PropertyDescriptor LOG_LEVEL = new PropertyDescriptor.Builder().name("log-level").displayName("Log Level").required(true).description("The Log Level to use when logging the message").allowableValues((Enum[])MessageLogLevel.values()).defaultValue(MessageLogLevel.info.toString()).expressionLanguageSupported(true).build();
    public static final PropertyDescriptor LOG_PREFIX = new PropertyDescriptor.Builder().name("log-prefix").displayName("Log prefix").required(false).description("Log prefix appended to the log lines. It helps to distinguish the output of multiple LogMessage processors.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(true).build();
    public static final PropertyDescriptor LOG_MESSAGE = new PropertyDescriptor.Builder().name("log-message").displayName("Log message").required(false).description("The log message to emit").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(true).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All FlowFiles are routed to this relationship").build();
    private static final int CHUNK_SIZE = 50;
    private Set<Relationship> relationships;
    private List<PropertyDescriptor> supportedDescriptors;

    protected void init(ProcessorInitializationContext context) {
        HashSet<Relationship> procRels = new HashSet<Relationship>();
        procRels.add(REL_SUCCESS);
        this.relationships = Collections.unmodifiableSet(procRels);
        ArrayList<PropertyDescriptor> supDescriptors = new ArrayList<PropertyDescriptor>();
        supDescriptors.add(LOG_LEVEL);
        supDescriptors.add(LOG_PREFIX);
        supDescriptors.add(LOG_MESSAGE);
        this.supportedDescriptors = Collections.unmodifiableList(supDescriptors);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.supportedDescriptors;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        MessageLogLevel logLevel;
        String logLevelValue = context.getProperty(LOG_LEVEL).getValue().toLowerCase();
        try {
            logLevel = MessageLogLevel.valueOf(logLevelValue);
        }
        catch (Exception e) {
            throw new ProcessException((Throwable)e);
        }
        ComponentLog logger = this.getLogger();
        boolean isLogLevelEnabled = false;
        switch (logLevel) {
            case trace: {
                isLogLevelEnabled = logger.isTraceEnabled();
                break;
            }
            case debug: {
                isLogLevelEnabled = logger.isDebugEnabled();
                break;
            }
            case info: {
                isLogLevelEnabled = logger.isInfoEnabled();
                break;
            }
            case warn: {
                isLogLevelEnabled = logger.isWarnEnabled();
                break;
            }
            case error: {
                isLogLevelEnabled = logger.isErrorEnabled();
            }
        }
        if (!isLogLevelEnabled) {
            this.transferChunk(session);
            return;
        }
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        this.processFlowFile(logger, logLevel, flowFile, context);
        session.transfer(flowFile, REL_SUCCESS);
    }

    private void processFlowFile(ComponentLog logger, MessageLogLevel logLevel, FlowFile flowFile, ProcessContext context) {
        String logPrefix = context.getProperty(LOG_PREFIX).evaluateAttributeExpressions(flowFile).getValue();
        String logMessage = context.getProperty(LOG_MESSAGE).evaluateAttributeExpressions(flowFile).getValue();
        String messageToWrite = StringUtil.isBlank((String)logPrefix) ? logMessage : String.format("%s%s", logPrefix, logMessage);
        switch (logLevel) {
            case info: {
                logger.info(messageToWrite);
                break;
            }
            case debug: {
                logger.debug(messageToWrite);
                break;
            }
            case warn: {
                logger.warn(messageToWrite);
                break;
            }
            case trace: {
                logger.trace(messageToWrite);
                break;
            }
            case error: {
                logger.error(messageToWrite);
                break;
            }
            default: {
                logger.debug(messageToWrite);
            }
        }
    }

    private void transferChunk(ProcessSession session) {
        List flowFiles = session.get(50);
        if (!flowFiles.isEmpty()) {
            session.transfer((Collection)flowFiles, REL_SUCCESS);
        }
    }

    static enum MessageLogLevel {
        trace,
        debug,
        info,
        warn,
        error;

    }
}

