/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.db.impl;

import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.processors.standard.db.DatabaseAdapter;

public class MSSQLDatabaseAdapter
implements DatabaseAdapter {
    @Override
    public String getName() {
        return "MS SQL 2012+";
    }

    @Override
    public String getDescription() {
        return "Generates MS SQL Compatible SQL, for version 2012 or greater";
    }

    @Override
    public String getSelectStatement(String tableName, String columnNames, String whereClause, String orderByClause, Long limit, Long offset) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new IllegalArgumentException("Table name cannot be null or empty");
        }
        StringBuilder query = new StringBuilder("SELECT ");
        if (limit != null && offset == null) {
            query.append("TOP ");
            query.append(limit);
            query.append(" ");
        }
        if (StringUtils.isEmpty((CharSequence)columnNames) || columnNames.trim().equals("*")) {
            query.append("*");
        } else {
            query.append(columnNames);
        }
        query.append(" FROM ");
        query.append(tableName);
        if (!StringUtils.isEmpty((CharSequence)whereClause)) {
            query.append(" WHERE ");
            query.append(whereClause);
        }
        if (!StringUtils.isEmpty((CharSequence)orderByClause)) {
            query.append(" ORDER BY ");
            query.append(orderByClause);
        }
        if (offset != null && limit != null && limit > 0L) {
            if (StringUtils.isEmpty((CharSequence)orderByClause)) {
                throw new IllegalArgumentException("Order by clause cannot be null or empty when using row paging");
            }
            query.append(" OFFSET ");
            query.append(offset);
            query.append(" ROWS");
            query.append(" FETCH NEXT ");
            query.append(limit);
            query.append(" ROWS ONLY");
        }
        return query.toString();
    }
}

