/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.expression.AttributeValueDecorator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.util.StopWatch;

@EventDriven
@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"Text", "Regular Expression", "Update", "Change", "Replace", "Modify", "Regex", "Mapping"})
@CapabilityDescription(value="Updates the content of a FlowFile by evaluating a Regular Expression against it and replacing the section of the content that matches the Regular Expression with some alternate value provided in a mapping file.")
public class ReplaceTextWithMapping
extends AbstractProcessor {
    public static final PropertyDescriptor REGEX = new PropertyDescriptor.Builder().name("Regular Expression").description("The Regular Expression to search for in the FlowFile content").required(true).addValidator(StandardValidators.createRegexValidator((int)0, (int)Integer.MAX_VALUE, (boolean)true)).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).defaultValue("\\S+").build();
    public static final PropertyDescriptor MATCHING_GROUP_FOR_LOOKUP_KEY = new PropertyDescriptor.Builder().name("Matching Group").description("The number of the matching group of the provided regex to replace with the corresponding value from the mapping file (if it exists).").addValidator(StandardValidators.INTEGER_VALIDATOR).required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).defaultValue("0").build();
    public static final PropertyDescriptor MAPPING_FILE = new PropertyDescriptor.Builder().name("Mapping File").description("The name of the file (including the full path) containing the Mappings.").addValidator(StandardValidators.FILE_EXISTS_VALIDATOR).required(true).build();
    public static final PropertyDescriptor MAPPING_FILE_REFRESH_INTERVAL = new PropertyDescriptor.Builder().name("Mapping File Refresh Interval").description("The polling interval in seconds to check for updates to the mapping file. The default is 60s.").addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).required(true).defaultValue("60s").build();
    public static final PropertyDescriptor CHARACTER_SET = new PropertyDescriptor.Builder().name("Character Set").description("The Character Set in which the file is encoded").required(true).addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).defaultValue("UTF-8").build();
    public static final PropertyDescriptor MAX_BUFFER_SIZE = new PropertyDescriptor.Builder().name("Maximum Buffer Size").description("Specifies the maximum amount of data to buffer (per file) in order to apply the regular expressions. If a FlowFile is larger than this value, the FlowFile will be routed to 'failure'").required(true).addValidator(StandardValidators.DATA_SIZE_VALIDATOR).defaultValue("1 MB").build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles that have been successfully updated are routed to this relationship, as well as FlowFiles whose content does not match the given Regular Expression").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles that could not be updated are routed to this relationship").build();
    private final Pattern backReferencePattern = Pattern.compile("[^\\\\]\\$(\\d+)");
    private List<PropertyDescriptor> properties;
    private Set<Relationship> relationships;
    private final ReentrantLock processorLock = new ReentrantLock();
    private final AtomicLong lastModified = new AtomicLong(0L);
    final AtomicLong mappingTestTime = new AtomicLong(0L);
    private final AtomicReference<ConfigurationState> configurationStateRef = new AtomicReference<ConfigurationState>(new ConfigurationState(null));

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        ArrayList<ValidationResult> errors = new ArrayList<ValidationResult>(super.customValidate(context));
        String regexValue = context.getProperty(REGEX).evaluateAttributeExpressions().getValue();
        int numCapturingGroups = Pattern.compile(regexValue).matcher("").groupCount();
        int groupToMatch = context.getProperty(MATCHING_GROUP_FOR_LOOKUP_KEY).evaluateAttributeExpressions().asInteger();
        if (groupToMatch > numCapturingGroups) {
            errors.add(new ValidationResult.Builder().subject("Insufficient Matching Groups").valid(false).explanation("The specified matching group does not exist for the regular expression provided").build());
        }
        return errors;
    }

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(REGEX);
        properties.add(MATCHING_GROUP_FOR_LOOKUP_KEY);
        properties.add(MAPPING_FILE);
        properties.add(MAPPING_FILE_REFRESH_INTERVAL);
        properties.add(CHARACTER_SET);
        properties.add(MAX_BUFFER_SIZE);
        this.properties = Collections.unmodifiableList(properties);
        HashSet<Relationship> relationships = new HashSet<Relationship>();
        relationships.add(REL_SUCCESS);
        relationships.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(relationships);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        this.updateMapping(context);
        List flowFiles = session.get(5);
        if (flowFiles.isEmpty()) {
            return;
        }
        ComponentLog logger = this.getLogger();
        int maxBufferSize = context.getProperty(MAX_BUFFER_SIZE).asDataSize(DataUnit.B).intValue();
        for (FlowFile flowFile : flowFiles) {
            if (flowFile.getSize() > (long)maxBufferSize) {
                session.transfer(flowFile, REL_FAILURE);
                continue;
            }
            StopWatch stopWatch = new StopWatch(true);
            flowFile = session.write(flowFile, (StreamCallback)new ReplaceTextCallback(context, flowFile, maxBufferSize));
            logger.info("Transferred {} to 'success'", new Object[]{flowFile});
            session.getProvenanceReporter().modifyContent(flowFile, stopWatch.getElapsed(TimeUnit.MILLISECONDS));
            session.transfer(flowFile, REL_SUCCESS);
        }
    }

    protected String fillReplacementValueBackReferences(String rawReplacementValue, int numCapturingGroups) {
        String replacement = rawReplacementValue;
        Matcher backRefMatcher = this.backReferencePattern.matcher(replacement);
        int replacementCount = 0;
        while (backRefMatcher.find()) {
            int backRefIndex = Integer.parseInt(backRefMatcher.group(1));
            if (backRefIndex <= numCapturingGroups && backRefIndex >= 0) continue;
            StringBuilder sb = new StringBuilder(replacement.length() + 1);
            int groupStart = backRefMatcher.start(1) + replacementCount++;
            sb.append(replacement.substring(0, groupStart - 1));
            sb.append("\\");
            sb.append(replacement.substring(groupStart - 1));
            replacement = sb.toString();
        }
        replacement = replacement.replaceAll("(\\$\\D)", "\\\\$1");
        return replacement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMapping(ProcessContext context) {
        block21: {
            if (this.processorLock.tryLock()) {
                ComponentLog logger = this.getLogger();
                try {
                    boolean retry;
                    long currentTimeSecs = System.currentTimeMillis() / 1000L;
                    long mappingRefreshPeriodSecs = context.getProperty(MAPPING_FILE_REFRESH_INTERVAL).asTimePeriod(TimeUnit.SECONDS);
                    boolean bl = retry = currentTimeSecs > this.mappingTestTime.get() + mappingRefreshPeriodSecs;
                    if (!retry) break block21;
                    this.mappingTestTime.set(System.currentTimeMillis() / 1000L);
                    String fileName = context.getProperty(MAPPING_FILE).getValue();
                    File file = new File(fileName);
                    if (file.exists() && file.isFile() && file.canRead()) {
                        if (file.lastModified() <= this.lastModified.get()) break block21;
                        this.lastModified.getAndSet(file.lastModified());
                        try (FileInputStream is = new FileInputStream(file);){
                            logger.info("Reloading mapping file: {}", new Object[]{fileName});
                            Map<String, String> mapping = this.loadMappingFile(is);
                            ConfigurationState newState = new ConfigurationState(mapping);
                            this.configurationStateRef.set(newState);
                            break block21;
                        }
                        catch (IOException e) {
                            logger.error("Error reading mapping file: {}", new Object[]{e.getMessage()});
                        }
                        break block21;
                    }
                    logger.error("Mapping file does not exist or is not readable: {}", new Object[]{fileName});
                }
                catch (Exception e) {
                    logger.error("Error loading mapping file: {}", new Object[]{e.getMessage()});
                }
                finally {
                    this.processorLock.unlock();
                }
            }
        }
    }

    protected Map<String, String> loadMappingFile(InputStream is) throws IOException {
        HashMap<String, String> mapping = new HashMap<String, String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String line = null;
        while ((line = reader.readLine()) != null) {
            String[] splits = StringUtils.split((String)line, (String)"\t ", (int)2);
            if (splits.length == 1) {
                mapping.put(splits[0].trim(), "");
                continue;
            }
            if (splits.length != 2) continue;
            String key = splits[0].trim();
            String value = splits[1].trim();
            mapping.put(key, value);
        }
        return mapping;
    }

    private final class ReplaceTextCallback
    implements StreamCallback {
        private final Charset charset;
        private final byte[] buffer;
        private final String regex;
        private final FlowFile flowFile;
        private final int numCapturingGroups;
        private final int groupToMatch;
        private final AttributeValueDecorator quotedAttributeDecorator = new AttributeValueDecorator(){

            public String decorate(String attributeValue) {
                return Pattern.quote(attributeValue);
            }
        };

        private ReplaceTextCallback(ProcessContext context, FlowFile flowFile, int maxBufferSize) {
            this.regex = context.getProperty(REGEX).evaluateAttributeExpressions(flowFile, this.quotedAttributeDecorator).getValue();
            this.flowFile = flowFile;
            this.charset = Charset.forName(context.getProperty(CHARACTER_SET).getValue());
            String regexValue = context.getProperty(REGEX).evaluateAttributeExpressions().getValue();
            this.numCapturingGroups = Pattern.compile(regexValue).matcher("").groupCount();
            this.buffer = new byte[maxBufferSize];
            this.groupToMatch = context.getProperty(MATCHING_GROUP_FOR_LOOKUP_KEY).evaluateAttributeExpressions().asInteger();
        }

        public void process(InputStream in, OutputStream out) throws IOException {
            Map<String, String> mapping = ((ConfigurationState)ReplaceTextWithMapping.this.configurationStateRef.get()).getMapping();
            StreamUtils.fillBuffer((InputStream)in, (byte[])this.buffer, (boolean)false);
            int flowFileSize = (int)this.flowFile.getSize();
            String contentString = new String(this.buffer, 0, flowFileSize, this.charset);
            Matcher matcher = Pattern.compile(this.regex).matcher(contentString);
            matcher.reset();
            boolean result = matcher.find();
            if (result) {
                StringBuffer sb = new StringBuffer();
                do {
                    String matched;
                    String rv;
                    if ((rv = mapping.get(matched = matcher.group(this.groupToMatch))) == null) {
                        String replacement = matcher.group().replace("$", "\\$");
                        matcher.appendReplacement(sb, replacement);
                        continue;
                    }
                    String allRegexMatched = matcher.group();
                    int scaledStart = matcher.start(this.groupToMatch) - matcher.start();
                    int scaledEnd = scaledStart + matcher.group(this.groupToMatch).length();
                    StringBuilder replacementBuilder = new StringBuilder();
                    replacementBuilder.append(allRegexMatched.substring(0, scaledStart).replace("$", "\\$"));
                    replacementBuilder.append(ReplaceTextWithMapping.this.fillReplacementValueBackReferences(rv, this.numCapturingGroups));
                    replacementBuilder.append(allRegexMatched.substring(scaledEnd).replace("$", "\\$"));
                    matcher.appendReplacement(sb, replacementBuilder.toString());
                } while (result = matcher.find());
                matcher.appendTail(sb);
                out.write(sb.toString().getBytes(this.charset));
                return;
            }
            out.write(contentString.getBytes(this.charset));
        }
    }

    public static class ConfigurationState {
        final Map<String, String> mapping = new HashMap<String, String>();

        public ConfigurationState(Map<String, String> mapping) {
            if (mapping != null) {
                this.mapping.putAll(mapping);
            }
        }

        public Map<String, String> getMapping() {
            return Collections.unmodifiableMap(this.mapping);
        }

        public boolean isConfigured() {
            return !this.mapping.isEmpty();
        }
    }
}

