/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.DynamicRelationship;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;

@EventDriven
@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"attributes", "routing", "Attribute Expression Language", "regexp", "regex", "Regular Expression", "Expression Language"})
@CapabilityDescription(value="Routes FlowFiles based on their Attributes using the Attribute Expression Language")
@DynamicProperty(name="Relationship Name", value="Attribute Expression Language", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES, description="Routes FlowFiles whose attributes match the Attribute Expression Language specified in the Dynamic Property Value to the Relationship specified in the Dynamic Property Key")
@DynamicRelationship(name="Name from Dynamic Property", description="FlowFiles that match the Dynamic Property's Attribute Expression Language")
@WritesAttributes(value={@WritesAttribute(attribute="RouteOnAttribute.Route", description="The relation to which the FlowFile was routed")})
public class RouteOnAttribute
extends AbstractProcessor {
    public static final String ROUTE_ATTRIBUTE_KEY = "RouteOnAttribute.Route";
    private static final String routeAllMatchValue = "Route to 'match' if all match";
    private static final String routeAnyMatches = "Route to 'match' if any matches";
    private static final String routePropertyNameValue = "Route to Property name";
    public static final AllowableValue ROUTE_PROPERTY_NAME = new AllowableValue("Route to Property name", "Route to Property name", "A copy of the FlowFile will be routed to each relationship whose corresponding expression evaluates to 'true'");
    public static final AllowableValue ROUTE_ALL_MATCH = new AllowableValue("Route to 'match' if all match", "Route to 'matched' if all match", "Requires that all user-defined expressions evaluate to 'true' for the FlowFile to be considered a match");
    public static final AllowableValue ROUTE_ANY_MATCHES = new AllowableValue("Route to 'match' if any matches", "Route to 'matched' if any matches", "Requires that at least one user-defined expression evaluate to 'true' for the FlowFile to be considered a match");
    public static final PropertyDescriptor ROUTE_STRATEGY = new PropertyDescriptor.Builder().name("Routing Strategy").description("Specifies how to determine which relationship to use when evaluating the Expression Language").required(true).allowableValues(new AllowableValue[]{ROUTE_PROPERTY_NAME, ROUTE_ALL_MATCH, ROUTE_ANY_MATCHES}).defaultValue(ROUTE_PROPERTY_NAME.getValue()).build();
    public static final Relationship REL_NO_MATCH = new Relationship.Builder().name("unmatched").description("FlowFiles that do not match any user-define expression will be routed here").build();
    public static final Relationship REL_MATCH = new Relationship.Builder().name("matched").description("FlowFiles will be routed to 'match' if one or all Expressions match, depending on the configuration of the Routing Strategy property").build();
    private AtomicReference<Set<Relationship>> relationships = new AtomicReference();
    private List<PropertyDescriptor> properties;
    private volatile String configuredRouteStrategy = ROUTE_STRATEGY.getDefaultValue();
    private volatile Set<String> dynamicPropertyNames = new HashSet<String>();
    private volatile Map<Relationship, PropertyValue> propertyMap = new HashMap<Relationship, PropertyValue>();

    protected void init(ProcessorInitializationContext context) {
        HashSet<Relationship> set = new HashSet<Relationship>();
        set.add(REL_NO_MATCH);
        this.relationships = new AtomicReference(set);
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(ROUTE_STRATEGY);
        this.properties = Collections.unmodifiableList(properties);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships.get();
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().required(false).name(propertyDescriptorName).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.BOOLEAN, (boolean)false)).dynamic(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
        if (descriptor.equals((Object)ROUTE_STRATEGY)) {
            this.configuredRouteStrategy = newValue;
        } else {
            HashSet<String> newDynamicPropertyNames = new HashSet<String>(this.dynamicPropertyNames);
            if (newValue == null) {
                newDynamicPropertyNames.remove(descriptor.getName());
            } else if (oldValue == null) {
                newDynamicPropertyNames.add(descriptor.getName());
            }
            this.dynamicPropertyNames = Collections.unmodifiableSet(newDynamicPropertyNames);
        }
        Set<String> allDynamicProps = this.dynamicPropertyNames;
        HashSet<Relationship> newRelationships = new HashSet<Relationship>();
        String routeStrategy = this.configuredRouteStrategy;
        if (ROUTE_PROPERTY_NAME.equals((Object)routeStrategy)) {
            for (String propName : allDynamicProps) {
                newRelationships.add(new Relationship.Builder().name(propName).build());
            }
        } else {
            newRelationships.add(REL_MATCH);
        }
        newRelationships.add(REL_NO_MATCH);
        this.relationships.set(newRelationships);
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        HashMap<Relationship, PropertyValue> newPropertyMap = new HashMap<Relationship, PropertyValue>();
        for (PropertyDescriptor descriptor : context.getProperties().keySet()) {
            if (!descriptor.isDynamic()) continue;
            this.getLogger().debug("Adding new dynamic property: {}", new Object[]{descriptor});
            newPropertyMap.put(new Relationship.Builder().name(descriptor.getName()).build(), context.getProperty(descriptor));
        }
        this.propertyMap = newPropertyMap;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        ComponentLog logger = this.getLogger();
        Map<Relationship, PropertyValue> propMap = this.propertyMap;
        HashSet matchingRelationships = new HashSet();
        for (Map.Entry<Relationship, PropertyValue> entry : propMap.entrySet()) {
            PropertyValue value = entry.getValue();
            boolean matches = value.evaluateAttributeExpressions(flowFile).asBoolean();
            if (!matches) continue;
            matchingRelationships.add(entry.getKey());
        }
        HashSet<Object> destinationRelationships = new HashSet<Object>();
        switch (context.getProperty(ROUTE_STRATEGY).getValue()) {
            case "Route to 'match' if all match": {
                if (matchingRelationships.size() == propMap.size()) {
                    destinationRelationships.add(REL_MATCH);
                    break;
                }
                destinationRelationships.add(REL_NO_MATCH);
                break;
            }
            case "Route to 'match' if any matches": {
                if (matchingRelationships.isEmpty()) {
                    destinationRelationships.add(REL_NO_MATCH);
                    break;
                }
                destinationRelationships.add(REL_MATCH);
                break;
            }
            default: {
                destinationRelationships.addAll(matchingRelationships);
            }
        }
        if (destinationRelationships.isEmpty()) {
            logger.info("Routing {} to unmatched", new Object[]{flowFile});
            flowFile = session.putAttribute(flowFile, ROUTE_ATTRIBUTE_KEY, REL_NO_MATCH.getName());
            session.getProvenanceReporter().route(flowFile, REL_NO_MATCH);
            session.transfer(flowFile, REL_NO_MATCH);
        } else {
            Iterator relationshipNameIterator = destinationRelationships.iterator();
            Relationship firstRelationship = (Relationship)relationshipNameIterator.next();
            HashMap<Relationship, FlowFile> transferMap = new HashMap<Relationship, FlowFile>();
            HashSet<FlowFile> clones = new HashSet<FlowFile>();
            while (relationshipNameIterator.hasNext()) {
                Relationship relationship = (Relationship)relationshipNameIterator.next();
                FlowFile cloneFlowFile = session.clone(flowFile);
                clones.add(cloneFlowFile);
                transferMap.put(relationship, cloneFlowFile);
            }
            for (Map.Entry entry : transferMap.entrySet()) {
                logger.info("Cloned {} into {} and routing clone to relationship {}", new Object[]{flowFile, entry.getValue(), entry.getKey()});
                FlowFile updatedFlowFile = session.putAttribute((FlowFile)entry.getValue(), ROUTE_ATTRIBUTE_KEY, ((Relationship)entry.getKey()).getName());
                session.getProvenanceReporter().route(updatedFlowFile, (Relationship)entry.getKey());
                session.transfer(updatedFlowFile, (Relationship)entry.getKey());
            }
            logger.info("Routing {} to {}", new Object[]{flowFile, firstRelationship});
            session.getProvenanceReporter().route(flowFile, firstRelationship);
            flowFile = session.putAttribute(flowFile, ROUTE_ATTRIBUTE_KEY, firstRelationship.getName());
            session.transfer(flowFile, firstRelationship);
        }
    }
}

