/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.syslog;

public class SyslogEvent {
    private final String priority;
    private final String severity;
    private final String facility;
    private final String version;
    private final String timeStamp;
    private final String hostName;
    private final String sender;
    private final String msgBody;
    private final String fullMessage;
    private final byte[] rawMessage;
    private final boolean valid;

    private SyslogEvent(Builder builder) {
        this.priority = builder.priority;
        this.severity = builder.severity;
        this.facility = builder.facility;
        this.version = builder.version;
        this.timeStamp = builder.timeStamp;
        this.hostName = builder.hostName;
        this.sender = builder.sender;
        this.msgBody = builder.msgBody;
        this.fullMessage = builder.fullMessage;
        this.rawMessage = builder.rawMessage;
        this.valid = builder.valid;
    }

    public String getPriority() {
        return this.priority;
    }

    public String getSeverity() {
        return this.severity;
    }

    public String getFacility() {
        return this.facility;
    }

    public String getVersion() {
        return this.version;
    }

    public String getTimeStamp() {
        return this.timeStamp;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getSender() {
        return this.sender;
    }

    public String getMsgBody() {
        return this.msgBody;
    }

    public String getFullMessage() {
        return this.fullMessage;
    }

    public byte[] getRawMessage() {
        return this.rawMessage;
    }

    public boolean isValid() {
        return this.valid;
    }

    public static final class Builder {
        private String priority;
        private String severity;
        private String facility;
        private String version;
        private String timeStamp;
        private String hostName;
        private String sender;
        private String msgBody;
        private String fullMessage;
        private byte[] rawMessage;
        private boolean valid;

        public void reset() {
            this.priority = null;
            this.severity = null;
            this.facility = null;
            this.version = null;
            this.timeStamp = null;
            this.hostName = null;
            this.sender = null;
            this.msgBody = null;
            this.fullMessage = null;
            this.valid = false;
        }

        public Builder priority(String priority) {
            this.priority = priority;
            return this;
        }

        public Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public Builder facility(String facility) {
            this.facility = facility;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder timestamp(String timestamp) {
            this.timeStamp = timestamp;
            return this;
        }

        public Builder hostname(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder sender(String sender) {
            this.sender = sender;
            return this;
        }

        public Builder msgBody(String msgBody) {
            this.msgBody = msgBody;
            return this;
        }

        public Builder fullMessage(String fullMessage) {
            this.fullMessage = fullMessage;
            return this;
        }

        public Builder rawMessage(byte[] rawMessage) {
            this.rawMessage = rawMessage;
            return this;
        }

        public Builder valid(boolean valid) {
            this.valid = valid;
            return this;
        }

        public SyslogEvent build() {
            return new SyslogEvent(this);
        }
    }
}

