/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.dbcp.DBCPService;
import org.apache.nifi.expression.AttributeExpression;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.FragmentAttributes;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.AbstractDatabaseFetchProcessor;
import org.apache.nifi.processors.standard.db.DatabaseAdapter;
import org.apache.nifi.processors.standard.sql.SqlWriter;
import org.apache.nifi.processors.standard.util.JdbcCommon;
import org.apache.nifi.util.StopWatch;

public abstract class AbstractQueryDatabaseTable
extends AbstractDatabaseFetchProcessor {
    public static final String RESULT_TABLENAME = "tablename";
    public static final String RESULT_ROW_COUNT = "querydbtable.row.count";
    public static final String FRAGMENT_ID = FragmentAttributes.FRAGMENT_ID.key();
    public static final String FRAGMENT_INDEX = FragmentAttributes.FRAGMENT_INDEX.key();
    public static final PropertyDescriptor FETCH_SIZE = new PropertyDescriptor.Builder().name("Fetch Size").description("The number of result rows to be fetched from the result set at a time. This is a hint to the database driver and may not be honored and/or exact. If the value specified is zero, then the hint is ignored.").defaultValue("0").required(true).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor MAX_ROWS_PER_FLOW_FILE = new PropertyDescriptor.Builder().name("qdbt-max-rows").displayName("Max Rows Per Flow File").description("The maximum number of result rows that will be included in a single FlowFile. This will allow you to break up very large result sets into multiple FlowFiles. If the value specified is zero, then all rows are returned in a single FlowFile.").defaultValue("0").required(true).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor OUTPUT_BATCH_SIZE = new PropertyDescriptor.Builder().name("qdbt-output-batch-size").displayName("Output Batch Size").description("The number of output FlowFiles to queue before committing the process session. When set to zero, the session will be committed when all result set rows have been processed and the output FlowFiles are ready for transfer to the downstream relationship. For large result sets, this can cause a large burst of FlowFiles to be transferred at the end of processor execution. If this property is set, then when the specified number of FlowFiles are ready for transfer, then the session will be committed, thus releasing the FlowFiles to the downstream relationship. NOTE: The maxvalue.* and fragment.count attributes will not be set on FlowFiles when this property is set.").defaultValue("0").required(true).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor MAX_FRAGMENTS = new PropertyDescriptor.Builder().name("qdbt-max-frags").displayName("Maximum Number of Fragments").description("The maximum number of fragments. If the value specified is zero, then all fragments are returned. This prevents OutOfMemoryError when this processor ingests huge table. NOTE: Setting this property can result in data loss, as the incoming results are not ordered, and fragments may end at arbitrary boundaries where rows are not included in the result set.").defaultValue("0").required(true).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.propDescriptors;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).addValidator(StandardValidators.createAttributeExpressionLanguageValidator((AttributeExpression.ResultType)AttributeExpression.ResultType.STRING, (boolean)true)).addValidator(StandardValidators.ATTRIBUTE_KEY_PROPERTY_NAME_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).dynamic(true).build();
    }

    @Override
    @OnScheduled
    public void setup(ProcessContext context) {
        this.maxValueProperties = this.getDefaultMaxValueProperties(context, null);
    }

    @OnStopped
    public void stop() {
        this.setupComplete.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) throws ProcessException {
        block72: {
            StateMap stateMap;
            if (!this.setupComplete.get()) {
                super.setup(context);
            }
            ProcessSession session = sessionFactory.createSession();
            ArrayList<FlowFile> resultSetFlowFiles = new ArrayList<FlowFile>();
            ComponentLog logger = this.getLogger();
            DBCPService dbcpService = (DBCPService)context.getProperty(DBCP_SERVICE).asControllerService(DBCPService.class);
            DatabaseAdapter dbAdapter = (DatabaseAdapter)dbAdapters.get(context.getProperty(DB_TYPE).getValue());
            String tableName = context.getProperty(TABLE_NAME).evaluateAttributeExpressions().getValue();
            String columnNames = context.getProperty(COLUMN_NAMES).evaluateAttributeExpressions().getValue();
            String sqlQuery = context.getProperty(SQL_QUERY).evaluateAttributeExpressions().getValue();
            String maxValueColumnNames = context.getProperty(MAX_VALUE_COLUMN_NAMES).evaluateAttributeExpressions().getValue();
            String customWhereClause = context.getProperty(WHERE_CLAUSE).evaluateAttributeExpressions().getValue();
            Integer fetchSize = context.getProperty(FETCH_SIZE).evaluateAttributeExpressions().asInteger();
            Integer maxRowsPerFlowFile = context.getProperty(MAX_ROWS_PER_FLOW_FILE).evaluateAttributeExpressions().asInteger();
            Integer outputBatchSizeField = context.getProperty(OUTPUT_BATCH_SIZE).evaluateAttributeExpressions().asInteger();
            int outputBatchSize = outputBatchSizeField == null ? 0 : outputBatchSizeField;
            Integer maxFragments = context.getProperty(MAX_FRAGMENTS).isSet() ? context.getProperty(MAX_FRAGMENTS).evaluateAttributeExpressions().asInteger() : 0;
            SqlWriter sqlWriter = this.configureSqlWriter(session, context);
            StateManager stateManager = context.getStateManager();
            try {
                stateMap = stateManager.getState(Scope.CLUSTER);
            }
            catch (IOException ioe) {
                this.getLogger().error("Failed to retrieve observed maximum values from the State Manager. Will not perform query until this is accomplished.", (Throwable)ioe);
                context.yield();
                return;
            }
            HashMap<String, String> statePropertyMap = new HashMap<String, String>(stateMap.toMap());
            for (Map.Entry maxProp : this.maxValueProperties.entrySet()) {
                String maxPropKey = ((String)maxProp.getKey()).toLowerCase();
                String fullyQualifiedMaxPropKey = AbstractQueryDatabaseTable.getStateKey(tableName, maxPropKey, dbAdapter);
                if (statePropertyMap.containsKey(fullyQualifiedMaxPropKey)) continue;
                String newMaxPropValue = statePropertyMap.containsKey(maxPropKey) ? (String)statePropertyMap.get(maxPropKey) : (String)maxProp.getValue();
                statePropertyMap.put(fullyQualifiedMaxPropKey, newMaxPropValue);
            }
            List<String> maxValueColumnNameList = StringUtils.isEmpty((CharSequence)maxValueColumnNames) ? null : Arrays.asList(maxValueColumnNames.split("\\s*,\\s*"));
            String selectQuery = this.getQuery(dbAdapter, tableName, sqlQuery, columnNames, maxValueColumnNameList, customWhereClause, statePropertyMap);
            StopWatch stopWatch = new StopWatch(true);
            String fragmentIdentifier = UUID.randomUUID().toString();
            try (Connection con = dbcpService.getConnection(Collections.emptyMap());
                 Statement st = con.createStatement();){
                if (fetchSize != null && fetchSize > 0) {
                    try {
                        st.setFetchSize(fetchSize);
                    }
                    catch (SQLException se) {
                        logger.debug("Cannot set fetch size to {} due to {}", new Object[]{fetchSize, se.getLocalizedMessage()}, (Throwable)se);
                    }
                }
                String jdbcURL = "DBCPService";
                try {
                    DatabaseMetaData databaseMetaData = con.getMetaData();
                    if (databaseMetaData != null) {
                        jdbcURL = databaseMetaData.getURL();
                    }
                }
                catch (SQLException databaseMetaData) {
                    // empty catch block
                }
                Integer queryTimeout = context.getProperty(QUERY_TIMEOUT).evaluateAttributeExpressions().asTimePeriod(TimeUnit.SECONDS).intValue();
                st.setQueryTimeout(queryTimeout);
                if (logger.isDebugEnabled()) {
                    logger.debug("Executing query {}", new Object[]{selectQuery});
                }
                try (ResultSet resultSet = st.executeQuery(selectQuery);){
                    AtomicLong nrOfRows;
                    int fragmentIndex = 0;
                    MaxValueResultSetRowCollector maxValCollector = new MaxValueResultSetRowCollector(tableName, statePropertyMap, dbAdapter);
                    do {
                        nrOfRows = new AtomicLong(0L);
                        FlowFile fileToProcess = session.create();
                        try {
                            fileToProcess = session.write(fileToProcess, out -> {
                                try {
                                    nrOfRows.set(sqlWriter.writeResultSet(resultSet, out, this.getLogger(), maxValCollector));
                                }
                                catch (Exception e) {
                                    throw new ProcessException("Error during database query or conversion of records.", (Throwable)e);
                                }
                            });
                        }
                        catch (ProcessException e) {
                            resultSetFlowFiles.add(fileToProcess);
                            throw e;
                        }
                        if (nrOfRows.get() <= 0L) {
                            session.remove(fileToProcess);
                            if (fragmentIndex == 0) {
                                context.yield();
                            }
                            break;
                        }
                        HashMap<String, String> attributesToAdd = new HashMap<String, String>();
                        attributesToAdd.put(RESULT_ROW_COUNT, String.valueOf(nrOfRows.get()));
                        attributesToAdd.put(RESULT_TABLENAME, tableName);
                        if (maxRowsPerFlowFile > 0) {
                            attributesToAdd.put(FRAGMENT_ID, fragmentIdentifier);
                            attributesToAdd.put(FRAGMENT_INDEX, String.valueOf(fragmentIndex));
                        }
                        attributesToAdd.putAll(sqlWriter.getAttributesToAdd());
                        fileToProcess = session.putAllAttributes(fileToProcess, attributesToAdd);
                        sqlWriter.updateCounters(session);
                        logger.info("{} contains {} records; transferring to 'success'", new Object[]{fileToProcess, nrOfRows.get()});
                        session.getProvenanceReporter().receive(fileToProcess, jdbcURL, stopWatch.getElapsed(TimeUnit.MILLISECONDS));
                        resultSetFlowFiles.add(fileToProcess);
                        if (outputBatchSize > 0 && resultSetFlowFiles.size() >= outputBatchSize) {
                            session.transfer(resultSetFlowFiles, REL_SUCCESS);
                            session.commit();
                            resultSetFlowFiles.clear();
                        }
                        ++fragmentIndex;
                    } while (!(maxFragments > 0 && fragmentIndex >= maxFragments || maxFragments == 0 && maxRowsPerFlowFile == 0) && (maxRowsPerFlowFile <= 0 || nrOfRows.get() >= (long)maxRowsPerFlowFile.intValue()));
                    maxValCollector.applyStateChanges();
                    if (outputBatchSize == 0) {
                        for (int i = 0; i < resultSetFlowFiles.size(); ++i) {
                            for (Map.Entry entry : statePropertyMap.entrySet()) {
                                String key = (String)entry.getKey();
                                String colName = key.substring(key.lastIndexOf("@!@") + "@!@".length());
                                resultSetFlowFiles.set(i, session.putAttribute((FlowFile)resultSetFlowFiles.get(i), "maxvalue." + colName, (String)entry.getValue()));
                            }
                            if (maxRowsPerFlowFile <= 0) continue;
                            resultSetFlowFiles.set(i, session.putAttribute((FlowFile)resultSetFlowFiles.get(i), "fragment.count", Integer.toString(fragmentIndex)));
                        }
                    }
                }
                session.transfer(resultSetFlowFiles, REL_SUCCESS);
            }
            session.commit();
            try {
                stateManager.setState(statePropertyMap, Scope.CLUSTER);
            }
            catch (IOException ioe) {
                this.getLogger().error("{} failed to update State Manager, maximum observed values will not be recorded", new Object[]{this, ioe});
            }
            break block72;
            catch (SQLException | ProcessException e) {
                try {
                    logger.error("Unable to execute SQL select query {} due to {}", new Object[]{selectQuery, e});
                    if (!resultSetFlowFiles.isEmpty()) {
                        session.remove(resultSetFlowFiles);
                    }
                    context.yield();
                }
                catch (Throwable throwable) {
                    session.commit();
                    try {
                        stateManager.setState(statePropertyMap, Scope.CLUSTER);
                    }
                    catch (IOException ioe) {
                        this.getLogger().error("{} failed to update State Manager, maximum observed values will not be recorded", new Object[]{this, ioe});
                    }
                    throw throwable;
                }
                session.commit();
                try {
                    stateManager.setState(statePropertyMap, Scope.CLUSTER);
                }
                catch (IOException ioe) {
                    this.getLogger().error("{} failed to update State Manager, maximum observed values will not be recorded", new Object[]{this, ioe});
                }
            }
        }
    }

    protected String getQuery(DatabaseAdapter dbAdapter, String tableName, String columnNames, List<String> maxValColumnNames, String customWhereClause, Map<String, String> stateMap) {
        return this.getQuery(dbAdapter, tableName, null, columnNames, maxValColumnNames, customWhereClause, stateMap);
    }

    protected String getQuery(DatabaseAdapter dbAdapter, String tableName, String sqlQuery, String columnNames, List<String> maxValColumnNames, String customWhereClause, Map<String, String> stateMap) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new IllegalArgumentException("Table name must be specified");
        }
        StringBuilder query = StringUtils.isEmpty((CharSequence)sqlQuery) ? new StringBuilder(dbAdapter.getSelectStatement(tableName, columnNames, null, null, null, null)) : AbstractQueryDatabaseTable.getWrappedQuery(dbAdapter, sqlQuery, tableName);
        ArrayList<String> whereClauses = new ArrayList<String>();
        if (stateMap != null && !stateMap.isEmpty() && maxValColumnNames != null) {
            IntStream.range(0, maxValColumnNames.size()).forEach(index -> {
                String colName = (String)maxValColumnNames.get(index);
                String maxValueKey = AbstractQueryDatabaseTable.getStateKey(tableName, colName, dbAdapter);
                String maxValue = (String)stateMap.get(maxValueKey);
                if (StringUtils.isEmpty((CharSequence)maxValue)) {
                    maxValue = (String)stateMap.get(colName.toLowerCase());
                }
                if (!StringUtils.isEmpty((CharSequence)maxValue)) {
                    Integer type = (Integer)this.columnTypeMap.get(maxValueKey);
                    if (type == null) {
                        throw new IllegalArgumentException("No column type found for: " + colName);
                    }
                    whereClauses.add(colName + (index == 0 ? " > " : " >= ") + AbstractQueryDatabaseTable.getLiteralByType(type, maxValue, dbAdapter.getName()));
                }
            });
        }
        if (customWhereClause != null) {
            whereClauses.add("(" + customWhereClause + ")");
        }
        if (!whereClauses.isEmpty()) {
            query.append(" WHERE ");
            query.append(StringUtils.join(whereClauses, (String)" AND "));
        }
        return query.toString();
    }

    protected abstract SqlWriter configureSqlWriter(ProcessSession var1, ProcessContext var2);

    public class MaxValueResultSetRowCollector
    implements JdbcCommon.ResultSetRowCallback {
        DatabaseAdapter dbAdapter;
        final Map<String, String> newColMap;
        final Map<String, String> originalState;
        String tableName;

        public MaxValueResultSetRowCollector(String tableName, Map<String, String> stateMap, DatabaseAdapter dbAdapter) {
            this.dbAdapter = dbAdapter;
            this.originalState = stateMap;
            this.newColMap = new HashMap<String, String>();
            this.newColMap.putAll(stateMap);
            this.tableName = tableName;
        }

        @Override
        public void processRow(ResultSet resultSet) throws IOException {
            if (resultSet == null) {
                return;
            }
            try {
                ResultSetMetaData meta = resultSet.getMetaData();
                int nrOfColumns = meta.getColumnCount();
                if (nrOfColumns > 0) {
                    for (int i = 1; i <= nrOfColumns; ++i) {
                        String newMaxValueString;
                        String colName = meta.getColumnName(i).toLowerCase();
                        String fullyQualifiedMaxValueKey = AbstractDatabaseFetchProcessor.getStateKey(this.tableName, colName, this.dbAdapter);
                        Integer type = (Integer)AbstractQueryDatabaseTable.this.columnTypeMap.get(fullyQualifiedMaxValueKey);
                        if (type == null || resultSet.getObject(i) == null) continue;
                        String maxValueString = this.newColMap.get(fullyQualifiedMaxValueKey);
                        if (StringUtils.isEmpty((CharSequence)maxValueString)) {
                            maxValueString = this.newColMap.get(colName);
                        }
                        if ((newMaxValueString = AbstractDatabaseFetchProcessor.getMaxValueFromRow(resultSet, i, type, maxValueString, this.dbAdapter.getName())) == null) continue;
                        this.newColMap.put(fullyQualifiedMaxValueKey, newMaxValueString);
                    }
                }
            }
            catch (SQLException | ParseException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void applyStateChanges() {
            this.originalState.putAll(this.newColMap);
        }
    }
}

