/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.UnresolvedUnionException;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.standard.util.AvroUtil;

public class JdbcCommon {
    private static final int MAX_DIGITS_IN_BIGINT = 19;
    private static final int MAX_DIGITS_IN_INT = 9;
    private static final int DEFAULT_PRECISION_VALUE = 10;
    private static final int DEFAULT_SCALE_VALUE = 0;
    public static final Pattern LONG_PATTERN = Pattern.compile("^-?\\d{1,19}$");
    public static final Pattern SQL_TYPE_ATTRIBUTE_PATTERN = Pattern.compile("sql\\.args\\.(\\d+)\\.type");
    public static final Pattern NUMBER_PATTERN = Pattern.compile("-?\\d+");
    public static final String MIME_TYPE_AVRO_BINARY = "application/avro-binary";
    public static final PropertyDescriptor NORMALIZE_NAMES_FOR_AVRO = new PropertyDescriptor.Builder().name("dbf-normalize").displayName("Normalize Table/Column Names").description("Whether to change non-Avro-compatible characters in column names to Avro-compatible characters. For example, colons and periods will be changed to underscores in order to build a valid Avro record.").allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();
    public static final PropertyDescriptor USE_AVRO_LOGICAL_TYPES = new PropertyDescriptor.Builder().name("dbf-user-logical-types").displayName("Use Avro Logical Types").description("Whether to use Avro Logical Types for DECIMAL/NUMBER, DATE, TIME and TIMESTAMP columns. If disabled, written as string. If enabled, Logical types are used and written as its underlying type, specifically, DECIMAL/NUMBER as logical 'decimal': written as bytes with additional precision and scale meta data, DATE as logical 'date-millis': written as int denoting days since Unix epoch (1970-01-01), TIME as logical 'time-millis': written as int denoting milliseconds since Unix epoch, and TIMESTAMP as logical 'timestamp-millis': written as long denoting milliseconds since Unix epoch. If a reader of written Avro records also knows these logical types, then these values can be deserialized with more context depending on reader implementation.").allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();
    public static final PropertyDescriptor DEFAULT_PRECISION = new PropertyDescriptor.Builder().name("dbf-default-precision").displayName("Default Decimal Precision").description("When a DECIMAL/NUMBER value is written as a 'decimal' Avro logical type, a specific 'precision' denoting number of available digits is required. Generally, precision is defined by column data type definition or database engines default. However undefined precision (0) can be returned from some database engines. 'Default Decimal Precision' is used when writing those undefined precision numbers.").defaultValue(String.valueOf(10)).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).build();
    public static final PropertyDescriptor DEFAULT_SCALE = new PropertyDescriptor.Builder().name("dbf-default-scale").displayName("Default Decimal Scale").description("When a DECIMAL/NUMBER value is written as a 'decimal' Avro logical type, a specific 'scale' denoting number of available decimal digits is required. Generally, scale is defined by column data type definition or database engines default. However when undefined precision (0) is returned, scale can also be uncertain with some database engines. 'Default Decimal Scale' is used when writing those undefined numbers. If a value has more decimals than specified scale, then the value will be rounded-up, e.g. 1.53 becomes 2 with scale 0, and 1.5 with scale 1.").defaultValue(String.valueOf(0)).addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).build();

    public static long convertToAvroStream(ResultSet rs, OutputStream outStream, boolean convertNames) throws SQLException, IOException {
        return JdbcCommon.convertToAvroStream(rs, outStream, null, null, convertNames);
    }

    public static long convertToAvroStream(ResultSet rs, OutputStream outStream, String recordName, boolean convertNames) throws SQLException, IOException {
        return JdbcCommon.convertToAvroStream(rs, outStream, recordName, null, convertNames);
    }

    public static long convertToAvroStream(ResultSet rs, OutputStream outStream, String recordName, ResultSetRowCallback callback, boolean convertNames) throws IOException, SQLException {
        return JdbcCommon.convertToAvroStream(rs, outStream, recordName, callback, 0, convertNames);
    }

    public static long convertToAvroStream(ResultSet rs, OutputStream outStream, String recordName, ResultSetRowCallback callback, int maxRows, boolean convertNames) throws SQLException, IOException {
        AvroConversionOptions options = AvroConversionOptions.builder().recordName(recordName).maxRows(maxRows).convertNames(convertNames).useLogicalTypes(false).build();
        return JdbcCommon.convertToAvroStream(rs, outStream, options, callback);
    }

    public static void createEmptyAvroStream(OutputStream outStream) throws IOException {
        SchemaBuilder.FieldAssembler builder = ((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"NiFi_ExecuteSQL_Record").namespace("any.data")).fields();
        Schema schema = (Schema)builder.endRecord();
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        try (DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);){
            dataFileWriter.create(schema, outStream);
        }
    }

    public static long convertToAvroStream(ResultSet rs, OutputStream outStream, AvroConversionOptions options, ResultSetRowCallback callback) throws SQLException, IOException {
        Schema schema = JdbcCommon.createSchema(rs, options);
        GenericData.Record rec = new GenericData.Record(schema);
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        try (DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);){
            dataFileWriter.setCodec(options.codec);
            dataFileWriter.create(schema, outStream);
            ResultSetMetaData meta = rs.getMetaData();
            int nrOfColumns = meta.getColumnCount();
            long nrOfRows = 0L;
            while (rs.next()) {
                if (callback != null) {
                    callback.processRow(rs);
                }
                for (int i = 1; i <= nrOfColumns; ++i) {
                    Object value;
                    int c;
                    int index;
                    InputStream is;
                    Object[] buffer;
                    int javaSqlType = meta.getColumnType(i);
                    Schema fieldSchema = ((Schema.Field)schema.getFields().get(i - 1)).schema();
                    if (javaSqlType == 2005) {
                        Clob clob = rs.getClob(i);
                        if (clob != null) {
                            long numChars = clob.length();
                            buffer = new char[(int)numChars];
                            is = clob.getAsciiStream();
                            index = 0;
                            c = is.read();
                            while (c >= 0) {
                                buffer[index++] = (char)c;
                                c = is.read();
                            }
                            rec.put(i - 1, (Object)new String((char[])buffer));
                            clob.free();
                            continue;
                        }
                        rec.put(i - 1, null);
                        continue;
                    }
                    if (javaSqlType == 2011) {
                        NClob nClob = rs.getNClob(i);
                        if (nClob != null) {
                            Reader characterStream = nClob.getCharacterStream();
                            long numChars = (int)nClob.length();
                            CharBuffer buffer2 = CharBuffer.allocate((int)numChars);
                            characterStream.read(buffer2);
                            buffer2.flip();
                            rec.put(i - 1, (Object)buffer2.toString());
                            nClob.free();
                            continue;
                        }
                        rec.put(i - 1, null);
                        continue;
                    }
                    if (javaSqlType == 2004) {
                        Blob blob = rs.getBlob(i);
                        if (blob != null) {
                            long numChars = blob.length();
                            buffer = new byte[(int)numChars];
                            is = blob.getBinaryStream();
                            index = 0;
                            c = is.read();
                            while (c >= 0) {
                                buffer[index++] = (char)c;
                                c = is.read();
                            }
                            ByteBuffer bb = ByteBuffer.wrap((byte[])buffer);
                            rec.put(i - 1, (Object)bb);
                            blob.free();
                            continue;
                        }
                        rec.put(i - 1, null);
                        continue;
                    }
                    if (javaSqlType == 93 || javaSqlType == 2014 || javaSqlType == -101 || javaSqlType == -102) {
                        try {
                            value = rs.getTimestamp(i);
                            if (value == null) {
                                value = rs.getObject(i);
                            }
                        }
                        catch (Exception e) {
                            value = rs.getObject(i);
                        }
                    } else {
                        value = rs.getObject(i);
                    }
                    if (value == null) {
                        rec.put(i - 1, null);
                        continue;
                    }
                    if (javaSqlType == -2 || javaSqlType == -3 || javaSqlType == -4 || javaSqlType == 2003) {
                        byte[] bytes = rs.getBytes(i);
                        ByteBuffer bb = ByteBuffer.wrap(bytes);
                        rec.put(i - 1, (Object)bb);
                        continue;
                    }
                    if (value instanceof Byte) {
                        rec.put(i - 1, (Object)((Byte)value).intValue());
                        continue;
                    }
                    if (value instanceof Short) {
                        rec.put(i - 1, (Object)((Short)value).intValue());
                        continue;
                    }
                    if (value instanceof BigDecimal) {
                        if (options.useLogicalTypes) {
                            rec.put(i - 1, AvroTypeUtil.convertToAvroObject((Object)value, (Schema)fieldSchema));
                            continue;
                        }
                        rec.put(i - 1, (Object)value.toString());
                        continue;
                    }
                    if (value instanceof BigInteger) {
                        if (javaSqlType == -5) {
                            int precision = meta.getPrecision(i);
                            if (precision < 0 || precision > 19) {
                                rec.put(i - 1, (Object)value.toString());
                                continue;
                            }
                            try {
                                rec.put(i - 1, (Object)((BigInteger)value).longValueExact());
                            }
                            catch (ArithmeticException ae) {
                                rec.put(i - 1, (Object)value.toString());
                            }
                            continue;
                        }
                        rec.put(i - 1, (Object)value.toString());
                        continue;
                    }
                    if (value instanceof Number || value instanceof Boolean) {
                        if (javaSqlType == -5) {
                            int precision = meta.getPrecision(i);
                            if (precision < 0 || precision > 19) {
                                rec.put(i - 1, (Object)value.toString());
                                continue;
                            }
                            rec.put(i - 1, value);
                            continue;
                        }
                        if (value instanceof Long && meta.getPrecision(i) < 9) {
                            int intValue = ((Long)value).intValue();
                            rec.put(i - 1, (Object)intValue);
                            continue;
                        }
                        rec.put(i - 1, value);
                        continue;
                    }
                    if (value instanceof java.util.Date) {
                        if (options.useLogicalTypes) {
                            rec.put(i - 1, AvroTypeUtil.convertToAvroObject((Object)value, (Schema)fieldSchema));
                            continue;
                        }
                        rec.put(i - 1, (Object)value.toString());
                        continue;
                    }
                    rec.put(i - 1, (Object)value.toString());
                }
                try {
                    dataFileWriter.append((Object)rec);
                }
                catch (DataFileWriter.AppendWriteException awe) {
                    Throwable rootCause = ExceptionUtils.getRootCause((Throwable)awe);
                    if (rootCause instanceof UnresolvedUnionException) {
                        UnresolvedUnionException uue = (UnresolvedUnionException)rootCause;
                        throw new RuntimeException("Unable to resolve union for value " + uue.getUnresolvedDatum() + " with type " + uue.getUnresolvedDatum().getClass().getCanonicalName() + " while appending record " + rec, awe);
                    }
                    throw awe;
                }
                if (options.maxRows <= 0 || ++nrOfRows != (long)options.maxRows) continue;
            }
            long l = nrOfRows;
            return l;
        }
    }

    public static Schema createSchema(ResultSet rs) throws SQLException {
        return JdbcCommon.createSchema(rs, null, false);
    }

    public static Schema createSchema(ResultSet rs, String recordName, boolean convertNames) throws SQLException {
        AvroConversionOptions options = AvroConversionOptions.builder().recordName(recordName).convertNames(convertNames).build();
        return JdbcCommon.createSchema(rs, options);
    }

    private static void addNullableField(SchemaBuilder.FieldAssembler<Schema> builder, String columnName, Function<SchemaBuilder.BaseTypeBuilder<SchemaBuilder.UnionAccumulator<SchemaBuilder.NullDefault<Schema>>>, SchemaBuilder.UnionAccumulator<SchemaBuilder.NullDefault<Schema>>> func) {
        SchemaBuilder.BaseTypeBuilder and = ((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and();
        ((SchemaBuilder.NullDefault)func.apply((SchemaBuilder.BaseTypeBuilder<SchemaBuilder.UnionAccumulator<SchemaBuilder.NullDefault<Schema>>>)and).endUnion()).noDefault();
    }

    public static Schema createSchema(ResultSet rs, AvroConversionOptions options) throws SQLException {
        String tableNameFromMeta;
        String tableName;
        ResultSetMetaData meta = rs.getMetaData();
        int nrOfColumns = meta.getColumnCount();
        String string = tableName = StringUtils.isEmpty((CharSequence)options.recordName) ? "NiFi_ExecuteSQL_Record" : options.recordName;
        if (nrOfColumns > 0 && !StringUtils.isBlank((CharSequence)(tableNameFromMeta = meta.getTableName(1)))) {
            tableName = tableNameFromMeta;
        }
        if (options.convertNames) {
            tableName = JdbcCommon.normalizeNameForAvro(tableName);
        }
        SchemaBuilder.FieldAssembler builder = ((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)tableName).namespace("any.data")).fields();
        block15: for (int i = 1; i <= nrOfColumns; ++i) {
            String nameOrLabel = StringUtils.isNotEmpty((CharSequence)meta.getColumnLabel(i)) ? meta.getColumnLabel(i) : meta.getColumnName(i);
            String columnName = options.convertNames ? JdbcCommon.normalizeNameForAvro(nameOrLabel) : nameOrLabel;
            switch (meta.getColumnType(i)) {
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: 
                case 2005: 
                case 2011: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().stringType()).endUnion()).noDefault();
                    continue block15;
                }
                case -7: 
                case 16: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().booleanType()).endUnion()).noDefault();
                    continue block15;
                }
                case 4: {
                    if (meta.isSigned(i) || meta.getPrecision(i) > 0 && meta.getPrecision(i) < 9) {
                        ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().intType()).endUnion()).noDefault();
                        continue block15;
                    }
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().longType()).endUnion()).noDefault();
                    continue block15;
                }
                case -6: 
                case 5: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().intType()).endUnion()).noDefault();
                    continue block15;
                }
                case -5: {
                    int precision = meta.getPrecision(i);
                    if (precision < 0 || precision > 19) {
                        ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().stringType()).endUnion()).noDefault();
                        continue block15;
                    }
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().longType()).endUnion()).noDefault();
                    continue block15;
                }
                case -8: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().stringType()).endUnion()).noDefault();
                    continue block15;
                }
                case 6: 
                case 7: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().floatType()).endUnion()).noDefault();
                    continue block15;
                }
                case 8: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().doubleType()).endUnion()).noDefault();
                    continue block15;
                }
                case 2: 
                case 3: {
                    if (options.useLogicalTypes) {
                        int decimalScale;
                        int decimalPrecision;
                        if (meta.getPrecision(i) > 0) {
                            decimalPrecision = meta.getPrecision(i);
                            decimalScale = meta.getScale(i);
                        } else {
                            decimalPrecision = options.defaultPrecision;
                            decimalScale = meta.getScale(i) > 0 ? meta.getScale(i) : options.defaultScale;
                        }
                        LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)decimalPrecision, (int)decimalScale);
                        JdbcCommon.addNullableField((SchemaBuilder.FieldAssembler<Schema>)builder, columnName, u -> (SchemaBuilder.UnionAccumulator)u.type(decimal.addToSchema((Schema)SchemaBuilder.builder().bytesType())));
                        continue block15;
                    }
                    JdbcCommon.addNullableField((SchemaBuilder.FieldAssembler<Schema>)builder, columnName, u -> (SchemaBuilder.UnionAccumulator)u.stringType());
                    continue block15;
                }
                case 91: {
                    JdbcCommon.addNullableField((SchemaBuilder.FieldAssembler<Schema>)builder, columnName, u -> options.useLogicalTypes ? (SchemaBuilder.UnionAccumulator)u.type(LogicalTypes.date().addToSchema((Schema)SchemaBuilder.builder().intType())) : (SchemaBuilder.UnionAccumulator)u.stringType());
                    continue block15;
                }
                case 92: {
                    JdbcCommon.addNullableField((SchemaBuilder.FieldAssembler<Schema>)builder, columnName, u -> options.useLogicalTypes ? (SchemaBuilder.UnionAccumulator)u.type(LogicalTypes.timeMillis().addToSchema((Schema)SchemaBuilder.builder().intType())) : (SchemaBuilder.UnionAccumulator)u.stringType());
                    continue block15;
                }
                case -102: 
                case -101: 
                case 93: 
                case 2014: {
                    JdbcCommon.addNullableField((SchemaBuilder.FieldAssembler<Schema>)builder, columnName, u -> options.useLogicalTypes ? (SchemaBuilder.UnionAccumulator)u.type(LogicalTypes.timestampMillis().addToSchema((Schema)SchemaBuilder.builder().longType())) : (SchemaBuilder.UnionAccumulator)u.stringType());
                    continue block15;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2003: 
                case 2004: {
                    ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)builder.name(columnName).type().unionOf().nullBuilder().endNull()).and().bytesType()).endUnion()).noDefault();
                    continue block15;
                }
                default: {
                    throw new IllegalArgumentException("createSchema: Unknown SQL type " + meta.getColumnType(i) + " / " + meta.getColumnTypeName(i) + " (table: " + tableName + ", column: " + columnName + ") cannot be converted to Avro type");
                }
            }
        }
        return (Schema)builder.endRecord();
    }

    public static String normalizeNameForAvro(String inputName) {
        String normalizedName = inputName.replaceAll("[^A-Za-z0-9_]", "_");
        if (Character.isDigit(normalizedName.charAt(0))) {
            normalizedName = "_" + normalizedName;
        }
        return normalizedName;
    }

    public static void setParameters(PreparedStatement stmt, Map<String, String> attributes) throws SQLException {
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String key = entry.getKey();
            Matcher matcher = SQL_TYPE_ATTRIBUTE_PATTERN.matcher(key);
            if (!matcher.matches()) continue;
            int parameterIndex = Integer.parseInt(matcher.group(1));
            boolean isNumeric = NUMBER_PATTERN.matcher(entry.getValue()).matches();
            if (!isNumeric) {
                throw new SQLDataException("Value of the " + key + " attribute is '" + entry.getValue() + "', which is not a valid JDBC numeral type");
            }
            int jdbcType = Integer.parseInt(entry.getValue());
            String valueAttrName = "sql.args." + parameterIndex + ".value";
            String parameterValue = attributes.get(valueAttrName);
            String formatAttrName = "sql.args." + parameterIndex + ".format";
            String parameterFormat = attributes.containsKey(formatAttrName) ? attributes.get(formatAttrName) : "";
            try {
                JdbcCommon.setParameter(stmt, valueAttrName, parameterIndex, parameterValue, jdbcType, parameterFormat);
            }
            catch (NumberFormatException nfe) {
                throw new SQLDataException("The value of the " + valueAttrName + " is '" + parameterValue + "', which cannot be converted into the necessary data type", nfe);
            }
            catch (ParseException pe) {
                throw new SQLDataException("The value of the " + valueAttrName + " is '" + parameterValue + "', which cannot be converted to a timestamp", pe);
            }
            catch (UnsupportedEncodingException uee) {
                throw new SQLDataException("The value of the " + valueAttrName + " is '" + parameterValue + "', which cannot be converted to UTF-8", uee);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void setParameter(PreparedStatement stmt, String attrName, int parameterIndex, String parameterValue, int jdbcType, String valueFormat) throws SQLException, ParseException, UnsupportedEncodingException {
        block64: {
            block63: {
                if (parameterValue != null) break block63;
                stmt.setNull(parameterIndex, jdbcType);
                break block64;
            }
            switch (jdbcType) {
                case -7: {
                    stmt.setBoolean(parameterIndex, "1".equals(parameterValue) != false || "t".equalsIgnoreCase(parameterValue) != false || Boolean.parseBoolean(parameterValue) != false);
                    break;
                }
                case 16: {
                    stmt.setBoolean(parameterIndex, Boolean.parseBoolean(parameterValue));
                    break;
                }
                case -6: {
                    stmt.setByte(parameterIndex, Byte.parseByte(parameterValue));
                    break;
                }
                case 5: {
                    stmt.setShort(parameterIndex, Short.parseShort(parameterValue));
                    break;
                }
                case 4: {
                    stmt.setInt(parameterIndex, Integer.parseInt(parameterValue));
                    break;
                }
                case -5: {
                    stmt.setLong(parameterIndex, Long.parseLong(parameterValue));
                    break;
                }
                case 7: {
                    stmt.setFloat(parameterIndex, Float.parseFloat(parameterValue));
                    break;
                }
                case 6: 
                case 8: {
                    stmt.setDouble(parameterIndex, Double.parseDouble(parameterValue));
                    break;
                }
                case 2: 
                case 3: {
                    stmt.setBigDecimal(parameterIndex, new BigDecimal(parameterValue));
                    break;
                }
                case 91: {
                    if (valueFormat.equals("")) {
                        if (JdbcCommon.LONG_PATTERN.matcher(parameterValue).matches()) {
                            date = new Date(Long.parseLong(parameterValue));
                        } else {
                            dateFormatString = "yyyy-MM-dd";
                            dateFormat = new SimpleDateFormat(dateFormatString);
                            parsedDate = dateFormat.parse(parameterValue);
                            date = new Date(parsedDate.getTime());
                        }
                    } else {
                        dtFormatter = JdbcCommon.getDateTimeFormatter(valueFormat);
                        parsedDate = LocalDate.parse(parameterValue, dtFormatter);
                        date = new Date(Date.from(parsedDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()).getTime());
                    }
                    stmt.setDate(parameterIndex, date);
                    break;
                }
                case 92: {
                    if (valueFormat.equals("")) {
                        if (JdbcCommon.LONG_PATTERN.matcher(parameterValue).matches()) {
                            time = new Time(Long.parseLong(parameterValue));
                        } else {
                            timeFormatString = "HH:mm:ss.SSS";
                            dateFormat = new SimpleDateFormat(timeFormatString);
                            parsedDate = dateFormat.parse(parameterValue);
                            time = new Time(parsedDate.getTime());
                        }
                    } else {
                        dtFormatter = JdbcCommon.getDateTimeFormatter(valueFormat);
                        parsedTime = LocalTime.parse(parameterValue, dtFormatter);
                        localDateTime = parsedTime.atDate(LocalDate.ofEpochDay(0L));
                        instant = localDateTime.atZone(ZoneId.systemDefault()).toInstant();
                        time = new Time(instant.toEpochMilli());
                    }
                    stmt.setTime(parameterIndex, time);
                    break;
                }
                case 93: {
                    lTimestamp = 0L;
                    if (valueFormat.equals("")) {
                        if (JdbcCommon.LONG_PATTERN.matcher(parameterValue).matches()) {
                            lTimestamp = Long.parseLong(parameterValue);
                        } else {
                            dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                            parsedDate = dateFormat.parse(parameterValue);
                            lTimestamp = parsedDate.getTime();
                        }
                    } else {
                        dtFormatter = JdbcCommon.getDateTimeFormatter(valueFormat);
                        accessor = dtFormatter.parse(parameterValue);
                        parsedDate = java.util.Date.from(Instant.from(accessor));
                        lTimestamp = parsedDate.getTime();
                    }
                    stmt.setTimestamp(parameterIndex, new Timestamp(lTimestamp));
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    accessor = valueFormat;
                    var12_30 = -1;
                    switch (accessor.hashCode()) {
                        case 0: {
                            if (!accessor.equals("")) break;
                            var12_30 = 0;
                            break;
                        }
                        case 93106001: {
                            if (!accessor.equals("ascii")) break;
                            var12_30 = 1;
                            break;
                        }
                        case 103195: {
                            if (!accessor.equals("hex")) break;
                            var12_30 = 2;
                            break;
                        }
                        case -1396204209: {
                            if (!accessor.equals("base64")) break;
                            var12_30 = 3;
                        }
                    }
                    switch (var12_30) {
                        case 0: 
                        case 1: {
                            bValue = parameterValue.getBytes("ASCII");
                            break;
                        }
                        case 2: {
                            bValue = DatatypeConverter.parseHexBinary((String)parameterValue);
                            break;
                        }
                        case 3: {
                            bValue = DatatypeConverter.parseBase64Binary((String)parameterValue);
                            break;
                        }
                        default: {
                            throw new ParseException("Unable to parse binary data using the formatter `" + valueFormat + "`.", 0);
                        }
                    }
                    stmt.setBinaryStream(parameterIndex, (InputStream)new ByteArrayInputStream(bValue), bValue.length);
                    break;
                }
                case -16: 
                case -1: 
                case 1: 
                case 12: {
                    stmt.setString(parameterIndex, parameterValue);
                    break;
                }
                case 2005: {
                    reader = new StringReader(parameterValue);
                    var12_31 = null;
                    stmt.setCharacterStream(parameterIndex, reader);
                    if (reader == null) break;
                    if (var12_31 == null) ** GOTO lbl130
                    try {
                        reader.close();
                    }
                    catch (Throwable var13_33) {
                        var12_31.addSuppressed(var13_33);
                    }
                    break;
lbl130:
                    // 1 sources

                    reader.close();
                    break;
                    catch (Throwable var13_34) {
                        try {
                            var12_31 = var13_34;
                            throw var13_34;
                        }
                        catch (Throwable var14_37) {
                            if (reader != null) {
                                if (var12_31 != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable var15_38) {
                                        var12_31.addSuppressed(var15_38);
                                    }
                                } else {
                                    reader.close();
                                }
                            }
                            throw var14_37;
                        }
                    }
                }
                case 2011: {
                    reader = new StringReader(parameterValue);
                    var12_32 = null;
                    stmt.setNCharacterStream(parameterIndex, reader);
                    if (reader == null) break;
                    if (var12_32 == null) ** GOTO lbl160
                    try {
                        reader.close();
                    }
                    catch (Throwable var13_35) {
                        var12_32.addSuppressed(var13_35);
                    }
                    break;
lbl160:
                    // 1 sources

                    reader.close();
                    break;
                    catch (Throwable var13_36) {
                        try {
                            var12_32 = var13_36;
                            throw var13_36;
                        }
                        catch (Throwable var16_39) {
                            if (reader != null) {
                                if (var12_32 != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable var17_40) {
                                        var12_32.addSuppressed(var17_40);
                                    }
                                } else {
                                    reader.close();
                                }
                            }
                            throw var16_39;
                        }
                    }
                }
                default: {
                    stmt.setObject(parameterIndex, (Object)parameterValue, jdbcType);
                }
            }
        }
    }

    public static DateTimeFormatter getDateTimeFormatter(String pattern) {
        switch (pattern) {
            case "BASIC_ISO_DATE": {
                return DateTimeFormatter.BASIC_ISO_DATE;
            }
            case "ISO_LOCAL_DATE": {
                return DateTimeFormatter.ISO_LOCAL_DATE;
            }
            case "ISO_OFFSET_DATE": {
                return DateTimeFormatter.ISO_OFFSET_DATE;
            }
            case "ISO_DATE": {
                return DateTimeFormatter.ISO_DATE;
            }
            case "ISO_LOCAL_TIME": {
                return DateTimeFormatter.ISO_LOCAL_TIME;
            }
            case "ISO_OFFSET_TIME": {
                return DateTimeFormatter.ISO_OFFSET_TIME;
            }
            case "ISO_TIME": {
                return DateTimeFormatter.ISO_TIME;
            }
            case "ISO_LOCAL_DATE_TIME": {
                return DateTimeFormatter.ISO_LOCAL_DATE_TIME;
            }
            case "ISO_OFFSET_DATE_TIME": {
                return DateTimeFormatter.ISO_OFFSET_DATE_TIME;
            }
            case "ISO_ZONED_DATE_TIME": {
                return DateTimeFormatter.ISO_ZONED_DATE_TIME;
            }
            case "ISO_DATE_TIME": {
                return DateTimeFormatter.ISO_DATE_TIME;
            }
            case "ISO_ORDINAL_DATE": {
                return DateTimeFormatter.ISO_ORDINAL_DATE;
            }
            case "ISO_WEEK_DATE": {
                return DateTimeFormatter.ISO_WEEK_DATE;
            }
            case "ISO_INSTANT": {
                return DateTimeFormatter.ISO_INSTANT;
            }
            case "RFC_1123_DATE_TIME": {
                return DateTimeFormatter.RFC_1123_DATE_TIME;
            }
        }
        return DateTimeFormatter.ofPattern(pattern);
    }

    public static interface ResultSetRowCallback {
        public void processRow(ResultSet var1) throws IOException;

        public void applyStateChanges();
    }

    public static class AvroConversionOptions {
        private final String recordName;
        private final int maxRows;
        private final boolean convertNames;
        private final boolean useLogicalTypes;
        private final int defaultPrecision;
        private final int defaultScale;
        private final CodecFactory codec;

        private AvroConversionOptions(String recordName, int maxRows, boolean convertNames, boolean useLogicalTypes, int defaultPrecision, int defaultScale, CodecFactory codec) {
            this.recordName = recordName;
            this.maxRows = maxRows;
            this.convertNames = convertNames;
            this.useLogicalTypes = useLogicalTypes;
            this.defaultPrecision = defaultPrecision;
            this.defaultScale = defaultScale;
            this.codec = codec;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String recordName;
            private int maxRows = 0;
            private boolean convertNames = false;
            private boolean useLogicalTypes = false;
            private int defaultPrecision = 10;
            private int defaultScale = 0;
            private CodecFactory codec = CodecFactory.nullCodec();

            public Builder recordName(String recordName) {
                this.recordName = recordName;
                return this;
            }

            public Builder maxRows(int maxRows) {
                this.maxRows = maxRows;
                return this;
            }

            public Builder convertNames(boolean convertNames) {
                this.convertNames = convertNames;
                return this;
            }

            public Builder useLogicalTypes(boolean useLogicalTypes) {
                this.useLogicalTypes = useLogicalTypes;
                return this;
            }

            public Builder defaultPrecision(int defaultPrecision) {
                this.defaultPrecision = defaultPrecision;
                return this;
            }

            public Builder defaultScale(int defaultScale) {
                this.defaultScale = defaultScale;
                return this;
            }

            public Builder codecFactory(String codec) {
                this.codec = AvroUtil.getCodecFactory(codec);
                return this;
            }

            public AvroConversionOptions build() {
                return new AvroConversionOptions(this.recordName, this.maxRows, this.convertNames, this.useLogicalTypes, this.defaultPrecision, this.defaultScale, this.codec);
            }
        }
    }
}

