/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.util.StringUtils;

public abstract class AbstractJsonPathProcessor
extends AbstractProcessor {
    private static final Configuration STRICT_PROVIDER_CONFIGURATION = Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonProvider()).build();
    private static final JsonProvider JSON_PROVIDER = STRICT_PROVIDER_CONFIGURATION.jsonProvider();
    static final Map<String, String> NULL_REPRESENTATION_MAP = new HashMap<String, String>();
    static final String EMPTY_STRING_OPTION = "empty string";
    static final String NULL_STRING_OPTION = "the string 'null'";
    public static final PropertyDescriptor NULL_VALUE_DEFAULT_REPRESENTATION;

    static DocumentContext validateAndEstablishJsonContext(ProcessSession processSession, FlowFile flowFile) {
        final AtomicReference<Object> contextHolder = new AtomicReference<Object>(null);
        processSession.read(flowFile, new InputStreamCallback(){

            public void process(InputStream in) throws IOException {
                try (BufferedInputStream bufferedInputStream = new BufferedInputStream(in);){
                    DocumentContext ctx = JsonPath.using((Configuration)STRICT_PROVIDER_CONFIGURATION).parse((InputStream)bufferedInputStream);
                    contextHolder.set(ctx);
                }
            }
        });
        return contextHolder.get();
    }

    static boolean isJsonScalar(Object obj) {
        return !(obj instanceof Map) && !(obj instanceof List);
    }

    static String getResultRepresentation(Object jsonPathResult, String defaultValue) {
        if (AbstractJsonPathProcessor.isJsonScalar(jsonPathResult)) {
            return Objects.toString(jsonPathResult, defaultValue);
        }
        return JSON_PROVIDER.toJson(jsonPathResult);
    }

    static {
        NULL_REPRESENTATION_MAP.put(EMPTY_STRING_OPTION, "");
        NULL_REPRESENTATION_MAP.put(NULL_STRING_OPTION, "null");
        NULL_VALUE_DEFAULT_REPRESENTATION = new PropertyDescriptor.Builder().name("Null Value Representation").description("Indicates the desired representation of JSON Path expressions resulting in a null value.").required(true).allowableValues(NULL_REPRESENTATION_MAP.keySet()).defaultValue(EMPTY_STRING_OPTION).build();
    }

    static abstract class JsonPathValidator
    implements Validator {
        JsonPathValidator() {
        }

        public ValidationResult validate(String subject, String input, ValidationContext context) {
            String error = null;
            if (this.isStale(subject, input)) {
                if (!StringUtils.isBlank((String)input)) {
                    try {
                        JsonPath compiledJsonPath = JsonPath.compile((String)input, (Predicate[])new Predicate[0]);
                        this.cacheComputedValue(subject, input, compiledJsonPath);
                    }
                    catch (Exception ex) {
                        error = String.format("specified expression was not valid: %s", input);
                    }
                } else {
                    error = "the expression cannot be empty.";
                }
            }
            return new ValidationResult.Builder().subject(subject).valid(error == null).explanation(error).build();
        }

        abstract void cacheComputedValue(String var1, String var2, JsonPath var3);

        abstract boolean isStale(String var1, String var2);
    }
}

