/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.standard;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base32InputStream;
import org.apache.commons.codec.binary.Base32OutputStream;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.apache.commons.codec.binary.Hex;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SideEffectFree;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processors.standard.util.ValidatingBase32InputStream;
import org.apache.nifi.processors.standard.util.ValidatingBase64InputStream;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.util.StopWatch;

@EventDriven
@SideEffectFree
@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"encode", "decode", "base64", "hex"})
@CapabilityDescription(value="Encodes the FlowFile content in base64")
public class EncodeContent
extends AbstractProcessor {
    public static final String ENCODE_MODE = "Encode";
    public static final String DECODE_MODE = "Decode";
    public static final String BASE64_ENCODING = "base64";
    public static final String BASE32_ENCODING = "base32";
    public static final String HEX_ENCODING = "hex";
    public static final PropertyDescriptor MODE = new PropertyDescriptor.Builder().name("Mode").description("Specifies whether the content should be encoded or decoded").required(true).allowableValues(new String[]{"Encode", "Decode"}).defaultValue("Encode").build();
    public static final PropertyDescriptor ENCODING = new PropertyDescriptor.Builder().name("Encoding").description("Specifies the type of encoding used").required(true).allowableValues(new String[]{"base64", "base32", "hex"}).defaultValue("base64").build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Any FlowFile that is successfully encoded or decoded will be routed to success").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("Any FlowFile that cannot be encoded or decoded will be routed to failure").build();
    private List<PropertyDescriptor> properties;
    private Set<Relationship> relationships;
    private static final byte[] HEX_CHARS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    protected void init(ProcessorInitializationContext context) {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(MODE);
        props.add(ENCODING);
        this.properties = Collections.unmodifiableList(props);
        HashSet<Relationship> rels = new HashSet<Relationship>();
        rels.add(REL_SUCCESS);
        rels.add(REL_FAILURE);
        this.relationships = Collections.unmodifiableSet(rels);
    }

    public Set<Relationship> getRelationships() {
        return this.relationships;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        ComponentLog logger = this.getLogger();
        boolean encode = context.getProperty(MODE).getValue().equalsIgnoreCase(ENCODE_MODE);
        String encoding = context.getProperty(ENCODING).getValue();
        Object encoder = null;
        if (encode) {
            if (encoding.equalsIgnoreCase(BASE64_ENCODING)) {
                encoder = new EncodeBase64();
            } else if (encoding.equalsIgnoreCase(BASE32_ENCODING)) {
                encoder = new EncodeBase32();
            } else if (encoding.equalsIgnoreCase(HEX_ENCODING)) {
                encoder = new EncodeHex();
            }
        } else if (encoding.equalsIgnoreCase(BASE64_ENCODING)) {
            encoder = new DecodeBase64();
        } else if (encoding.equalsIgnoreCase(BASE32_ENCODING)) {
            encoder = new DecodeBase32();
        } else if (encoding.equalsIgnoreCase(HEX_ENCODING)) {
            encoder = new DecodeHex();
        }
        if (encoder == null) {
            logger.warn("Unknown operation: {} {}", new Object[]{encode ? "encode" : "decode", encoding});
            return;
        }
        try {
            StopWatch stopWatch = new StopWatch(true);
            flowFile = session.write(flowFile, (StreamCallback)encoder);
            logger.info("Successfully {} {}", new Object[]{encode ? "encoded" : "decoded", flowFile});
            session.getProvenanceReporter().modifyContent(flowFile, stopWatch.getElapsed(TimeUnit.MILLISECONDS));
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (Exception e) {
            logger.error("Failed to {} {} due to {}", new Object[]{encode ? "encode" : "decode", flowFile, e});
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    private static class DecodeHex
    implements StreamCallback {
        private DecodeHex() {
        }

        public void process(InputStream in, OutputStream out) throws IOException {
            int len;
            byte[] inBuf = new byte[8192];
            Hex h = new Hex();
            while ((len = in.read(inBuf)) > 0) {
                int b;
                if (len % 2 != 0 && (b = in.read()) != -1) {
                    inBuf[len] = (byte)b;
                    ++len;
                }
                byte[] slice = Arrays.copyOfRange(inBuf, 0, len);
                try {
                    out.write(h.decode(slice));
                }
                catch (DecoderException ex) {
                    throw new IOException(ex);
                }
            }
            out.flush();
        }
    }

    private static class EncodeHex
    implements StreamCallback {
        private EncodeHex() {
        }

        public void process(InputStream in, OutputStream out) throws IOException {
            int len;
            byte[] inBuf = new byte[8192];
            byte[] outBuf = new byte[inBuf.length * 2];
            while ((len = in.read(inBuf)) > 0) {
                for (int i = 0; i < len; ++i) {
                    outBuf[i * 2] = HEX_CHARS[(inBuf[i] & 0xF0) >>> 4];
                    outBuf[i * 2 + 1] = HEX_CHARS[inBuf[i] & 0xF];
                }
                out.write(outBuf, 0, len * 2);
            }
            out.flush();
        }
    }

    private static class DecodeBase32
    implements StreamCallback {
        private DecodeBase32() {
        }

        public void process(InputStream in, OutputStream out) throws IOException {
            try (Base32InputStream bis = new Base32InputStream((InputStream)new ValidatingBase32InputStream(in));){
                StreamUtils.copy((InputStream)bis, (OutputStream)out);
            }
        }
    }

    private static class EncodeBase32
    implements StreamCallback {
        private EncodeBase32() {
        }

        public void process(InputStream in, OutputStream out) throws IOException {
            try (Base32OutputStream bos = new Base32OutputStream(out);){
                StreamUtils.copy((InputStream)in, (OutputStream)bos);
            }
        }
    }

    private static class DecodeBase64
    implements StreamCallback {
        private DecodeBase64() {
        }

        public void process(InputStream in, OutputStream out) throws IOException {
            try (Base64InputStream bis = new Base64InputStream((InputStream)new ValidatingBase64InputStream(in));){
                StreamUtils.copy((InputStream)bis, (OutputStream)out);
            }
        }
    }

    private static class EncodeBase64
    implements StreamCallback {
        private EncodeBase64() {
        }

        public void process(InputStream in, OutputStream out) throws IOException {
            try (Base64OutputStream bos = new Base64OutputStream(out);){
                StreamUtils.copy((InputStream)in, (OutputStream)bos);
            }
        }
    }
}

