/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.compiler;

import java.util.HashSet;
import javax.wsdl.Fault;
import org.apache.ode.bpel.compiler.CommonCompilationMessages;
import org.apache.ode.bpel.compiler.DefaultActivityGenerator;
import org.apache.ode.bpel.compiler.ReplyGeneratorMessages;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.bom.Activity;
import org.apache.ode.bpel.compiler.bom.Correlation;
import org.apache.ode.bpel.compiler.bom.ReplyActivity;
import org.apache.ode.bpel.o.OActivity;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.OReply;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.utils.msg.MessageBundle;

class ReplyGenerator
extends DefaultActivityGenerator {
    private static final CommonCompilationMessages _cmsgsGeneral = (CommonCompilationMessages)MessageBundle.getMessages(CommonCompilationMessages.class);
    private static final ReplyGeneratorMessages __cmsgsLocal = (ReplyGeneratorMessages)MessageBundle.getMessages(ReplyGeneratorMessages.class);

    ReplyGenerator() {
    }

    public OActivity newInstance(Activity src) {
        return new OReply(this._context.getOProcess(), this._context.getCurrent());
    }

    public void compile(OActivity output, Activity src) {
        ReplyActivity replyDef = (ReplyActivity)src;
        OReply oreply = (OReply)output;
        oreply.isFaultReply = replyDef.getFaultName() != null;
        oreply.partnerLink = this._context.resolvePartnerLink(replyDef.getPartnerLink());
        oreply.messageExchangeId = replyDef.getMessageExchangeId();
        if (replyDef.getVariable() != null) {
            oreply.variable = this._context.resolveVariable(replyDef.getVariable());
            if (!(oreply.variable.type instanceof OMessageVarType)) {
                throw new CompilationException(_cmsgsGeneral.errMessageVariableRequired(oreply.variable.name));
            }
        }
        if (oreply.partnerLink.myRolePortType == null) {
            throw new CompilationException(_cmsgsGeneral.errPartnerLinkDoesNotDeclareMyRole(oreply.partnerLink.getName()));
        }
        if (replyDef.getPortType() != null && !oreply.partnerLink.myRolePortType.getQName().equals(replyDef.getPortType())) {
            throw new CompilationException(_cmsgsGeneral.errPortTypeMismatch(replyDef.getPortType(), oreply.partnerLink.myRolePortType.getQName()));
        }
        oreply.operation = this._context.resolveMyRoleOperation(oreply.partnerLink, replyDef.getOperation());
        if (oreply.operation.getOutput() == null) {
            throw new CompilationException(_cmsgsGeneral.errTwoWayOperationExpected(oreply.operation.getName()));
        }
        if (oreply.isFaultReply) {
            Fault flt = null;
            if (replyDef.getFaultName().getNamespaceURI().equals(oreply.partnerLink.myRolePortType.getQName().getNamespaceURI())) {
                flt = oreply.operation.getFault(replyDef.getFaultName().getLocalPart());
            }
            if (flt == null) {
                throw new CompilationException(__cmsgsLocal.errUndeclaredFault(replyDef.getFaultName().getLocalPart(), oreply.operation.getName()));
            }
            if (oreply.variable != null && !((OMessageVarType)oreply.variable.type).messageType.equals(flt.getMessage().getQName())) {
                throw new CompilationException(_cmsgsGeneral.errVariableTypeMismatch(oreply.variable.name, flt.getMessage().getQName(), ((OMessageVarType)oreply.variable.type).messageType));
            }
            oreply.fault = replyDef.getFaultName();
        } else {
            assert (oreply.fault == null);
            if (oreply.variable == null) {
                throw new CompilationException(__cmsgsLocal.errOutputVariableMustBeSpecified());
            }
            if (!((OMessageVarType)oreply.variable.type).messageType.equals(oreply.operation.getOutput().getMessage().getQName())) {
                throw new CompilationException(_cmsgsGeneral.errVariableTypeMismatch(oreply.variable.name, oreply.operation.getOutput().getMessage().getQName(), ((OMessageVarType)oreply.variable.type).messageType));
            }
        }
        HashSet<String> csetNames = new HashSet<String>();
        for (Correlation correlation : replyDef.getCorrelations()) {
            if (csetNames.contains(correlation.getCorrelationSet())) {
                throw new CompilationException(_cmsgsGeneral.errDuplicateUseCorrelationSet(correlation.getCorrelationSet()));
            }
            OScope.CorrelationSet cset = this._context.resolveCorrelationSet(correlation.getCorrelationSet());
            switch (correlation.getInitiate()) {
                case UNSET: 
                case NO: {
                    oreply.assertCorrelations.add(cset);
                    break;
                }
                case YES: {
                    oreply.initCorrelations.add(cset);
                    break;
                }
                case JOIN: {
                    cset.hasJoinUseCases = true;
                    oreply.joinCorrelations.add(cset);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            for (OProcess.OProperty property : cset.properties) {
                this._context.resolvePropertyAlias(oreply.variable, property.name);
            }
            csetNames.add(correlation.getCorrelationSet());
        }
    }
}

