/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.store;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.ode.utils.fs.FileUtils;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;

public class DocumentEntityResolver
implements XMLEntityResolver {
    private File _docRoot;

    public DocumentEntityResolver(File file) {
        this._docRoot = file;
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier xMLResourceIdentifier) throws XNIException, IOException {
        String string;
        XMLInputSource xMLInputSource = new XMLInputSource(xMLResourceIdentifier);
        String string2 = xMLResourceIdentifier.getLiteralSystemId();
        try {
            string = new URI(FileUtils.encodePath((String)xMLResourceIdentifier.getBaseSystemId())).toURL().getFile();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException("Base system id incorrect, parser error", uRISyntaxException);
        }
        if (new File(new File(string).getParent(), string2).exists()) {
            xMLInputSource.setByteStream(new File(new File(string).getParent(), string2).toURL().openStream());
        } else {
            xMLInputSource.setByteStream(new File(this._docRoot, string2).toURL().openStream());
        }
        return xMLInputSource;
    }
}

