/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.store;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.dd.DeployDocument;
import org.apache.ode.bpel.dd.TDeployment;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.EndpointReferenceContext;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.ProcessState;
import org.apache.ode.bpel.iapi.ProcessStore;
import org.apache.ode.bpel.iapi.ProcessStoreEvent;
import org.apache.ode.bpel.iapi.ProcessStoreListener;
import org.apache.ode.il.config.OdeConfigProperties;
import org.apache.ode.store.ConfStoreConnection;
import org.apache.ode.store.ConfStoreConnectionFactory;
import org.apache.ode.store.DeploymentUnitDAO;
import org.apache.ode.store.DeploymentUnitDir;
import org.apache.ode.store.Messages;
import org.apache.ode.store.ProcessConfDAO;
import org.apache.ode.store.ProcessConfImpl;
import org.apache.ode.store.hib.DbConfStoreConnectionFactory;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.GUID;
import org.apache.ode.utils.msg.MessageBundle;
import org.hsqldb.jdbc.jdbcDataSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessStoreImpl
implements ProcessStore {
    private static final Log __log = LogFactory.getLog(ProcessStoreImpl.class);
    private static final Messages __msgs = (Messages)MessageBundle.getMessages(Messages.class);
    private final CopyOnWriteArrayList<ProcessStoreListener> _listeners = new CopyOnWriteArrayList();
    private Map<QName, ProcessConfImpl> _processes = new HashMap<QName, ProcessConfImpl>();
    private Map<String, DeploymentUnitDir> _deploymentUnits = new HashMap<String, DeploymentUnitDir>();
    private final ReadWriteLock _rw = new ReentrantReadWriteLock();
    private ConfStoreConnectionFactory _cf;
    private EndpointReferenceContext eprContext;
    private boolean generateProcessEventsAll;
    protected File _deployDir;
    protected File _configDir;
    private ExecutorService _executor = Executors.newSingleThreadExecutor(new SimpleThreadFactory());
    private DataSource _inMemDs;

    public ProcessStoreImpl() {
        this(null, null, "", new OdeConfigProperties(new Properties(), ""), true);
    }

    public ProcessStoreImpl(EndpointReferenceContext endpointReferenceContext, DataSource dataSource, String string, OdeConfigProperties odeConfigProperties, boolean bl) {
        this.eprContext = endpointReferenceContext;
        this.generateProcessEventsAll = odeConfigProperties.getProperty("generateProcessEvents", "all").equals("all");
        if (dataSource != null) {
            this._cf = string.toLowerCase().indexOf("hib") != -1 ? new DbConfStoreConnectionFactory(dataSource, odeConfigProperties.getProperties(), bl, odeConfigProperties.getTxFactoryClass()) : new org.apache.ode.store.jpa.DbConfStoreConnectionFactory(dataSource, bl, odeConfigProperties.getTxFactoryClass());
        } else {
            DataSource dataSource2 = ProcessStoreImpl.createInternalDS(new GUID().toString());
            this._cf = "hibernate".equalsIgnoreCase(string) ? new DbConfStoreConnectionFactory(dataSource2, odeConfigProperties.getProperties(), bl, odeConfigProperties.getTxFactoryClass()) : new org.apache.ode.store.jpa.DbConfStoreConnectionFactory(dataSource2, bl, odeConfigProperties.getTxFactoryClass());
            this._inMemDs = dataSource2;
        }
    }

    public ProcessStoreImpl(EndpointReferenceContext endpointReferenceContext, DataSource dataSource) {
        this.eprContext = endpointReferenceContext;
        DataSource dataSource2 = ProcessStoreImpl.createInternalDS(new GUID().toString());
        this._cf = new org.apache.ode.store.jpa.DbConfStoreConnectionFactory(dataSource2, true, "org.apache.ode.il.EmbeddedGeronimoFactory");
        this._inMemDs = dataSource2;
    }

    public void shutdown() {
        if (this._inMemDs != null) {
            ProcessStoreImpl.shutdownInternalDB(this._inMemDs);
            this._inMemDs = null;
        }
        if (this._executor != null) {
            this._executor.shutdownNow();
            this._executor = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.shutdown();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }

    public Collection<QName> deploy(File file, boolean bl) {
        return this.deploy(file, true, null, bl);
    }

    public Collection<QName> deploy(File file) {
        return this.deploy(file, true, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<QName> deploy(final File file, boolean bl, String string, boolean bl2) {
        __log.info((Object)__msgs.msgDeployStarting(file));
        Date date = new Date();
        final DeploymentUnitDir deploymentUnitDir = new DeploymentUnitDir(file);
        if (string != null) {
            deploymentUnitDir.setName(string);
        }
        long l = bl2 || deploymentUnitDir.getStaticVersion() == -1L ? this.exec(new Callable<Long>(){

            @Override
            public Long call(ConfStoreConnection confStoreConnection) {
                return confStoreConnection.getNextVersion();
            }
        }).longValue() : deploymentUnitDir.getStaticVersion();
        deploymentUnitDir.setVersion(l);
        try {
            deploymentUnitDir.compile();
        }
        catch (CompilationException compilationException) {
            String string2 = __msgs.msgDeployFailCompileErrors(compilationException);
            __log.error((Object)string2, (Throwable)compilationException);
            throw new ContextException(string2, (Throwable)compilationException);
        }
        deploymentUnitDir.scan();
        DeployDocument deployDocument = deploymentUnitDir.getDeploymentDescriptor();
        final ArrayList<Object> arrayList = new ArrayList<Object>();
        this._rw.writeLock().lock();
        try {
            if (this._deploymentUnits.containsKey(deploymentUnitDir.getName())) {
                String string3 = __msgs.msgDeployFailDuplicateDU(deploymentUnitDir.getName());
                __log.error((Object)string3);
                throw new ContextException(string3);
            }
            this.retirePreviousPackageVersions(deploymentUnitDir);
            for (Object object : deployDocument.getDeploy().getProcessList()) {
                Object object2;
                Object object3;
                QName qName = this.toPid(object.getName(), l);
                if (this._processes.containsKey(qName)) {
                    object3 = __msgs.msgDeployFailDuplicatePID(object.getName(), deploymentUnitDir.getName());
                    __log.error(object3);
                    throw new ContextException((String)object3);
                }
                object3 = object.getType() != null ? object.getType() : object.getName();
                DeploymentUnitDir.CBPInfo cBPInfo = deploymentUnitDir.getCBPInfo((QName)object3);
                if (cBPInfo == null) {
                    object2 = __msgs.msgDeployFailedProcessNotFound(object.getName(), deploymentUnitDir.getName());
                    __log.error(object2);
                    throw new ContextException((String)object2);
                }
                object2 = new ProcessConfImpl(qName, object.getName(), l, deploymentUnitDir, (TDeployment.Process)object, date, ProcessStoreImpl.calcInitialProperties(deploymentUnitDir.getProperties(), (TDeployment.Process)object), ProcessStoreImpl.calcInitialState((TDeployment.Process)object), this.eprContext, this._configDir, this.generateProcessEventsAll);
                arrayList.add(object2);
            }
            this._deploymentUnits.put(deploymentUnitDir.getName(), deploymentUnitDir);
            for (Object object : arrayList) {
                __log.info((Object)__msgs.msgProcessDeployed(deploymentUnitDir.getDeployDir(), ((ProcessConfImpl)object).getProcessId()));
                this._processes.put(((ProcessConfImpl)object).getProcessId(), (ProcessConfImpl)object);
            }
        }
        finally {
            this._rw.writeLock().unlock();
        }
        Collection<QName> collection = this.exec(new Callable<Collection<QName>>(){

            @Override
            public Collection<QName> call(ConfStoreConnection confStoreConnection) {
                Object object;
                DeploymentUnitDAO deploymentUnitDAO = confStoreConnection.getDeploymentUnit(deploymentUnitDir.getName());
                if (deploymentUnitDAO != null) {
                    object = "Database out of synch for DU " + deploymentUnitDir.getName();
                    __log.warn(object);
                    deploymentUnitDAO.delete();
                }
                deploymentUnitDAO = confStoreConnection.createDeploymentUnit(deploymentUnitDir.getName());
                try {
                    deploymentUnitDAO.setDeploymentUnitDir(file.getCanonicalPath());
                }
                catch (IOException iOException) {
                    String string = "Error getting canonical path for " + deploymentUnitDir.getName() + "; deployment unit will not be available after restart!";
                    __log.error((Object)string);
                }
                object = new ArrayList();
                for (ProcessConfImpl processConfImpl : arrayList) {
                    try {
                        ProcessConfDAO processConfDAO = deploymentUnitDAO.createProcess(processConfImpl.getProcessId(), processConfImpl.getType(), processConfImpl.getVersion());
                        processConfDAO.setState(processConfImpl.getState());
                        for (Map.Entry entry : processConfImpl.getProcessProperties().entrySet()) {
                            processConfDAO.setProperty((QName)entry.getKey(), DOMUtils.domToString((Node)((Node)entry.getValue())));
                        }
                        ((ArrayList)object).add(processConfImpl.getProcessId());
                        confStoreConnection.setVersion(processConfImpl.getVersion());
                    }
                    catch (Throwable throwable) {
                        String string = "Error persisting deployment record for " + processConfImpl.getProcessId() + "; process will not be available after restart!";
                        __log.error((Object)string, throwable);
                    }
                }
                return object;
            }
        });
        try {
            for (Object object : arrayList) {
                this.fireEvent(new ProcessStoreEvent(ProcessStoreEvent.Type.DEPLOYED, ((ProcessConfImpl)object).getProcessId(), ((ProcessConfImpl)object).getDeploymentUnit().getName()));
                this.fireStateChange(((ProcessConfImpl)object).getProcessId(), ((ProcessConfImpl)object).getState(), ((ProcessConfImpl)object).getDeploymentUnit().getName());
            }
        }
        catch (Exception exception) {
            __log.warn((Object)"Deployment failed within the engine, store undeploying process.", (Throwable)exception);
            this.undeploy(file);
            if (exception instanceof ContextException) {
                throw (ContextException)exception;
            }
            throw new ContextException("Deployment failed within the engine.", (Throwable)exception);
        }
        return collection;
    }

    private void retirePreviousPackageVersions(DeploymentUnitDir deploymentUnitDir) {
        String[] stringArray = deploymentUnitDir.getName().split("/");
        stringArray[0] = stringArray[0].replaceAll("([-\\Q.\\E](\\d)+)?\\z", "");
        stringArray[0] = stringArray[0] + "([-\\Q.\\E](\\d)+)?";
        StringBuilder stringBuilder = new StringBuilder(deploymentUnitDir.getName().length() * 2);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append("/");
            }
            stringBuilder.append(stringArray[i]);
        }
        Pattern pattern = Pattern.compile(stringBuilder.toString());
        for (String string : this._deploymentUnits.keySet()) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) continue;
            this.setRetiredPackage(string, true);
        }
    }

    public Collection<QName> undeploy(File file) {
        return this.undeploy(file.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<QName> undeploy(final String string) {
        try {
            this.exec(new Callable<Collection<QName>>(){

                @Override
                public Collection<QName> call(ConfStoreConnection confStoreConnection) {
                    DeploymentUnitDAO deploymentUnitDAO = confStoreConnection.getDeploymentUnit(string);
                    if (deploymentUnitDAO != null) {
                        deploymentUnitDAO.delete();
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {
            __log.error((Object)("Error synchronizing with data store; " + string + " may be reappear after restart!"));
        }
        List<QName> list = Collections.emptyList();
        this._rw.writeLock().lock();
        try {
            DeploymentUnitDir deploymentUnitDir = this._deploymentUnits.remove(string);
            if (deploymentUnitDir != null) {
                list = this.toPids(deploymentUnitDir.getProcessNames(), deploymentUnitDir.getVersion());
            }
            for (QName qName : list) {
                this.fireEvent(new ProcessStoreEvent(ProcessStoreEvent.Type.UNDEPLOYED, qName, deploymentUnitDir.getName()));
                __log.info((Object)__msgs.msgProcessUndeployed(qName));
            }
            this._processes.keySet().removeAll(list);
        }
        finally {
            this._rw.writeLock().unlock();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getPackages() {
        this._rw.readLock().lock();
        try {
            ArrayList<String> arrayList = new ArrayList<String>(this._deploymentUnits.keySet());
            return arrayList;
        }
        finally {
            this._rw.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QName> listProcesses(String string) {
        this._rw.readLock().lock();
        try {
            DeploymentUnitDir deploymentUnitDir = this._deploymentUnits.get(string);
            if (deploymentUnitDir == null) {
                List<QName> list = null;
                return list;
            }
            List<QName> list = this.toPids(deploymentUnitDir.getProcessNames(), deploymentUnitDir.getVersion());
            return list;
        }
        finally {
            this._rw.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(final QName qName, final ProcessState processState) {
        ProcessConfImpl processConfImpl;
        __log.debug((Object)("Changing process state for " + qName + " to " + processState));
        this._rw.readLock().lock();
        try {
            processConfImpl = this._processes.get(qName);
            if (processConfImpl == null) {
                String string = __msgs.msgProcessNotFound(qName);
                __log.info((Object)string);
                throw new ContextException(string);
            }
        }
        finally {
            this._rw.readLock().unlock();
        }
        final DeploymentUnitDir deploymentUnitDir = processConfImpl.getDeploymentUnit();
        ProcessState processState2 = this.exec(new Callable<ProcessState>(){

            @Override
            public ProcessState call(ConfStoreConnection confStoreConnection) {
                DeploymentUnitDAO deploymentUnitDAO = confStoreConnection.getDeploymentUnit(deploymentUnitDir.getName());
                if (deploymentUnitDAO == null) {
                    String string = __msgs.msgProcessNotFound(qName);
                    __log.error((Object)string);
                    throw new ContextException(string);
                }
                ProcessConfDAO processConfDAO = deploymentUnitDAO.getProcess(qName);
                if (processConfDAO == null) {
                    String string = __msgs.msgProcessNotFound(qName);
                    __log.error((Object)string);
                    throw new ContextException(string);
                }
                ProcessState processState2 = processConfDAO.getState();
                processConfDAO.setState(processState);
                processConfImpl.setState(processState);
                return processState2;
            }
        });
        processConfImpl.setState(processState);
        if (processState2 != null && processState2 != processState) {
            this.fireStateChange(qName, processState, processConfImpl.getDeploymentUnit().getName());
        }
    }

    public void setRetiredPackage(String string, boolean bl) {
        DeploymentUnitDir deploymentUnitDir = this._deploymentUnits.get(string);
        if (deploymentUnitDir == null) {
            throw new ContextException("Could not find package " + string);
        }
        for (QName qName : deploymentUnitDir.getProcessNames()) {
            this.setState(this.toPid(qName, deploymentUnitDir.getVersion()), bl ? ProcessState.RETIRED : ProcessState.ACTIVE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessConf getProcessConfiguration(QName qName) {
        this._rw.readLock().lock();
        try {
            ProcessConf processConf = this._processes.get(qName);
            return processConf;
        }
        finally {
            this._rw.readLock().unlock();
        }
    }

    public void setProperty(QName qName, QName qName2, Node node) {
        this.setProperty(qName, qName2, DOMUtils.domToStringLevel2((Node)node));
    }

    public void setProperty(final QName qName, final QName qName2, final String string) {
        ProcessConfImpl processConfImpl;
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Setting property " + qName2 + " on process " + qName));
        }
        if ((processConfImpl = this._processes.get(qName)) == null) {
            String string2 = __msgs.msgProcessNotFound(qName);
            __log.info((Object)string2);
            throw new ContextException(string2);
        }
        final DeploymentUnitDir deploymentUnitDir = processConfImpl.getDeploymentUnit();
        this.exec(new Callable<Object>(){

            @Override
            public Object call(ConfStoreConnection confStoreConnection) {
                DeploymentUnitDAO deploymentUnitDAO = confStoreConnection.getDeploymentUnit(deploymentUnitDir.getName());
                if (deploymentUnitDAO == null) {
                    return null;
                }
                ProcessConfDAO processConfDAO = deploymentUnitDAO.getProcess(qName);
                if (processConfDAO == null) {
                    return null;
                }
                processConfDAO.setProperty(qName2, string);
                return null;
            }
        });
        this.fireEvent(new ProcessStoreEvent(ProcessStoreEvent.Type.PROPERTY_CHANGED, qName, deploymentUnitDir.getName()));
    }

    public void loadAll() {
        final ArrayList arrayList = new ArrayList();
        this.exec(new Callable<Object>(){

            @Override
            public Object call(ConfStoreConnection confStoreConnection) {
                Collection<DeploymentUnitDAO> collection = confStoreConnection.getDeploymentUnits();
                for (DeploymentUnitDAO deploymentUnitDAO : collection) {
                    try {
                        arrayList.addAll(ProcessStoreImpl.this.load(deploymentUnitDAO));
                    }
                    catch (Exception exception) {
                        __log.error((Object)("Error loading DU from store: " + deploymentUnitDAO.getName()), (Throwable)exception);
                    }
                }
                return null;
            }
        });
        Collections.sort(arrayList, new Comparator<ProcessConf>(){

            @Override
            public int compare(ProcessConf processConf, ProcessConf processConf2) {
                return this.stateValue(processConf.getState()) - this.stateValue(processConf2.getState());
            }

            int stateValue(ProcessState processState) {
                if (ProcessState.DISABLED.equals((Object)processState)) {
                    return 0;
                }
                if (ProcessState.RETIRED.equals((Object)processState)) {
                    return 1;
                }
                if (ProcessState.ACTIVE.equals((Object)processState)) {
                    return 2;
                }
                throw new IllegalStateException("Unexpected process state: " + processState);
            }
        });
        for (ProcessConfImpl processConfImpl : arrayList) {
            try {
                this.fireStateChange(processConfImpl.getProcessId(), processConfImpl.getState(), processConfImpl.getDeploymentUnit().getName());
            }
            catch (Exception exception) {
                __log.error((Object)("Error while activating process: pid=" + processConfImpl.getProcessId() + " package=" + processConfImpl.getDeploymentUnit().getName()), (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QName> getProcesses() {
        this._rw.readLock().lock();
        try {
            ArrayList<QName> arrayList = new ArrayList<QName>(this._processes.keySet());
            return arrayList;
        }
        finally {
            this._rw.readLock().unlock();
        }
    }

    public long getCurrentVersion() {
        long l = this.exec(new Callable<Long>(){

            @Override
            public Long call(ConfStoreConnection confStoreConnection) {
                return confStoreConnection.getNextVersion();
            }
        });
        return l;
    }

    protected void fireEvent(ProcessStoreEvent processStoreEvent) {
        __log.debug((Object)("firing event: " + processStoreEvent));
        for (ProcessStoreListener processStoreListener : this._listeners) {
            processStoreListener.onProcessStoreEvent(processStoreEvent);
        }
    }

    private void fireStateChange(QName qName, ProcessState processState, String string) {
        switch (processState) {
            case ACTIVE: {
                this.fireEvent(new ProcessStoreEvent(ProcessStoreEvent.Type.ACTVIATED, qName, string));
                break;
            }
            case DISABLED: {
                this.fireEvent(new ProcessStoreEvent(ProcessStoreEvent.Type.DISABLED, qName, string));
                break;
            }
            case RETIRED: {
                this.fireEvent(new ProcessStoreEvent(ProcessStoreEvent.Type.RETIRED, qName, string));
            }
        }
    }

    public void registerListener(ProcessStoreListener processStoreListener) {
        __log.debug((Object)("Registering listener " + processStoreListener));
        this._listeners.add(processStoreListener);
    }

    public void unregisterListener(ProcessStoreListener processStoreListener) {
        __log.debug((Object)("Unregistering listener " + processStoreListener));
        this._listeners.remove(processStoreListener);
    }

    synchronized <T> T exec(Callable<T> callable) {
        Future<T> future = this._executor.submit(callable);
        try {
            return future.get();
        }
        catch (Exception exception) {
            throw new ContextException("DbError", (Throwable)exception);
        }
    }

    private ConfStoreConnection getConnection() {
        return this._cf.getConnection();
    }

    public static Map<QName, Node> calcInitialProperties(Properties properties, TDeployment.Process process) {
        Document document;
        Object object;
        HashMap<QName, Node> hashMap = new HashMap<QName, Node>();
        for (Object object2 : properties.keySet()) {
            object = (String)object2;
            document = DOMUtils.newDocument();
            document.appendChild(document.createElementNS(null, "temporary-simple-type-wrapper"));
            document.getDocumentElement().appendChild(document.createTextNode(properties.getProperty((String)object)));
            hashMap.put(new QName((String)object), document.getDocumentElement());
        }
        if (process.getPropertyList().size() > 0) {
            for (Object object2 : process.getPropertyList()) {
                object = DOMUtils.getElementContent((Node)object2.getDomNode());
                if (object != null) {
                    document = DOMUtils.newDocument();
                    document.appendChild(document.importNode((Node)object, true));
                    hashMap.put(object2.getName(), document.getDocumentElement());
                    continue;
                }
                hashMap.put(object2.getName(), object2.getDomNode().getFirstChild());
            }
        }
        return hashMap;
    }

    private static ProcessState calcInitialState(TDeployment.Process process) {
        ProcessState processState = ProcessState.ACTIVE;
        if (process.isSetActive() && !process.getActive()) {
            processState = ProcessState.DISABLED;
        }
        if (process.isSetRetired() && process.getRetired()) {
            processState = ProcessState.RETIRED;
        }
        return processState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ProcessConfImpl> load(DeploymentUnitDAO deploymentUnitDAO) {
        __log.debug((Object)("Loading deployment unit record from db: " + deploymentUnitDAO.getName()));
        File file = this.findDeployDir(deploymentUnitDAO);
        if (file == null || !file.exists()) {
            throw new ContextException("Deployed directory " + (file == null ? "(unknown)" : file) + " no longer there!");
        }
        DeploymentUnitDir deploymentUnitDir = new DeploymentUnitDir(file);
        deploymentUnitDir.setName(deploymentUnitDAO.getName());
        deploymentUnitDir.scan();
        ArrayList<ProcessConfImpl> arrayList = new ArrayList<ProcessConfImpl>();
        this._rw.writeLock().lock();
        try {
            this._deploymentUnits.put(deploymentUnitDir.getName(), deploymentUnitDir);
            long l = 0L;
            for (ProcessConfDAO processConfDAO : deploymentUnitDAO.getProcesses()) {
                TDeployment.Process process = deploymentUnitDir.getProcessDeployInfo(processConfDAO.getType());
                if (process == null) {
                    __log.warn((Object)("Cannot load " + processConfDAO.getPID() + "; cannot find descriptor."));
                    continue;
                }
                Map<QName, Node> map = ProcessStoreImpl.calcInitialProperties(deploymentUnitDir.getProperties(), process);
                ProcessConfImpl processConfImpl = new ProcessConfImpl(processConfDAO.getPID(), processConfDAO.getType(), processConfDAO.getVersion(), deploymentUnitDir, process, deploymentUnitDAO.getDeployDate(), map, processConfDAO.getState(), this.eprContext, this._configDir, this.generateProcessEventsAll);
                l = processConfDAO.getVersion();
                this._processes.put(processConfImpl.getProcessId(), processConfImpl);
                arrayList.add(processConfImpl);
            }
            deploymentUnitDir.setVersion(l);
        }
        finally {
            this._rw.writeLock().unlock();
        }
        return arrayList;
    }

    protected File findDeployDir(DeploymentUnitDAO deploymentUnitDAO) {
        File file = new File(deploymentUnitDAO.getDeploymentUnitDir());
        if (file.exists()) {
            return file;
        }
        file = new File(this._deployDir, deploymentUnitDAO.getName());
        if (file.exists()) {
            try {
                deploymentUnitDAO.setDeploymentUnitDir(file.getCanonicalPath());
            }
            catch (IOException iOException) {
                __log.warn((Object)("Could not update deployment unit directory for " + deploymentUnitDAO.getName()), (Throwable)iOException);
            }
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean load(final String string) {
        this._rw.writeLock().lock();
        try {
            if (this._deploymentUnits.containsKey(string)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this._rw.writeLock().unlock();
        }
        try {
            return this.exec(new Callable<Boolean>(){

                @Override
                public Boolean call(ConfStoreConnection confStoreConnection) {
                    DeploymentUnitDAO deploymentUnitDAO = confStoreConnection.getDeploymentUnit(string);
                    if (deploymentUnitDAO == null) {
                        return false;
                    }
                    ProcessStoreImpl.this.load(deploymentUnitDAO);
                    return true;
                }
            });
        }
        catch (Exception exception) {
            __log.error((Object)("Error loading deployment unit: " + string));
            return false;
        }
    }

    public void setDeployDir(File file) {
        if (file != null) {
            if (!file.exists()) {
                file.mkdirs();
                __log.warn((Object)("Deploy directory: " + file.getAbsolutePath() + " does not exist; created it."));
            } else if (!file.isDirectory()) {
                throw new IllegalArgumentException("Deploy directory is not a directory:  " + file);
            }
        }
        this._deployDir = file;
    }

    public File getDeployDir() {
        return this._deployDir;
    }

    public File getConfigDir() {
        return this._configDir;
    }

    public void setConfigDir(File file) {
        if (file != null && !file.isDirectory()) {
            throw new IllegalArgumentException("Config directory is not a directory or does not exist: " + file);
        }
        this._configDir = file;
    }

    public static DataSource createInternalDS(String string) {
        jdbcDataSource jdbcDataSource2 = new jdbcDataSource();
        jdbcDataSource2.setDatabase("jdbc:hsqldb:mem:" + string);
        jdbcDataSource2.setUser("sa");
        jdbcDataSource2.setPassword("");
        return jdbcDataSource2;
    }

    public static void shutdownInternalDB(DataSource dataSource) {
        try {
            dataSource.getConnection().createStatement().execute("SHUTDOWN;");
        }
        catch (SQLException sQLException) {
            __log.error((Object)"Error shutting down.", (Throwable)sQLException);
        }
    }

    private List<QName> toPids(Collection<QName> collection, long l) {
        ArrayList<QName> arrayList = new ArrayList<QName>();
        for (QName qName : collection) {
            arrayList.add(this.toPid(qName, l));
        }
        return arrayList;
    }

    private QName toPid(QName qName, long l) {
        return new QName(qName.getNamespaceURI(), qName.getLocalPart() + "-" + l);
    }

    public void refreshSchedules(String string) {
        List<QName> list = this.listProcesses(string);
        if (list != null) {
            for (QName qName : list) {
                this.fireEvent(new ProcessStoreEvent(ProcessStoreEvent.Type.SCHEDULE_SETTINGS_CHANGED, qName, string));
            }
        }
    }

    private class SimpleThreadFactory
    implements ThreadFactory {
        int threadNumber = 0;

        private SimpleThreadFactory() {
        }

        public Thread newThread(Runnable runnable) {
            ++this.threadNumber;
            Thread thread = new Thread(runnable, "ProcessStoreImpl-" + this.threadNumber);
            thread.setDaemon(true);
            return thread;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class Callable<V>
    implements java.util.concurrent.Callable<V> {
        Callable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V call() {
            boolean bl = false;
            ProcessStoreImpl.this._cf.beginTransaction();
            ConfStoreConnection confStoreConnection = ProcessStoreImpl.this.getConnection();
            try {
                V v = this.call(confStoreConnection);
                ProcessStoreImpl.this._cf.commitTransaction();
                bl = true;
                V v2 = v;
                return v2;
            }
            finally {
                if (!bl) {
                    try {
                        ProcessStoreImpl.this._cf.rollbackTransaction();
                    }
                    catch (Exception exception) {
                        __log.error((Object)"DbError", (Throwable)exception);
                    }
                }
            }
        }

        abstract V call(ConfStoreConnection var1);
    }
}

