/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.store;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.BpelC;
import org.apache.ode.bpel.compiler.BpelCompiler;
import org.apache.ode.bpel.compiler.DefaultResourceFinder;
import org.apache.ode.bpel.compiler.ResourceFinder;
import org.apache.ode.bpel.compiler.WSDLLocatorImpl;
import org.apache.ode.bpel.compiler.wsdl.Definition4BPEL;
import org.apache.ode.bpel.compiler.wsdl.WSDLFactory4BPEL;
import org.apache.ode.bpel.compiler.wsdl.WSDLFactoryBPEL20;
import org.apache.ode.bpel.dd.DeployDocument;
import org.apache.ode.bpel.dd.TDeployment;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.o.Serializer;
import org.apache.ode.store.DocumentRegistry;
import org.apache.ode.store.ProcessStoreImpl;
import org.apache.ode.utils.InternPool;
import org.apache.ode.utils.fs.FileUtils;
import org.apache.xmlbeans.XmlOptions;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DeploymentUnitDir {
    private static Log __log = LogFactory.getLog(DeploymentUnitDir.class);
    private String _name;
    private File _duDirectory;
    private File _descriptorFile;
    private Properties _properties = new Properties();
    private HashMap<QName, CBPInfo> _processes = new HashMap();
    private HashMap<QName, TDeployment.Process> _processInfo = new HashMap();
    private volatile DeployDocument _dd;
    private volatile DocumentRegistry _docRegistry;
    private long _version = -1L;
    private static final FileFilter _wsdlFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.getName().endsWith(".wsdl") && file.isFile();
        }
    };
    private static final FileFilter _cbpFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.getName().endsWith(".cbp") && file.isFile();
        }
    };
    private static final FileFilter _bpelFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.getName().endsWith(".bpel") && file.isFile();
        }
    };
    private static final FileFilter _endpointFilter = new FileFilter(){

        public boolean accept(File file) {
            return (file.getName().endsWith(".endpoint") || file.getName().equals("endpoint-configuration.properties")) && file.isFile();
        }
    };

    DeploymentUnitDir(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("Directory " + file + " does not exist!");
        }
        this._duDirectory = file;
        this._name = file.getName();
        this._descriptorFile = new File(this._duDirectory, "deploy.xml");
        if (!this._descriptorFile.exists()) {
            throw new IllegalArgumentException("Directory " + file + " does not contain a deploy.xml file!");
        }
        try {
            ClassPathXmlApplicationContext classPathXmlApplicationContext = new ClassPathXmlApplicationContext("beans.xml");
            this._properties = (Properties)classPathXmlApplicationContext.getBean("properties");
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Loaded spring properties from file beans.xml:" + this._properties + " for " + this._name));
            }
        }
        catch (Exception exception) {
            __log.info((Object)("Can't initialize beans.xml application context " + exception + " for " + this._name));
        }
    }

    String getName() {
        return this._duDirectory.getName();
    }

    void setName(String string) {
        this._name = string;
    }

    CBPInfo getCBPInfo(QName qName) {
        return this._processes.get(qName);
    }

    void compile() {
        List list = FileUtils.directoryEntriesInPath((File)this._duDirectory, (FileFilter)_bpelFilter);
        if (list.size() == 0) {
            throw new IllegalArgumentException("Directory " + this._duDirectory.getName() + " does not contain any process!");
        }
        for (File file : list) {
            String string = file.getAbsolutePath();
            File file2 = new File(string.substring(0, string.lastIndexOf(".bpel")) + ".cbp");
            if (!file2.exists() || file2.lastModified() < file.lastModified()) {
                __log.debug((Object)("compiling " + file));
                this.compile(file);
                continue;
            }
            __log.debug((Object)("skipping compilation of " + file + " cbp found: " + file2));
        }
    }

    void scan() {
        HashMap<QName, CBPInfo> hashMap = new HashMap<QName, CBPInfo>();
        List list = FileUtils.directoryEntriesInPath((File)this._duDirectory, (FileFilter)_cbpFilter);
        for (Object object : list) {
            CBPInfo cBPInfo = this.loadCBPInfo((File)object);
            hashMap.put(cBPInfo.processName, cBPInfo);
        }
        this._processes = hashMap;
        HashMap hashMap2 = new HashMap();
        for (CBPInfo cBPInfo : this.getDeploymentDescriptor().getDeploy().getProcessList()) {
            hashMap2.put(cBPInfo.getName(), cBPInfo);
        }
        this._processInfo = hashMap2;
    }

    boolean isRemoved() {
        return !this._duDirectory.exists();
    }

    private void compile(final File file) {
        final BpelC bpelC = BpelC.newBpelCompiler();
        File file2 = this.findBpel11Wsdl(file);
        if (file2 != null) {
            bpelC.setProcessWSDL(file2.toURI());
        }
        bpelC.setCompileProperties(this.prepareCompileProperties(file));
        bpelC.setBaseDirectory(this._duDirectory);
        InternPool.runBlock((InternPool.InternableBlock)new InternPool.InternableBlock(){

            public void run() {
                try {
                    bpelC.compile(file, DeploymentUnitDir.this.getVersion());
                }
                catch (IOException iOException) {
                    __log.error((Object)("Compile error in " + file), (Throwable)iOException);
                }
            }
        });
    }

    private CBPInfo loadCBPInfo(File file) {
        FileInputStream fileInputStream = null;
        try {
            CBPInfo cBPInfo;
            fileInputStream = new FileInputStream(file);
            Serializer serializer = new Serializer((InputStream)fileInputStream);
            CBPInfo cBPInfo2 = cBPInfo = new CBPInfo(serializer.type, serializer.guid, file);
            return cBPInfo2;
        }
        catch (Exception exception) {
            throw new ContextException("Couldn't read compiled BPEL process " + file.getAbsolutePath(), (Throwable)exception);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public int hashCode() {
        return this._duDirectory.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DeploymentUnitDir)) {
            return false;
        }
        return ((DeploymentUnitDir)object).getDeployDir().getAbsolutePath().equals(this.getDeployDir().getAbsolutePath());
    }

    public File getDeployDir() {
        return this._duDirectory;
    }

    public List<File> getEndpointConfigFiles() {
        return FileUtils.directoryEntriesInPath((File)this.getDeployDir(), (FileFilter)_endpointFilter);
    }

    public DeployDocument getDeploymentDescriptor() {
        if (this._dd == null) {
            File file = new File(this._duDirectory, "deploy.xml");
            try {
                XmlOptions xmlOptions = new XmlOptions();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("http://ode.fivesight.com/schemas/2006/06/27/dd", "http://www.apache.org/ode/schemas/dd/2007/03");
                xmlOptions.setLoadSubstituteNamespaces(hashMap);
                this._dd = DeployDocument.Factory.parse((File)file, (XmlOptions)xmlOptions);
            }
            catch (Exception exception) {
                throw new ContextException("Couldn't read deployment descriptor at location " + file.getAbsolutePath(), (Throwable)exception);
            }
        }
        return this._dd;
    }

    public DocumentRegistry getDocRegistry() {
        if (this._docRegistry == null) {
            this._docRegistry = new DocumentRegistry();
            WSDLFactory4BPEL wSDLFactory4BPEL = (WSDLFactory4BPEL)WSDLFactoryBPEL20.newInstance();
            WSDLReader wSDLReader = wSDLFactory4BPEL.newWSDLReader();
            DefaultResourceFinder defaultResourceFinder = new DefaultResourceFinder(this._duDirectory, this._duDirectory);
            URI uRI = this._duDirectory.toURI();
            List list = FileUtils.directoryEntriesInPath((File)this._duDirectory, (FileFilter)_wsdlFilter);
            for (File file : list) {
                URI uRI2 = uRI.relativize(file.toURI());
                try {
                    this._docRegistry.addDefinition((Definition4BPEL)wSDLReader.readWSDL((WSDLLocator)new WSDLLocatorImpl((ResourceFinder)defaultResourceFinder, uRI2)));
                }
                catch (WSDLException wSDLException) {
                    throw new ContextException("Couldn't read WSDL document at " + uRI2, (Throwable)wSDLException);
                }
            }
        }
        return this._docRegistry;
    }

    public Definition getDefinitionForService(QName qName) {
        return this.getDocRegistry().getDefinition(qName);
    }

    public Definition getDefinitionForPortType(QName qName) {
        return this.getDocRegistry().getDefinitionForPortType(qName);
    }

    public Collection<Definition> getDefinitions() {
        Definition4BPEL[] definition4BPELArray = this.getDocRegistry().getDefinitions();
        ArrayList<Definition> arrayList = new ArrayList<Definition>(definition4BPELArray.length);
        for (Definition4BPEL definition4BPEL : definition4BPELArray) {
            arrayList.add((Definition)definition4BPEL);
        }
        return arrayList;
    }

    public Set<QName> getProcessNames() {
        return this._processInfo.keySet();
    }

    public String toString() {
        return "{DeploymentUnit " + this._name + "}";
    }

    public TDeployment.Process getProcessDeployInfo(QName qName) {
        if (this._processInfo == null) {
            // empty if block
        }
        return this._processInfo.get(qName);
    }

    public List<File> allFiles() {
        return this.allFiles(this._duDirectory);
    }

    private List<File> allFiles(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                arrayList.addAll(this.allFiles(file2));
            }
            if (file2.isHidden() || !file2.isFile()) continue;
            arrayList.add(file2);
        }
        return arrayList;
    }

    private Map<String, Object> prepareCompileProperties(File file) {
        List list = this.getDeploymentDescriptor().getDeploy().getProcessList();
        for (TDeployment.Process process : list) {
            if (process.getFileName() == null || "".equals(process.getFileName()) || !file.getName().equals(process.getFileName())) continue;
            Map<QName, Node> map = ProcessStoreImpl.calcInitialProperties(this._properties, process);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("customProps", map);
            return hashMap;
        }
        return null;
    }

    private File findBpel11Wsdl(File file) {
        List list = this.getDeploymentDescriptor().getDeploy().getProcessList();
        for (TDeployment.Process process : list) {
            if (process.getFileName() == null || "".equals(process.getFileName()) || !file.getName().equals(process.getFileName())) continue;
            if (process.getBpel11WsdlFileName() == null || "".equals(process.getBpel11WsdlFileName())) {
                return null;
            }
            return new File(file.getParentFile(), process.getBpel11WsdlFileName());
        }
        return null;
    }

    public long getVersion() {
        return this._version;
    }

    public long getStaticVersion() {
        return BpelCompiler.getVersion((String)this.getName());
    }

    public void setVersion(long l) {
        this._version = l;
    }

    public Properties getProperties() {
        return this._properties;
    }

    public final class CBPInfo {
        final QName processName;
        final String guid;
        final File cbp;

        CBPInfo(QName qName, String string, File file) {
            this.processName = qName;
            this.guid = string;
            this.cbp = file;
        }
    }
}

