/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jca.server.rmi;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.jca.server.ConnectionProvider;
import org.apache.ode.jca.server.rmi.RmiPipeServerImpl;
import org.apache.ode.ra.transports.rmi.OdeRemote;
import org.apache.ode.ra.transports.rmi.OdeTransportPipeRemote;

public class RmiTransportServerImpl
implements OdeRemote {
    private static final Log __log = LogFactory.getLog(RmiTransportServerImpl.class);
    private List<RmiPipeServerImpl> _pipes = new ArrayList<RmiPipeServerImpl>();
    private int _port = 1099;
    private Remote _remote;
    private ConnectionProvider _connProvider;
    private String _id;

    public void setId(String string) {
        this._id = string;
    }

    public void setConnectionProvider(ConnectionProvider connectionProvider) {
        this._connProvider = connectionProvider;
    }

    public void setPort(int n) {
        this._port = n;
    }

    public int getPort() {
        return this._port;
    }

    public synchronized void start() throws RemoteException {
        if (this._id == null) {
            throw new IllegalStateException("Must set id!");
        }
        if (this._connProvider == null) {
            throw new IllegalStateException("Must set connection provider.");
        }
        this._remote = UnicastRemoteObject.exportObject((Remote)((Object)this), 0);
        try {
            LocateRegistry.createRegistry(this._port);
            __log.debug((Object)("Created registry on port " + this._port));
        }
        catch (Exception exception) {
            __log.debug((Object)("Could not create registry on port " + this._port + " (perhaps it's already there)"));
        }
        Registry registry = LocateRegistry.getRegistry(this._port);
        registry.rebind(this._id, this._remote);
        __log.debug((Object)("Bound JCA server as \"" + this._id + "\" on registry port " + this._port));
    }

    public synchronized void stop() throws RemoteException {
        UnicastRemoteObject.unexportObject((Remote)((Object)this), false);
    }

    public synchronized OdeTransportPipeRemote newPipe() throws RemoteException {
        OdeTransportPipeRemote odeTransportPipeRemote;
        RmiPipeServerImpl rmiPipeServerImpl = new RmiPipeServerImpl(this, this._connProvider.createConnectionObject(), this._connProvider.getConnectionIntefaces());
        rmiPipeServerImpl.remote = odeTransportPipeRemote = (OdeTransportPipeRemote)UnicastRemoteObject.exportObject((Remote)((Object)rmiPipeServerImpl), 0);
        this._pipes.add(rmiPipeServerImpl);
        return odeTransportPipeRemote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pipeClosed(RmiPipeServerImpl rmiPipeServerImpl) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Closing RMI pipe " + rmiPipeServerImpl));
        }
        try {
            UnicastRemoteObject.unexportObject((Remote)rmiPipeServerImpl.remote, false);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        RmiTransportServerImpl rmiTransportServerImpl = this;
        synchronized (rmiTransportServerImpl) {
            this._pipes.remove(rmiPipeServerImpl);
        }
        this._connProvider.destroyConnectionObject(rmiPipeServerImpl.target);
    }
}

