/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.parser.PreflightParser;
import org.apache.pdfbox.preflight.parser.XmlResultParser;
import org.apache.pdfbox.util.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Validator_A1b {
    public static void main(String[] args) throws IOException, TransformerException, ParserConfigurationException {
        int posFile;
        boolean outputXml;
        if (args.length == 0) {
            Validator_A1b.usage();
            System.exit(1);
        }
        boolean isGroup = "group".equals(args[posFile += (outputXml = "xml".equals(args[posFile = 0])) ? 1 : 0]);
        boolean isBatch = "batch".equals(args[posFile += isGroup ? 1 : 0]);
        posFile += isBatch ? 1 : 0;
        if (isGroup || isBatch) {
            List<File> ftp = Validator_A1b.listFiles(args[posFile]);
            int status = 0;
            if (!outputXml) {
                for (File file2 : ftp) {
                    status |= Validator_A1b.runSimple(file2);
                }
                System.exit(status);
            } else {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                XmlResultParser xrp = new XmlResultParser();
                if (isGroup) {
                    Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                    Element root = document.createElement("preflights");
                    document.appendChild(root);
                    root.setAttribute("count", String.format("%d", ftp.size()));
                    for (File file : ftp) {
                        Element result = xrp.validate(document, file);
                        root.appendChild(result);
                    }
                    transformer.transform(new DOMSource(document), new StreamResult(new File(args[posFile] + ".preflight.xml")));
                } else {
                    for (File file : ftp) {
                        Element result = xrp.validate(file);
                        Document document = result.getOwnerDocument();
                        document.appendChild(result);
                        transformer.transform(new DOMSource(document), new StreamResult(new File(file.getAbsolutePath() + ".preflight.xml")));
                    }
                }
            }
        } else if (!outputXml) {
            System.exit(Validator_A1b.runSimple(new File(args[posFile])));
        } else {
            XmlResultParser xrp = new XmlResultParser();
            Element result = xrp.validate(new File(args[posFile]));
            Document document = result.getOwnerDocument();
            document.appendChild(result);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(new DOMSource(document), new StreamResult(System.out));
        }
    }

    private static void usage() {
        String version = Version.getVersion();
        System.out.println("Usage : java org.apache.pdfbox.preflight.Validator_A1b [xml] [<mode>] <file path>");
        System.out.println();
        System.out.println(" * xml : if set, generate xml output instead of text");
        System.out.println(" * <mode> : if set, <file path> must be a file containing the PDF files to parse. <mode> can have 2 values:");
        System.out.println("       batch : generate xml result files for each PDF file in the list");
        System.out.println("       group : generate one xml result file for all the PDF files in the list.");
        System.out.println("Version : " + version);
    }

    private static int runSimple(File file) throws IOException {
        ValidationResult result = PreflightParser.validate(file);
        if (result.isValid()) {
            System.out.println("The file " + file.getName() + " is a valid PDF/A-1b file");
            System.out.println();
            return 0;
        }
        System.out.println("The file " + file.getName() + " is not a valid PDF/A-1b file, error(s) :");
        for (ValidationResult.ValidationError error : result.getErrorsList()) {
            System.out.print(error.getErrorCode() + " : " + error.getDetails());
            if (error.getPageNumber() != null) {
                System.out.println(" on page " + (error.getPageNumber() + 1));
                continue;
            }
            System.out.println();
        }
        System.out.println();
        return -1;
    }

    private static List<File> listFiles(String path) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        File f = new File(path);
        if (f.isFile()) {
            FileReader fr = new FileReader(f);
            try (BufferedReader bufferedReader = new BufferedReader(fr);){
                while (bufferedReader.ready()) {
                    File fn = new File(bufferedReader.readLine());
                    if (!fn.exists()) continue;
                    files.add(fn);
                }
            }
        } else {
            File[] fileList = f.listFiles();
            if (fileList != null) {
                files.addAll(Arrays.asList(fileList));
            }
        }
        return files;
    }
}

