/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.thirdparty.io.grpc;

import java.util.concurrent.Executor;
import org.apache.ratis.thirdparty.com.google.common.base.MoreObjects;
import org.apache.ratis.thirdparty.com.google.common.base.Preconditions;
import org.apache.ratis.thirdparty.io.grpc.Attributes;
import org.apache.ratis.thirdparty.io.grpc.CallCredentials;
import org.apache.ratis.thirdparty.io.grpc.ExperimentalApi;
import org.apache.ratis.thirdparty.io.grpc.MethodDescriptor;
import org.apache.ratis.thirdparty.io.grpc.SecurityLevel;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4901")
public abstract class CallCredentials2
implements CallCredentials {
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1914")
    public abstract void applyRequestMetadata(CallCredentials.RequestInfo var1, Executor var2, CallCredentials.MetadataApplier var3);

    @Override
    public final void applyRequestMetadata(final MethodDescriptor<?, ?> method, final Attributes attrs, Executor appExecutor, CallCredentials.MetadataApplier applier) {
        final String authority = (String)Preconditions.checkNotNull(attrs.get(ATTR_AUTHORITY), "authority");
        final SecurityLevel securityLevel = MoreObjects.firstNonNull(attrs.get(ATTR_SECURITY_LEVEL), SecurityLevel.NONE);
        CallCredentials.RequestInfo requestInfo = new CallCredentials.RequestInfo(){

            @Override
            public MethodDescriptor<?, ?> getMethodDescriptor() {
                return method;
            }

            @Override
            public SecurityLevel getSecurityLevel() {
                return securityLevel;
            }

            @Override
            public String getAuthority() {
                return authority;
            }

            @Override
            public Attributes getTransportAttrs() {
                return attrs;
            }
        };
        this.applyRequestMetadata(requestInfo, appExecutor, applier);
    }
}

