/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.spring.security.interceptor;

import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresGuest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.authz.annotation.RequiresUser;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.spring.security.interceptor.AopAllianceAnnotationsAuthorizingMethodInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.StaticMethodMatcherPointcutAdvisor;
import org.springframework.beans.factory.InitializingBean;

public class AuthorizationAttributeSourceAdvisor
extends StaticMethodMatcherPointcutAdvisor
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationAttributeSourceAdvisor.class);
    protected SecurityManager securityManager = null;

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setSecurityManager(SecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public boolean matches(Method method, Class targetClass) {
        return method.getAnnotation(RequiresPermissions.class) != null || method.getAnnotation(RequiresRoles.class) != null || method.getAnnotation(RequiresUser.class) != null || method.getAnnotation(RequiresGuest.class) != null || method.getAnnotation(RequiresAuthentication.class) != null;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getAdvice() == null) {
            if (log.isTraceEnabled()) {
                log.trace("No authorization advice explicitly configured via the 'advice' property.  Attempting to set default instance of type [" + AopAllianceAnnotationsAuthorizingMethodInterceptor.class.getName() + "]");
            }
            AopAllianceAnnotationsAuthorizingMethodInterceptor interceptor = new AopAllianceAnnotationsAuthorizingMethodInterceptor();
            this.setAdvice((Advice)interceptor);
        }
    }
}

