/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.synapse.samples.jaxrs.foodsample;

import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.wso2.synapse.samples.jaxrs.foodsample.bean.Token;

@Singleton
@Path(value="/foodservice/")
public class FoodService {
    private int unauthorizedReqCount = 0;
    private int tokenReqCount = 0;

    @POST
    @Path(value="/token")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response getAccessToken(@Context HttpHeaders httpHeaders, MultivaluedMap<String, String> tokenRequestParams) {
        ++this.tokenReqCount;
        String basicHeader = httpHeaders.getHeaderString("Authorization");
        if (this.validateBasicAuthHeader(basicHeader)) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)new Token("abcd@1234", "3600", "Bearer")).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Invalid Credentials").build();
    }

    @POST
    @Path(value="/custom-token")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response getAccessTokenWithCustomParams(@Context HttpHeaders httpHeaders, MultivaluedMap<String, String> tokenRequestParams) {
        String basicHeader = httpHeaders.getHeaderString("Authorization");
        if (this.validateBasicAuthHeader(basicHeader) && this.validateCustomHeader(httpHeaders) && this.validateCustomParams(tokenRequestParams)) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)new Token("abcd@1234", "3600", "Bearer")).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Invalid Credentials").build();
    }

    @POST
    @Path(value="/password-token")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response getAccessTokenWithPasswordGrant(@Context HttpHeaders httpHeaders, MultivaluedMap<String, String> tokenRequestParams) {
        String basicHeader = httpHeaders.getHeaderString("Authorization");
        if (this.validateBasicAuthHeader(basicHeader) && this.validateCustomParams(tokenRequestParams) && this.validatePasswordCredentials(tokenRequestParams)) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)new Token("abcd@1234", "3600", "Bearer")).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Invalid Credentials").build();
    }

    @GET
    @Path(value="/food")
    @Produces(value={"application/json"})
    public Response getFoodItem(@Context HttpHeaders httpHeaders) {
        String token;
        String authorizationHeader = httpHeaders.getHeaderString("Authorization");
        if (authorizationHeader != null && (token = authorizationHeader.split(" ")[1]).equals("abcd@1234")) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)this.tokenReqCount).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @GET
    @Path(value="/unauthorized")
    @Produces(value={"application/json"})
    public Response getUnauthorizedItem(@Context HttpHeaders httpHeaders) {
        ++this.unauthorizedReqCount;
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.unauthorizedReqCount).build();
    }

    private boolean validateCredentials(MultivaluedMap<String, String> tokenRequestParams) {
        String refreshToken = (String)tokenRequestParams.getFirst((Object)"refresh_token");
        String clientIdInBody = (String)tokenRequestParams.getFirst((Object)"client_id");
        String clientSecretInBody = (String)tokenRequestParams.getFirst((Object)"client_secret");
        if (refreshToken != null && !refreshToken.equals("wxyz#9876")) {
            return false;
        }
        return clientIdInBody.equals("my_client_id") && clientSecretInBody.equals("my_client_secret");
    }

    private boolean validatePasswordCredentials(MultivaluedMap<String, String> tokenRequestParams) {
        String username = (String)tokenRequestParams.getFirst((Object)"username");
        String password = (String)tokenRequestParams.getFirst((Object)"password");
        String grantType = (String)tokenRequestParams.getFirst((Object)"grant_type");
        return username.equals("tester123") && password.equals("abc@123") && grantType.equals("password");
    }

    private boolean validateBasicAuthHeader(String basicHeader) {
        String credentials = basicHeader.substring(6).trim();
        String decodedCredentials = new String(new Base64().decode(credentials.getBytes()));
        String clientId = decodedCredentials.split(":")[0];
        String clientSecret = decodedCredentials.split(":")[1];
        return clientId.equals("my_client_id") && clientSecret.equals("my_client_secret");
    }

    private boolean validateCustomParams(MultivaluedMap<String, String> tokenRequestParams) {
        String accountId = (String)tokenRequestParams.getFirst((Object)"account_id");
        String userRole = (String)tokenRequestParams.getFirst((Object)"user_role");
        return accountId.equals("1234") && userRole.equals("tester");
    }

    private boolean validateCustomHeader(HttpHeaders httpHeaders) {
        String userTokenHeader = httpHeaders.getHeaderString("user_token");
        String accountTokenHeader = httpHeaders.getHeaderString("account_token");
        return userTokenHeader.equals("abc#123") && accountTokenHeader.equals("zxy@123");
    }
}

