/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.split;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.split.TezGroupedSplit;
import org.apache.hadoop.yarn.util.RackResolver;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezUncheckedException;

public class TezMapredSplitsGrouper {
    private static final Log LOG = LogFactory.getLog(TezMapredSplitsGrouper.class);

    public InputSplit[] getGroupedSplits(Configuration conf, InputSplit[] originalSplits, int desiredNumSplits, String wrappedInputFormatName) throws IOException {
        LOG.info((Object)"Grouping splits in Tez");
        int configNumSplits = conf.getInt("tez.am.grouping.split-count", 0);
        if (configNumSplits > 0) {
            desiredNumSplits = configNumSplits;
            LOG.info((Object)("Desired numSplits overridden by config to: " + desiredNumSplits));
        }
        if (configNumSplits <= 0 && originalSplits != null && originalSplits.length != 0) {
            int newDesiredNumSplits;
            long minLengthPerGroup;
            long totalLength = 0L;
            InputSplit[] arr$ = originalSplits;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                InputSplit split = arr$[i$];
                totalLength += split.getLength();
            }
            int splitCount = desiredNumSplits > 0 ? desiredNumSplits : originalSplits.length;
            long lengthPerGroup = totalLength / (long)splitCount;
            long maxLengthPerGroup = conf.getLong("tez.am.grouping.max-size", TezConfiguration.TEZ_AM_GROUPING_SPLIT_MAX_SIZE_DEFAULT);
            if (maxLengthPerGroup < (minLengthPerGroup = conf.getLong("tez.am.grouping.min-size", TezConfiguration.TEZ_AM_GROUPING_SPLIT_MIN_SIZE_DEFAULT)) || minLengthPerGroup <= 0L) {
                throw new TezUncheckedException("Invalid max/min group lengths. Required min>0, max>=min.  max: " + maxLengthPerGroup + " min: " + minLengthPerGroup);
            }
            if (lengthPerGroup > maxLengthPerGroup) {
                newDesiredNumSplits = (int)(totalLength / maxLengthPerGroup) + 1;
                LOG.info((Object)("Desired splits: " + desiredNumSplits + " too small. " + " Desired splitLength: " + lengthPerGroup + " Max splitLength: " + maxLengthPerGroup + " New desired splits: " + newDesiredNumSplits + " Total length: " + totalLength + " Original splits: " + originalSplits.length));
                desiredNumSplits = newDesiredNumSplits;
            } else if (lengthPerGroup < minLengthPerGroup) {
                newDesiredNumSplits = (int)(totalLength / minLengthPerGroup) + 1;
                LOG.info((Object)("Desired splits: " + desiredNumSplits + " too large. " + " Desired splitLength: " + lengthPerGroup + " Min splitLength: " + minLengthPerGroup + " New desired splits: " + newDesiredNumSplits + " Total length: " + totalLength + " Original splits: " + originalSplits.length));
                desiredNumSplits = newDesiredNumSplits;
            }
        }
        if (originalSplits == null) {
            LOG.info((Object)"Null original splits");
            return null;
        }
        if (desiredNumSplits == 0 || originalSplits.length == 0 || desiredNumSplits >= originalSplits.length) {
            LOG.info((Object)("Using original number of splits: " + originalSplits.length + " desired splits: " + desiredNumSplits));
            InputSplit[] groupedSplits = new TezGroupedSplit[originalSplits.length];
            int i = 0;
            for (InputSplit split : originalSplits) {
                TezGroupedSplit newSplit = new TezGroupedSplit(1, wrappedInputFormatName, split.getLocations());
                newSplit.addSplit(split);
                groupedSplits[i++] = newSplit;
            }
            return groupedSplits;
        }
        String emptyLocation = "EmptyLocation";
        String[] emptyLocations = new String[]{emptyLocation};
        ArrayList<TezGroupedSplit> groupedSplitsList = new ArrayList<TezGroupedSplit>(desiredNumSplits);
        long totalLength = 0L;
        HashMap<String, LocationHolder> distinctLocations = new HashMap<String, LocationHolder>();
        for (InputSplit split : originalSplits) {
            totalLength += split.getLength();
            String[] locations = split.getLocations();
            if (locations == null || locations.length == 0) {
                locations = emptyLocations;
            }
            for (String location : locations) {
                if (location == null) {
                    location = emptyLocation;
                }
                distinctLocations.put(location, null);
            }
        }
        long lengthPerGroup = totalLength / (long)desiredNumSplits;
        int numNodeLocations = distinctLocations.size();
        int numSplitsPerLocation = originalSplits.length / numNodeLocations;
        int numSplitsInGroup = originalSplits.length / desiredNumSplits;
        for (String location : distinctLocations.keySet()) {
            distinctLocations.put(location, new LocationHolder(numSplitsPerLocation + 1));
        }
        HashSet<String> locSet = new HashSet<String>();
        for (InputSplit split : originalSplits) {
            locSet.clear();
            SplitHolder splitHolder = new SplitHolder(split);
            String[] locations = split.getLocations();
            if (locations == null || locations.length == 0) {
                locations = emptyLocations;
            }
            for (String location : locations) {
                if (location == null) {
                    location = emptyLocation;
                }
                locSet.add(location);
            }
            for (String location : locSet) {
                LocationHolder holder = (LocationHolder)distinctLocations.get(location);
                holder.splits.add(splitHolder);
            }
        }
        boolean groupByLength = conf.getBoolean("tez.am.grouping.by-length", true);
        boolean groupByCount = conf.getBoolean("tez.am.grouping.by-count", false);
        if (!groupByLength && !groupByCount) {
            throw new TezUncheckedException("None of the grouping parameters are true: tez.am.grouping.by-length, tez.am.grouping.by-count");
        }
        LOG.info((Object)("Desired numSplits: " + desiredNumSplits + " lengthPerGroup: " + lengthPerGroup + " numLocations: " + numNodeLocations + " numSplitsPerLocation: " + numSplitsPerLocation + " numSplitsInGroup: " + numSplitsInGroup + " totalLength: " + totalLength + " numOriginalSplits: " + originalSplits.length + " . Grouping by length: " + groupByLength + " count: " + groupByCount));
        int splitsProcessed = 0;
        ArrayList<SplitHolder> group = new ArrayList<SplitHolder>(numSplitsInGroup + 1);
        HashSet<String> groupLocationSet = new HashSet<String>(10);
        boolean allowSmallGroups = false;
        boolean doingRackLocal = false;
        int iterations = 0;
        while (splitsProcessed < originalSplits.length) {
            ++iterations;
            int numFullGroupsCreated = 0;
            for (Map.Entry entry : distinctLocations.entrySet()) {
                group.clear();
                groupLocationSet.clear();
                String location = (String)entry.getKey();
                LocationHolder holder = (LocationHolder)entry.getValue();
                SplitHolder splitHolder = holder.getUnprocessedHeadSplit();
                if (splitHolder == null) continue;
                int oldHeadIndex = holder.headIndex;
                long groupLength = 0L;
                int groupNumSplits = 0;
                do {
                    group.add(splitHolder);
                    holder.incrementHeadIndex();
                } while ((splitHolder = holder.getUnprocessedHeadSplit()) != null && (!groupByLength || (groupLength += splitHolder.split.getLength()) + splitHolder.split.getLength() <= lengthPerGroup) && (!groupByCount || ++groupNumSplits + 1 <= numSplitsInGroup));
                if (!(!holder.isEmpty() || allowSmallGroups || groupByLength && groupLength >= lengthPerGroup / 2L || groupByCount && groupNumSplits >= numSplitsInGroup / 2)) {
                    holder.headIndex = oldHeadIndex;
                    continue;
                }
                ++numFullGroupsCreated;
                String[] groupLocation = new String[]{location};
                if (location == emptyLocation) {
                    groupLocation = null;
                } else if (doingRackLocal) {
                    for (SplitHolder splitH : group) {
                        String[] locations = splitH.split.getLocations();
                        if (locations == null) continue;
                        for (String loc : locations) {
                            if (loc == null) continue;
                            groupLocationSet.add(loc);
                        }
                    }
                    groupLocation = groupLocationSet.toArray(groupLocation);
                }
                TezGroupedSplit groupedSplit = new TezGroupedSplit(group.size(), wrappedInputFormatName, groupLocation, doingRackLocal && location != emptyLocation ? location : null);
                for (SplitHolder groupedSplitHolder : group) {
                    groupedSplit.addSplit(groupedSplitHolder.split);
                    Preconditions.checkState((!groupedSplitHolder.isProcessed ? 1 : 0) != 0, (Object)("Duplicates in grouping at location: " + location));
                    groupedSplitHolder.isProcessed = true;
                    ++splitsProcessed;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Grouped " + group.size() + " length: " + groupedSplit.getLength() + " split at: " + location));
                }
                groupedSplitsList.add(groupedSplit);
            }
            if (!doingRackLocal && numFullGroupsCreated < 1) {
                doingRackLocal = true;
                int numRemainingSplits = originalSplits.length - splitsProcessed;
                HashSet<InputSplit> remainingSplits = new HashSet<InputSplit>(numRemainingSplits);
                for (Map.Entry entry : distinctLocations.entrySet()) {
                    LocationHolder locHolder = (LocationHolder)entry.getValue();
                    while (!locHolder.isEmpty()) {
                        SplitHolder splitHolder = locHolder.getUnprocessedHeadSplit();
                        if (splitHolder == null) continue;
                        remainingSplits.add(splitHolder.split);
                        locHolder.incrementHeadIndex();
                    }
                }
                if (remainingSplits.size() != numRemainingSplits) {
                    throw new TezUncheckedException("Expected: " + numRemainingSplits + " got: " + remainingSplits.size());
                }
                RackResolver.init((Configuration)conf);
                HashMap<String, String> locToRackMap = new HashMap<String, String>(distinctLocations.size());
                HashMap<String, LocationHolder> rackLocations = new HashMap<String, LocationHolder>();
                for (String location : distinctLocations.keySet()) {
                    String rack = emptyLocation;
                    if (location != emptyLocation) {
                        rack = RackResolver.resolve((String)location).getNetworkLocation();
                    }
                    locToRackMap.put(location, rack);
                    if (rackLocations.get(rack) != null) continue;
                    rackLocations.put(rack, new LocationHolder(numRemainingSplits));
                }
                HashSet rackSet = new HashSet(rackLocations.size());
                for (InputSplit split : remainingSplits) {
                    rackSet.clear();
                    SplitHolder splitHolder = new SplitHolder(split);
                    String[] locations = split.getLocations();
                    if (locations == null || locations.length == 0) {
                        locations = emptyLocations;
                    }
                    for (String location : locations) {
                        if (location == null) {
                            location = emptyLocation;
                        }
                        rackSet.add(locToRackMap.get(location));
                    }
                    for (String rack : rackSet) {
                        ((LocationHolder)rackLocations.get((Object)rack)).splits.add(splitHolder);
                    }
                }
                distinctLocations.clear();
                distinctLocations = rackLocations;
                float rackSplitReduction = conf.getFloat("tez.am.grouping.rack-split-reduction", 0.75f);
                if (rackSplitReduction > 0.0f) {
                    long newLengthPerGroup = (long)((float)lengthPerGroup * rackSplitReduction);
                    int newNumSplitsInGroup = (int)((float)numSplitsInGroup * rackSplitReduction);
                    if (newLengthPerGroup > 0L) {
                        lengthPerGroup = newLengthPerGroup;
                    }
                    if (newNumSplitsInGroup > 0) {
                        numSplitsInGroup = newNumSplitsInGroup;
                    }
                }
                LOG.info((Object)("Doing rack local after iteration: " + iterations + " splitsProcessed: " + splitsProcessed + " numFullGroupsInRound: " + numFullGroupsCreated + " totalGroups: " + groupedSplitsList.size() + " lengthPerGroup: " + lengthPerGroup + " numSplitsInGroup: " + numSplitsInGroup));
                continue;
            }
            if (!allowSmallGroups && numFullGroupsCreated <= numNodeLocations / 10) {
                allowSmallGroups = true;
                LOG.info((Object)("Allowing small groups after iteration: " + iterations + " splitsProcessed: " + splitsProcessed + " numFullGroupsInRound: " + numFullGroupsCreated + " totalGroups: " + groupedSplitsList.size()));
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Iteration: " + iterations + " splitsProcessed: " + splitsProcessed + " numFullGroupsInRound: " + numFullGroupsCreated + " totalGroups: " + groupedSplitsList.size()));
        }
        InputSplit[] groupedSplits = new InputSplit[groupedSplitsList.size()];
        groupedSplitsList.toArray(groupedSplits);
        LOG.info((Object)("Number of splits desired: " + desiredNumSplits + " created: " + groupedSplitsList.size() + " splitsProcessed: " + splitsProcessed));
        return groupedSplits;
    }

    class LocationHolder {
        List<SplitHolder> splits;
        int headIndex = 0;

        LocationHolder(int capacity) {
            this.splits = new ArrayList<SplitHolder>(capacity);
        }

        boolean isEmpty() {
            return this.headIndex == this.splits.size();
        }

        SplitHolder getUnprocessedHeadSplit() {
            while (!this.isEmpty()) {
                SplitHolder holder = this.splits.get(this.headIndex);
                if (!holder.isProcessed) {
                    return holder;
                }
                this.incrementHeadIndex();
            }
            return null;
        }

        void incrementHeadIndex() {
            ++this.headIndex;
        }
    }

    class SplitHolder {
        InputSplit split;
        boolean isProcessed = false;

        SplitHolder(InputSplit split) {
            this.split = split;
        }
    }
}

