/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.orderedgrouped;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.BoundedByteArrayOutputStream;
import org.apache.hadoop.io.WritableUtils;
import org.apache.tez.runtime.library.common.sort.impl.IFile;
import org.apache.tez.runtime.library.common.sort.impl.IFileOutputStream;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class InMemoryWriter
extends IFile.Writer {
    private static final Log LOG = LogFactory.getLog(InMemoryWriter.class);

    public InMemoryWriter(BoundedByteArrayOutputStream arrayStream) {
        super(null, null);
        this.out = new DataOutputStream(new IFileOutputStream((OutputStream)arrayStream));
    }

    @Override
    public void append(Object key, Object value) throws IOException {
        throw new UnsupportedOperationException("InMemoryWriter.append(K key, V value");
    }

    @Override
    public void close() throws IOException {
        WritableUtils.writeVInt((DataOutput)this.out, (int)-1);
        WritableUtils.writeVInt((DataOutput)this.out, (int)-1);
        this.out.close();
        this.out = null;
    }
}

