/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.ejb.embeddable.EJBContainer;
import javax.ejb.spi.EJBContainerProvider;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.validation.ValidationException;
import org.apache.geronimo.osgi.locator.ProviderLocator;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.Deployer;
import org.apache.openejb.client.EjbObjectInputStream;
import org.apache.openejb.client.RemoteInitialContextFactory;
import org.apache.openejb.config.RemoteServer;
import org.apache.openejb.loader.IO;
import org.apache.tomee.util.QuickServerXmlParser;

public class RemoteTomEEEJBContainer
extends EJBContainer {
    private static RemoteTomEEEJBContainer instance;
    private RemoteServer container;
    private InitialContext context;

    public void close() {
        RemoteTomEEEJBContainer.instance.container.destroy();
        RemoteTomEEEJBContainer.instance.container = null;
    }

    public Context getContext() {
        return this.context;
    }

    private static void deployFile(Deployer deployer, File file) throws IOException, OpenEJBException {
        if ("true".equalsIgnoreCase(System.getProperty("openejb.deployer.binaries.use", "false"))) {
            Properties props = new Properties();
            byte[] slurpBinaries = IO.slurp((File)file).getBytes();
            props.put("openejb.deployer.binaries.value", slurpBinaries);
            props.put("openejb.deployer.binaries.path", file.getName());
            deployer.deploy(file.getAbsolutePath(), props);
        } else {
            deployer.deploy(file.getAbsolutePath());
        }
    }

    protected static class TomEERemoteEJBContainerException
    extends RuntimeException {
        protected TomEERemoteEJBContainerException(String s, Exception e) {
            super(s, e);
        }
    }

    public static class Provider
    implements EJBContainerProvider {
        private static final List<String> CONTAINER_NAMES = Arrays.asList(RemoteTomEEEJBContainer.class.getName(), "tomee-remote", "remote-tomee");

        public EJBContainer createEJBContainer(Map<?, ?> rawProperties) {
            final HashMap properties = rawProperties == null ? new HashMap() : rawProperties;
            Object provider = properties.get("javax.ejb.embeddable.provider");
            int ejbContainerProviders = 1;
            try {
                ejbContainerProviders = ProviderLocator.getServices((String)EJBContainerProvider.class.getName(), EJBContainer.class, (ClassLoader)Thread.currentThread().getContextClassLoader()).size();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (provider == null && ejbContainerProviders > 1 || !RemoteTomEEEJBContainer.class.equals(provider) && !CONTAINER_NAMES.contains(String.valueOf(provider))) {
                return null;
            }
            if (instance != null) {
                return instance;
            }
            Object modules = properties.get("javax.ejb.embeddable.modules");
            System.getProperties().putAll((Map<?, ?>)properties);
            File home = new File(System.getProperty("openejb.home", "doesn't exist"));
            if (!home.exists()) {
                throw new IllegalArgumentException("You need to set openejb.home");
            }
            QuickServerXmlParser parser = QuickServerXmlParser.parse((File)new File(home, "conf/server.xml"));
            final String remoteEjb = System.getProperty("java.naming.provider.url", "http://" + parser.host() + ":" + parser.http() + "/tomee/ejb");
            System.setProperty("server.shutdown.port", parser.stop());
            String blacklist = System.getProperty("tomee.serialization.class.blacklist");
            if (blacklist == null) {
                System.setProperty("tomee.serialization.class.blacklist", "-");
                EjbObjectInputStream.reloadResolverConfig();
            }
            try {
                instance = new RemoteTomEEEJBContainer();
                instance.container = new RemoteServer();
                instance.container.setDebug("true".equalsIgnoreCase(String.valueOf(properties.get("debug"))));
                instance.container.setPortStartup(Integer.parseInt(parser.http()));
                try {
                    instance.container.start(Arrays.asList("-Dtomee.serialization.class.blacklist=" + System.getProperty("tomee.serialization.class.blacklist"), "-Dopenejb.system.apps=true", "-Dtomee.remote.support=true"), "start", true);
                }
                catch (Exception e) {
                    instance.container.destroy();
                    throw e;
                }
                instance.context = new InitialContext(new Properties(){
                    {
                        this.setProperty("java.naming.factory.initial", RemoteInitialContextFactory.class.getName());
                        this.setProperty("java.naming.provider.url", String.valueOf(properties.containsKey("java.naming.provider.url") ? properties.get("java.naming.provider.url") : remoteEjb));
                    }
                });
                Deployer deployer = null;
                for (int i = 0; i < (properties.containsKey("retries") ? Integer.parseInt((String)String.class.cast(properties.get("retries"))) : 4); ++i) {
                    try {
                        deployer = (Deployer)Deployer.class.cast(instance.context.lookup("openejb/DeployerBusinessRemote"));
                        if (deployer == null) continue;
                    }
                    catch (NamingException ne) {
                        try {
                            Thread.sleep(250L);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            Thread.interrupted();
                        }
                    }
                    break;
                }
                if (deployer == null) {
                    throw new TomEERemoteEJBContainerException("Can't lookup deployer, eother increse retries or setup it correctly", new IllegalStateException());
                }
                if (modules instanceof File) {
                    File file = (File)File.class.cast(modules);
                    RemoteTomEEEJBContainer.deployFile(deployer, file);
                } else if (modules instanceof String) {
                    String path = (String)String.class.cast(modules);
                    File file = new File(path);
                    RemoteTomEEEJBContainer.deployFile(deployer, file);
                } else if (modules instanceof String[]) {
                    for (String path : (String[])modules) {
                        RemoteTomEEEJBContainer.deployFile(deployer, new File(path));
                    }
                } else if (modules instanceof File[]) {
                    for (File file : (File[])modules) {
                        RemoteTomEEEJBContainer.deployFile(deployer, file);
                    }
                }
                RemoteTomEEEJBContainer remoteTomEEEJBContainer = instance;
                return remoteTomEEEJBContainer;
            }
            catch (MalformedURLException | OpenEJBException e) {
                throw new EJBException((Exception)e);
            }
            catch (ValidationException ve) {
                throw ve;
            }
            catch (Exception e) {
                if (e instanceof EJBException) {
                    throw (EJBException)e;
                }
                throw new TomEERemoteEJBContainerException("initialization exception", e);
            }
            finally {
                if (blacklist == null) {
                    System.clearProperty("tomee.serialization.class.blacklist");
                    EjbObjectInputStream.reloadResolverConfig();
                }
            }
        }
    }
}

