/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.loader;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Service;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;
import org.apache.tomee.loader.TomcatEmbedder;
import org.apache.tomee.loader.TomcatHelper;

public class OpenEJBListener
implements LifecycleListener {
    private static final Logger LOGGER = Logger.getLogger(OpenEJBListener.class.getName());
    private static boolean listenerInstalled;
    private static boolean logWebappNotFound;

    public static boolean isListenerInstalled() {
        return listenerInstalled;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if (listenerInstalled || !"after_init".equals(event.getType())) {
            return;
        }
        try {
            StandardServer server;
            File webappDir = OpenEJBListener.findOpenEjbWar();
            if (webappDir == null && event.getSource() instanceof StandardServer && (webappDir = OpenEJBListener.tryToFindAndExtractWar(server = (StandardServer)event.getSource())) != null) {
                File exploded = OpenEJBListener.extractDirectory(webappDir);
                if (exploded != null) {
                    OpenEJBListener.extract(webappDir, exploded);
                }
                webappDir = exploded;
                TomcatHelper.setServer(server);
            }
            if (webappDir != null) {
                LOGGER.info("found the tomee webapp on " + webappDir.getPath());
                Properties properties = new Properties();
                properties.setProperty("tomee.war", webappDir.getAbsolutePath());
                properties.setProperty("openejb.embedder.source", OpenEJBListener.class.getSimpleName());
                TomcatEmbedder.embed(properties, StandardServer.class.getClassLoader());
                listenerInstalled = true;
            } else if (logWebappNotFound) {
                LOGGER.info("tomee webapp not found from the listener, will try from the webapp if exists");
                logWebappNotFound = false;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "TomEE Listener can't start OpenEJB", e);
        }
    }

    private static File extractDirectory(File webappDir) {
        File exploded = new File(webappDir.getAbsolutePath().replace(".war", ""));
        int i = 0;
        while (exploded.exists()) {
            exploded = new File(exploded.getAbsolutePath() + "_" + i++);
        }
        return exploded;
    }

    private static File tryToFindAndExtractWar(StandardServer source) {
        if (System.getProperties().containsKey("openejb.war")) {
            return new File(System.getProperty("openejb.war"));
        }
        for (Service service : source.findServices()) {
            Engine container = service.getContainer();
            if (!(container instanceof StandardEngine)) continue;
            StandardEngine engine = (StandardEngine)container;
            for (Container child : engine.findChildren()) {
                if (!(child instanceof StandardHost)) continue;
                StandardHost host = (StandardHost)child;
                File base = OpenEJBListener.hostDir(System.getProperty("catalina.base"), host.getAppBase());
                File[] files = base.listFiles();
                if (files == null) continue;
                for (File file : files) {
                    if (!OpenEJBListener.isTomEEWar(file)) continue;
                    return file;
                }
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isTomEEWar(File file) {
        String name = file.getName();
        try (JarFile jarFile = new JarFile(file);){
            boolean bl = jarFile.getEntry("lib") != null && (name.startsWith("tomee") || name.startsWith("openejb") && name.endsWith(".war"));
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static File findOpenEjbWar() {
        String catalinaBase = System.getProperty("catalina.base");
        File serverWebapps = new File(catalinaBase, "server/webapps");
        File openEjbWar = OpenEJBListener.findOpenEjbWar(serverWebapps);
        if (openEjbWar != null) {
            return openEjbWar;
        }
        try {
            for (Service service : TomcatHelper.getServer().findServices()) {
                Engine container = service.getContainer();
                if (!(container instanceof StandardEngine)) continue;
                StandardEngine engine = (StandardEngine)container;
                for (Container child : engine.findChildren()) {
                    if (!(child instanceof StandardHost)) continue;
                    StandardHost host = (StandardHost)child;
                    File hostDir = OpenEJBListener.hostDir(catalinaBase, host.getAppBase());
                    openEjbWar = OpenEJBListener.findOpenEjbWar(hostDir);
                    if (openEjbWar != null) {
                        return openEjbWar;
                    }
                    return OpenEJBListener.findOpenEjbWar(host);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "OpenEJBListener.findOpenEjbWar: " + e.getMessage());
        }
        return null;
    }

    private static File hostDir(String catalinaBase, String appBase) {
        File hostDir = new File(appBase);
        if (!hostDir.isAbsolute()) {
            hostDir = new File(catalinaBase, appBase);
        }
        return hostDir;
    }

    private static File findOpenEjbWar(StandardHost standardHost) {
        for (Container container : standardHost.findChildren()) {
            File openEjbWar;
            if (!(container instanceof StandardContext)) continue;
            StandardContext standardContext = (StandardContext)container;
            File contextDocBase = new File(standardContext.getDocBase());
            if (!contextDocBase.isDirectory() && standardContext.getOriginalDocBase() != null) {
                contextDocBase = new File(standardContext.getOriginalDocBase());
            }
            if (!contextDocBase.isDirectory() || (openEjbWar = OpenEJBListener.findOpenEjbWarInContext(contextDocBase)) == null) continue;
            return openEjbWar;
        }
        return null;
    }

    private static File findOpenEjbWar(File hostDir) {
        if (!hostDir.isDirectory()) {
            return null;
        }
        File[] files = hostDir.listFiles();
        if (null != files) {
            for (File contextDir : files) {
                File foundContextDir = OpenEJBListener.findOpenEjbWarInContext(contextDir);
                if (foundContextDir == null) continue;
                return foundContextDir;
            }
        }
        return null;
    }

    private static File findOpenEjbWarInContext(File contextDir) {
        if (!new File(contextDir, "WEB-INF").exists()) {
            return null;
        }
        File webInfLib = new File(contextDir, "lib");
        if (!webInfLib.isDirectory()) {
            return null;
        }
        File[] files = webInfLib.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().startsWith("tomee-catalina-") || !file.getName().endsWith(".jar")) continue;
                return contextDir;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extract(File src, File dest) throws IOException {
        if (dest.exists()) {
            return;
        }
        LOGGER.info("Extracting openejb webapp from " + src.getAbsolutePath() + " to " + dest.getAbsolutePath());
        if (!dest.mkdirs()) {
            throw new IOException("Failed to create: " + dest);
        }
        JarFile jarFile = null;
        InputStream input = null;
        try {
            jarFile = new JarFile(src);
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                File parent;
                JarEntry jarEntry = jarEntries.nextElement();
                String name = jarEntry.getName();
                int last = name.lastIndexOf(47);
                if (last >= 0 && !(parent = new File(dest, name.substring(0, last))).mkdirs()) {
                    throw new IOException("Failed to create: " + parent);
                }
                if (name.endsWith("/")) continue;
                input = jarFile.getInputStream(jarEntry);
                File file = new File(dest, name);
                FilterOutputStream output = null;
                try {
                    int n;
                    output = new BufferedOutputStream(new FileOutputStream(file));
                    byte[] buffer = new byte[2048];
                    while ((n = input.read(buffer)) > 0) {
                        ((BufferedOutputStream)output).write(buffer, 0, n);
                    }
                }
                finally {
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (IOException e) {}
                    }
                }
                long lastModified = jarEntry.getTime();
                if (lastModified != -1L && lastModified != 0L && file != null && !file.setLastModified(lastModified)) {
                    LOGGER.log(Level.WARNING, "Failed to set last modified time on: " + file.getAbsolutePath());
                }
                input.close();
                input = null;
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Throwable t) {}
            }
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Throwable t) {}
            }
        }
        LOGGER.info("Extracted openejb webapp");
    }

    static {
        logWebappNotFound = true;
    }
}

