/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.docanalyzer;

import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import org.apache.uima.tools.docanalyzer.FileSelector;

public class PrefsMediator {
    private FileSelector inputFileSelector;
    private FileSelector outputFileSelector;
    private FileSelector xmlFileSelector;
    private JButton runButton;
    private JButton interButton;
    private JButton viewButton;
    private Preferences prefs = Preferences.userRoot().node("org/apache/uima/tools/DocumentAnalyzer1");
    private String taeDir;
    private String outputDir;
    private String inputDir;
    private String defaultInputDir = "examples/data";
    private String defaultOutputDir = "examples/data/processed";
    private String language;
    private String encoding;
    private String viewType;
    private String xmlTag;
    private static final String VIEWTYPE = "viewType";
    private static final String ENCODING = "encoding";
    private static final String LANGUAGE = "language";
    private static final String TAEDESCRIPTOR = "taeDescriptor";
    private static final String OUTDIR = "outDir";
    private static final String INDIR = "inDir";
    private static final String XMLTAG = "xmlTag";

    public PrefsMediator() {
        this.restorePreferences();
    }

    public void restorePreferences() {
        this.inputDir = this.prefs.get(INDIR, this.defaultInputDir);
        this.outputDir = this.prefs.get(OUTDIR, this.defaultOutputDir);
        this.taeDir = this.prefs.get(TAEDESCRIPTOR, "");
        this.language = this.prefs.get(LANGUAGE, "en");
        this.encoding = this.prefs.get(ENCODING, "UTF-8");
        this.viewType = this.prefs.get(VIEWTYPE, "Java Viewer");
        this.xmlTag = this.prefs.get(XMLTAG, "");
    }

    public void savePreferences() {
        String t1 = this.inputFileSelector.getSelected();
        this.setInputDir(t1);
        String t2 = this.outputFileSelector.getSelected();
        this.setOutputDir(t2);
        String t3 = this.xmlFileSelector.getSelected();
        this.setTAEfile(t3);
    }

    public String getInputDir() {
        return this.inputDir;
    }

    public void setInputDir(String inputDir) {
        this.inputDir = inputDir;
        this.prefs.put(INDIR, inputDir);
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
        this.prefs.put(OUTDIR, outputDir);
    }

    public void setOutputDirForInteractiveMode(String outputDir, String outputDirToSave) {
        this.outputDir = outputDir;
        this.prefs.put(OUTDIR, outputDirToSave);
    }

    public String getTAEfile() {
        return this.taeDir;
    }

    public String getTAEPath() {
        int index = this.indexOfLastFileSeparator(this.taeDir);
        if (index > 0) {
            String path = this.taeDir.substring(0, index);
            return path;
        }
        return "";
    }

    public String getTAEFileNameRoot() {
        int index = this.indexOfLastFileSeparator(this.taeDir);
        String file = index > 0 ? this.taeDir.substring(index) : this.taeDir;
        int ix = file.indexOf(".xml");
        if (ix >= 0) {
            file = file.substring(0, ix);
        }
        return file;
    }

    private int indexOfLastFileSeparator(String path) {
        int index = path.lastIndexOf(File.separator);
        if (!File.separator.equals("/")) {
            index = Math.max(index, path.lastIndexOf(47));
        }
        return index;
    }

    public void setTAEfile(String edir) {
        this.taeDir = edir;
        this.prefs.put(TAEDESCRIPTOR, this.taeDir);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
        this.prefs.put(ENCODING, encoding);
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
        this.prefs.put(LANGUAGE, language);
    }

    public String getViewType() {
        return this.viewType;
    }

    public void setViewType(String viewType) {
        this.viewType = viewType;
        this.prefs.put(VIEWTYPE, viewType);
    }

    public String getXmlTag() {
        return this.xmlTag;
    }

    public void setXmlTag(String xmlTag) {
        this.xmlTag = xmlTag;
        this.prefs.put(XMLTAG, xmlTag);
    }

    public File getStylemapFile() {
        String s = this.getTAEPath() + this.getTAEFileNameRoot() + "StyleMap.xml";
        return new File(s);
    }

    public void setDocButtons(JButton run, JButton inter, JButton view) {
        this.runButton = run;
        this.interButton = inter;
        this.viewButton = view;
        this.fieldFocusLost();
    }

    public void setFileSelectors(FileSelector input, FileSelector output, FileSelector xml) {
        this.inputFileSelector = input;
        this.outputFileSelector = output;
        this.xmlFileSelector = xml;
    }

    public void fieldFocusLost() {
        boolean enableRun = false;
        boolean enableInter = false;
        boolean enableView = false;
        if (this.inputFileSelector != null) {
            String t1 = this.inputFileSelector.getSelected();
            this.setInputDir(t1);
            String t2 = this.outputFileSelector.getSelected();
            this.setOutputDir(t2);
            String t3 = this.xmlFileSelector.getSelected();
            this.setTAEfile(t3);
            if (t2.length() > 0) {
                enableView = true;
            }
            if (t2.length() > 0 && t3.length() > 0) {
                enableInter = true;
                if (t1.length() > 0) {
                    enableRun = true;
                }
            }
        }
        this.runButton.setEnabled(enableRun);
        this.interButton.setEnabled(enableInter);
        this.viewButton.setEnabled(enableView);
    }
}

