/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.collections;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiniMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final K[] keys;
    private final V[] values;
    private int size;
    private int lastSearchIndex;

    public MiniMap(int maxEntries) {
        this.keys = new Object[maxEntries];
        this.values = new Object[maxEntries];
    }

    public MiniMap(Map<? extends K, ? extends V> map, int maxEntries) {
        this(maxEntries);
        this.putAll(map);
    }

    public boolean isFull() {
        return this.size == this.keys.length;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.findKey(0, key) != -1;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.findValue(0, value) != -1;
    }

    @Override
    public V get(Object key) {
        int index = this.findKey(key);
        if (index != -1) {
            return this.values[index];
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        int index = this.findKey(key);
        if (index != -1) {
            V oldValue = this.values[index];
            this.values[index] = value;
            return oldValue;
        }
        if (this.size < this.keys.length) {
            int nullIndex = this.nextNullKey(this.lastSearchIndex);
            this.lastSearchIndex = this.nextIndex(nullIndex);
            this.keys[nullIndex] = key;
            this.values[nullIndex] = value;
            ++this.size;
            return null;
        }
        throw new IllegalStateException("Map full");
    }

    @Override
    public V remove(Object key) {
        int index = this.findKey(key);
        if (index != -1) {
            V oldValue = this.values[index];
            this.keys[index] = null;
            this.values[index] = null;
            --this.size;
            return oldValue;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.keys.length; ++i) {
            this.keys[i] = null;
            this.values[i] = null;
        }
        this.size = 0;
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new Iterator<K>(){
                    int i = -1;

                    @Override
                    public boolean hasNext() {
                        return this.i < MiniMap.this.size - 1;
                    }

                    @Override
                    public K next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        this.i = MiniMap.this.nextKey(MiniMap.this.nextIndex(this.i));
                        return MiniMap.this.keys[this.i];
                    }

                    @Override
                    public void remove() {
                        ((MiniMap)MiniMap.this).keys[this.i] = null;
                        ((MiniMap)MiniMap.this).values[this.i] = null;
                        MiniMap.this.size--;
                    }
                };
            }

            @Override
            public int size() {
                return MiniMap.this.size;
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new AbstractList<V>(){

            @Override
            public V get(int index) {
                if (index > MiniMap.this.size - 1) {
                    throw new IndexOutOfBoundsException();
                }
                int keyIndex = MiniMap.this.nextKey(0);
                for (int i = 0; i < index; ++i) {
                    keyIndex = MiniMap.this.nextKey(keyIndex + 1);
                }
                return MiniMap.this.values[keyIndex];
            }

            @Override
            public int size() {
                return MiniMap.this.size;
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    int keyIndex = -1;
                    int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < MiniMap.this.size;
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        this.keyIndex = MiniMap.this.nextKey(MiniMap.this.nextIndex(this.keyIndex));
                        ++this.index;
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return MiniMap.this.keys[keyIndex];
                            }

                            @Override
                            public V getValue() {
                                return MiniMap.this.values[keyIndex];
                            }

                            @Override
                            public V setValue(V value) {
                                Object oldValue = MiniMap.this.values[keyIndex];
                                ((MiniMap)MiniMap.this).values[keyIndex] = value;
                                return oldValue;
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        ((MiniMap)MiniMap.this).keys[this.keyIndex] = null;
                        ((MiniMap)MiniMap.this).values[this.keyIndex] = null;
                    }
                };
            }

            @Override
            public int size() {
                return MiniMap.this.size;
            }
        };
    }

    private int nextIndex(int index) {
        return (index + 1) % this.keys.length;
    }

    private int nextKey(int start) {
        int i = start;
        do {
            if (this.keys[i] == null) continue;
            return i;
        } while ((i = this.nextIndex(i)) != start);
        return -1;
    }

    private int nextNullKey(int start) {
        int i = start;
        do {
            if (this.keys[i] != null) continue;
            return i;
        } while ((i = this.nextIndex(i)) != start);
        return -1;
    }

    private int findKey(Object key) {
        int index;
        if (this.size > 0 && (index = this.findKey(this.lastSearchIndex, key)) != -1) {
            this.lastSearchIndex = this.nextIndex(index);
            return index;
        }
        return -1;
    }

    private int findKey(int start, Object key) {
        int i = start;
        do {
            if (!key.equals(this.keys[i])) continue;
            return i;
        } while ((i = this.nextIndex(i)) != start);
        return -1;
    }

    private int findValue(int start, Object value) {
        int i = start;
        do {
            if (!value.equals(this.values[i])) continue;
            return i;
        } while ((i = this.nextIndex(i)) != start);
        return -1;
    }
}

