/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.license;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.license.CssLicenseHeaderHandler;
import org.apache.wicket.util.license.HtmlLicenseHeaderHandler;
import org.apache.wicket.util.license.ILicenseHeaderHandler;
import org.apache.wicket.util.license.JavaLicenseHeaderHandler;
import org.apache.wicket.util.license.JavaScriptLicenseHeaderHandler;
import org.apache.wicket.util.license.PropertiesLicenseHeaderHandler;
import org.apache.wicket.util.license.VelocityLicenseHeaderHandler;
import org.apache.wicket.util.license.XmlLicenseHeaderHandler;
import org.apache.wicket.util.license.XmlPrologHeaderHandler;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ApacheLicenseHeaderTestCase
extends TestCase {
    private static final Logger log = LoggerFactory.getLogger(ApacheLicenseHeaderTestCase.class);
    private static final String LINE_ENDING = System.getProperty("line.separator");
    private ILicenseHeaderHandler[] licenseHeaderHandlers;
    private File baseDirectory = new File("").getAbsoluteFile();
    protected List<String> javaIgnore = Generics.newArrayList();
    protected List<String> htmlIgnore = Generics.newArrayList();
    protected List<String> xmlPrologIgnore = Generics.newArrayList();
    protected List<String> propertiesIgnore = Generics.newArrayList();
    protected List<String> xmlIgnore = Generics.newArrayList();
    protected List<String> cssIgnore = Generics.newArrayList();
    protected List<String> velocityIgnore = Generics.newArrayList();
    protected List<String> javaScriptIgnore = Generics.newArrayList();
    protected boolean addHeaders = false;

    public ApacheLicenseHeaderTestCase() {
        super("Test of the legal aspects of the Wicket source code is correct.");
        this.xmlIgnore.add(".settings");
        this.xmlIgnore.add("EclipseCodeFormat.xml");
        this.htmlIgnore.add("src/test/java");
        this.propertiesIgnore.add("src/test/java");
        this.xmlPrologIgnore.add("src/test/java");
        this.xmlPrologIgnore.add("package.html");
    }

    public final void setUp() {
        String property = System.getProperty("basedir");
        if (!Strings.isEmpty(property)) {
            this.baseDirectory = new File(property).getAbsoluteFile();
        }
    }

    public void testLicenseHeaders() {
        this.licenseHeaderHandlers = new ILicenseHeaderHandler[]{new JavaLicenseHeaderHandler(this.javaIgnore), new JavaScriptLicenseHeaderHandler(this.javaScriptIgnore), new XmlLicenseHeaderHandler(this.xmlIgnore), new PropertiesLicenseHeaderHandler(this.propertiesIgnore), new HtmlLicenseHeaderHandler(this.htmlIgnore), new VelocityLicenseHeaderHandler(this.velocityIgnore), new XmlPrologHeaderHandler(this.xmlPrologIgnore), new CssLicenseHeaderHandler(this.cssIgnore)};
        final HashMap<ILicenseHeaderHandler, List<File>> badFiles = new HashMap<ILicenseHeaderHandler, List<File>>();
        for (final ILicenseHeaderHandler licenseHeaderHandler : this.licenseHeaderHandlers) {
            this.visitFiles(licenseHeaderHandler.getSuffixes(), licenseHeaderHandler.getIgnoreFiles(), new FileVisitor(){

                public void visitFile(File file) {
                    if (!(licenseHeaderHandler.checkLicenseHeader(file) || ApacheLicenseHeaderTestCase.this.addHeaders && licenseHeaderHandler.addLicenseHeader(file))) {
                        ArrayList<File> files = (ArrayList<File>)badFiles.get(licenseHeaderHandler);
                        if (files == null) {
                            files = new ArrayList<File>();
                            badFiles.put(licenseHeaderHandler, files);
                        }
                        files.add(file);
                    }
                }
            });
        }
        this.failIncorrectLicenceHeaders(badFiles);
    }

    private void failIncorrectLicenceHeaders(Map<ILicenseHeaderHandler, List<File>> files) {
        if (files.size() > 0) {
            StringBuilder failString = new StringBuilder();
            for (Map.Entry<ILicenseHeaderHandler, List<File>> entry : files.entrySet()) {
                ILicenseHeaderHandler licenseHeaderHandler = entry.getKey();
                List<File> fileList = entry.getValue();
                failString.append("\n");
                failString.append(licenseHeaderHandler.getClass().getName());
                failString.append(" failed. The following files(");
                failString.append(fileList.size());
                failString.append(") didn't have correct license header:\n");
                for (File file : fileList) {
                    String filename = file.getAbsolutePath();
                    String licenseType = licenseHeaderHandler.getLicenseType(file);
                    if (licenseType == null) {
                        failString.append("NONE");
                    } else {
                        failString.append(licenseType);
                    }
                    failString.append(" ").append(filename).append(LINE_ENDING);
                }
            }
            System.out.println(failString);
            ApacheLicenseHeaderTestCase.fail((String)failString.toString());
        }
    }

    private void visitFiles(List<String> suffixes, List<String> ignoreFiles, FileVisitor fileVisitor) {
        this.visitDirectory(suffixes, ignoreFiles, this.baseDirectory, fileVisitor);
    }

    private void visitDirectory(List<String> suffixes, List<String> ignoreFiles, File directory, FileVisitor fileVisitor) {
        File[] files = directory.listFiles(new SuffixAndIgnoreFileFilter(suffixes, ignoreFiles));
        if (files != null) {
            for (File file : files) {
                fileVisitor.visitFile(file);
            }
        }
        if ((files = directory.listFiles(new DirectoryFileFilter())) != null) {
            for (File childDirectory : files) {
                this.visitDirectory(suffixes, ignoreFiles, childDirectory, fileVisitor);
            }
        }
    }

    private class DirectoryFileFilter
    implements FileFilter {
        private final String[] ignoreDirectory = new String[]{".svn"};

        private DirectoryFileFilter() {
        }

        public boolean accept(File pathname) {
            boolean accept = false;
            if (pathname.isDirectory()) {
                String relativePathname = pathname.getAbsolutePath();
                if (!(relativePathname = ((Object)Strings.replaceAll(relativePathname, ApacheLicenseHeaderTestCase.this.baseDirectory.getAbsolutePath() + System.getProperty("file.separator"), "")).toString()).equals("target")) {
                    boolean found = false;
                    for (String ignore : this.ignoreDirectory) {
                        if (!pathname.getName().equals(ignore)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        accept = true;
                    }
                }
            }
            return accept;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SuffixAndIgnoreFileFilter
    implements FileFilter {
        private final List<String> suffixes;
        private final List<String> ignoreFiles;

        private SuffixAndIgnoreFileFilter(List<String> suffixes) {
            this(suffixes, null);
        }

        private SuffixAndIgnoreFileFilter(List<String> suffixes, List<String> ignoreFiles) {
            this.suffixes = suffixes;
            this.ignoreFiles = ignoreFiles;
        }

        @Override
        public boolean accept(File pathname) {
            boolean accept = false;
            if (pathname.isFile()) {
                if (!this.ignoreFile(pathname)) {
                    for (String suffix : this.suffixes) {
                        if (pathname.getName().endsWith("." + suffix)) {
                            accept = true;
                            break;
                        }
                        log.info("File ignored: '{}'", (Object)pathname.toString());
                    }
                } else {
                    log.info("File ignored: '{}'", (Object)pathname.toString());
                }
            }
            return accept;
        }

        private boolean ignoreFile(File pathname) {
            boolean ignore = false;
            if (this.ignoreFiles != null) {
                String relativePathname = pathname.getAbsolutePath();
                relativePathname = ((Object)Strings.replaceAll(relativePathname, ApacheLicenseHeaderTestCase.this.baseDirectory.getAbsolutePath() + System.getProperty("file.separator"), "")).toString();
                for (String ignorePath : this.ignoreFiles) {
                    ignorePath = ((Object)Strings.replaceAll(ignorePath, "/", System.getProperty("file.separator"))).toString();
                    File ignoreFile = new File(ApacheLicenseHeaderTestCase.this.baseDirectory, ignorePath);
                    if (ignoreFile.isDirectory()) {
                        if (!pathname.getAbsolutePath().startsWith(ignoreFile.getAbsolutePath())) continue;
                        ignore = true;
                        break;
                    }
                    if (ignoreFile.isFile()) {
                        if (!relativePathname.equals(ignorePath)) continue;
                        ignore = true;
                        break;
                    }
                    if (!pathname.getName().equals(ignorePath)) continue;
                    ignore = true;
                    break;
                }
            }
            return ignore;
        }
    }

    static interface FileVisitor {
        public void visitFile(File var1);
    }
}

