/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Properties;
import org.apache.wicket.util.io.IOUtils;

public final class Streams {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyAndClose(InputStream in, OutputStream out) throws IOException {
        try {
            int n = Streams.copy(in, out);
            return n;
        }
        finally {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
        }
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        return Streams.copy(in, out, 4096);
    }

    public static int copy(InputStream in, OutputStream out, int bufSize) throws IOException {
        int byteCount;
        if (bufSize <= 0) {
            throw new IllegalArgumentException("The parameter 'bufSize' must not be <= 0");
        }
        byte[] buffer = new byte[bufSize];
        int bytesCopied = 0;
        while ((byteCount = in.read(buffer, 0, buffer.length)) > 0) {
            out.write(buffer, 0, byteCount);
            bytesCopied += byteCount;
        }
        return bytesCopied;
    }

    public static void loadFromXml(Properties properties, InputStream inputStream) throws IOException {
        if (properties == null) {
            throw new IllegalArgumentException("properties must not be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream must not be null");
        }
        properties.loadFromXML(inputStream);
    }

    public static String readString(InputStream in) throws IOException {
        return Streams.readString(new BufferedReader(new InputStreamReader(in)));
    }

    public static String readString(InputStream in, CharSequence encoding) throws IOException {
        return Streams.readString(new BufferedReader(new InputStreamReader(in, ((Object)encoding).toString())));
    }

    public static String readString(Reader in) throws IOException {
        int value;
        StringBuilder buffer = new StringBuilder(2048);
        while ((value = in.read()) != -1) {
            buffer.append((char)value);
        }
        return buffer.toString();
    }

    private Streams() {
    }
}

