/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.kernel;

import java.util.Set;
import org.apache.xbean.kernel.ForcedStopException;
import org.apache.xbean.kernel.ServiceName;
import org.apache.xbean.kernel.StopStrategy;
import org.apache.xbean.kernel.UnsatisfiedConditionsException;

public final class StopStrategies {
    public static final StopStrategy SYNCHRONOUS = new Synchronous();
    public static final StopStrategy ASYNCHRONOUS = new Asynchronous();
    public static final StopStrategy BLOCK = new Block();
    public static final StopStrategy FORCE = new Force();

    private StopStrategies() {
    }

    private static class Force
    implements StopStrategy {
        private Force() {
        }

        public boolean waitForUnsatisfiedConditions(ServiceName serviceName, Set conditions) throws ForcedStopException {
            throw new ForcedStopException(serviceName, conditions);
        }
    }

    private static class Block
    implements StopStrategy {
        private Block() {
        }

        public boolean waitForUnsatisfiedConditions(ServiceName serviceName, Set conditions) {
            return true;
        }
    }

    private static class Asynchronous
    implements StopStrategy {
        private Asynchronous() {
        }

        public boolean waitForUnsatisfiedConditions(ServiceName serviceName, Set conditions) {
            return false;
        }
    }

    private static class Synchronous
    implements StopStrategy {
        private Synchronous() {
        }

        public boolean waitForUnsatisfiedConditions(ServiceName serviceName, Set conditions) throws UnsatisfiedConditionsException {
            throw new UnsatisfiedConditionsException("Unsatisfied stop conditions", serviceName, conditions);
        }
    }
}

