/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverManagerConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDriver;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.KerberosInterpreter;
import org.apache.zeppelin.interpreter.ResultMessages;
import org.apache.zeppelin.interpreter.SingleRowInterpreterResult;
import org.apache.zeppelin.interpreter.ZeppelinContext;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.interpreter.util.SqlSplitter;
import org.apache.zeppelin.jdbc.JDBCUserConfigurations;
import org.apache.zeppelin.jdbc.SqlCompleter;
import org.apache.zeppelin.jdbc.hive.HiveUtils;
import org.apache.zeppelin.jdbc.security.JDBCSecurityImpl;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.apache.zeppelin.tabledata.TableDataUtils;
import org.apache.zeppelin.user.UserCredentials;
import org.apache.zeppelin.user.UsernamePassword;
import org.apache.zeppelin.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCInterpreter
extends KerberosInterpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JDBCInterpreter.class);
    static final String COMMON_KEY = "common";
    static final String MAX_LINE_KEY = "max_count";
    static final int MAX_LINE_DEFAULT = 1000;
    static final String DEFAULT_KEY = "default";
    static final String DRIVER_KEY = "driver";
    static final String URL_KEY = "url";
    static final String USER_KEY = "user";
    static final String PASSWORD_KEY = "password";
    static final String PRECODE_KEY = "precode";
    static final String STATEMENT_PRECODE_KEY = "statementPrecode";
    static final String COMPLETER_SCHEMA_FILTERS_KEY = "completer.schemaFilters";
    static final String COMPLETER_TTL_KEY = "completer.ttlInSeconds";
    static final String DEFAULT_COMPLETER_TTL = "120";
    static final String JDBC_JCEKS_FILE = "jceks.file";
    static final String JDBC_JCEKS_CREDENTIAL_KEY = "jceks.credentialKey";
    static final String PRECODE_KEY_TEMPLATE = "%s.precode";
    static final String STATEMENT_PRECODE_KEY_TEMPLATE = "%s.statementPrecode";
    static final String DOT = ".";
    private static final char WHITESPACE = ' ';
    private static final char NEWLINE = '\n';
    private static final char TAB = '\t';
    private static final String TABLE_MAGIC_TAG = "%table ";
    private static final String EXPLAIN_PREDICATE = "EXPLAIN ";
    private static final String CANCEL_REASON = "cancel_reason";
    static final String COMMON_MAX_LINE = "common.max_count";
    static final String DEFAULT_DRIVER = "default.driver";
    static final String DEFAULT_URL = "default.url";
    static final String DEFAULT_USER = "default.user";
    static final String DEFAULT_PASSWORD = "default.password";
    static final String DEFAULT_PRECODE = "default.precode";
    static final String DEFAULT_STATEMENT_PRECODE = "default.statementPrecode";
    static final String EMPTY_COLUMN_VALUE = "";
    private static final String CONCURRENT_EXECUTION_KEY = "zeppelin.jdbc.concurrent.use";
    private static final String CONCURRENT_EXECUTION_COUNT = "zeppelin.jdbc.concurrent.max_connection";
    private static final String DBCP_STRING = "jdbc:apache:commons:dbcp:";
    private static final String MAX_ROWS_KEY = "zeppelin.jdbc.maxRows";
    private static final Set<String> PRESTO_PROPERTIES = new HashSet<String>(Arrays.asList("user", "password", "socksProxy", "httpProxy", "clientTags", "applicationNamePrefix", "accessToken", "SSL", "SSLKeyStorePath", "SSLKeyStorePassword", "SSLTrustStorePath", "SSLTrustStorePassword", "KerberosRemoteServiceName", "KerberosPrincipal", "KerberosUseCanonicalHostname", "KerberosServicePrincipalPattern", "KerberosConfigPath", "KerberosKeytabPath", "KerberosCredentialCachePath", "extraCredentials", "roles", "sessionProperties"));
    private final HashMap<String, Properties> basePropertiesMap;
    private final HashMap<String, JDBCUserConfigurations> jdbcUserConfigurationsMap;
    private final HashMap<String, SqlCompleter> sqlCompletersMap;
    private int maxLineResults = 1000;
    private int maxRows;
    private SqlSplitter sqlSplitter;
    private Map<String, ScheduledExecutorService> refreshExecutorServices = new HashMap<String, ScheduledExecutorService>();
    private Map<String, Boolean> isFirstRefreshMap = new HashMap<String, Boolean>();
    private Map<String, Boolean> paragraphCancelMap = new HashMap<String, Boolean>();

    public JDBCInterpreter(Properties property) {
        super(property);
        this.jdbcUserConfigurationsMap = new HashMap();
        this.basePropertiesMap = new HashMap();
        this.sqlCompletersMap = new HashMap();
    }

    public ZeppelinContext getZeppelinContext() {
        return null;
    }

    protected boolean runKerberosLogin() {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", UserGroupInformation.AuthenticationMethod.KERBEROS.toString());
        UserGroupInformation.setConfiguration((Configuration)conf);
        try {
            if (UserGroupInformation.isLoginKeytabBased()) {
                LOGGER.debug("Trying relogin from keytab");
                UserGroupInformation.getLoginUser().reloginFromKeytab();
                return true;
            }
            if (UserGroupInformation.isLoginTicketBased()) {
                LOGGER.debug("Trying relogin from ticket cache");
                UserGroupInformation.getLoginUser().reloginFromTicketCache();
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to run kinit for zeppelin", (Throwable)e);
        }
        LOGGER.debug("Neither Keytab nor ticket based login. runKerberosLogin() returning false");
        return false;
    }

    public void open() {
        super.open();
        for (String propertyKey : this.properties.stringPropertyNames()) {
            Properties prefixProperties;
            LOGGER.debug("propertyKey: {}", (Object)propertyKey);
            String[] keyValue = propertyKey.split("\\.", 2);
            if (2 != keyValue.length) continue;
            LOGGER.debug("key: {}, value: {}", (Object)keyValue[0], (Object)keyValue[1]);
            if (this.basePropertiesMap.containsKey(keyValue[0])) {
                prefixProperties = this.basePropertiesMap.get(keyValue[0]);
            } else {
                prefixProperties = new Properties();
                this.basePropertiesMap.put(keyValue[0].trim(), prefixProperties);
            }
            prefixProperties.put(keyValue[1].trim(), this.getProperty(propertyKey));
        }
        HashSet<String> removeKeySet = new HashSet<String>();
        for (String key : this.basePropertiesMap.keySet()) {
            Properties properties;
            if (COMMON_KEY.equals(key) || (properties = this.basePropertiesMap.get(key)).containsKey(DRIVER_KEY) && properties.containsKey(URL_KEY)) continue;
            LOGGER.error("{} will be ignored. {}.{} and {}.{} is mandatory.", new Object[]{key, DRIVER_KEY, key, key, URL_KEY});
            removeKeySet.add(key);
        }
        for (String key : removeKeySet) {
            this.basePropertiesMap.remove(key);
        }
        LOGGER.debug("JDBC PropertiesMap: {}", this.basePropertiesMap);
        this.setMaxLineResults();
        this.setMaxRows();
        this.sqlSplitter = new SqlSplitter();
    }

    protected boolean isKerboseEnabled() {
        UserGroupInformation.AuthenticationMethod authType;
        return !StringUtils.isEmpty((CharSequence)this.getProperty("zeppelin.jdbc.auth.type")) && (authType = JDBCSecurityImpl.getAuthType(this.properties)).equals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS);
    }

    private void setMaxLineResults() {
        if (this.basePropertiesMap.containsKey(COMMON_KEY) && this.basePropertiesMap.get(COMMON_KEY).containsKey(MAX_LINE_KEY)) {
            this.maxLineResults = Integer.valueOf(this.basePropertiesMap.get(COMMON_KEY).getProperty(MAX_LINE_KEY));
        }
    }

    private void setMaxRows() {
        this.maxRows = Integer.valueOf(this.getProperty(MAX_ROWS_KEY, "1000"));
    }

    private SqlCompleter createOrUpdateSqlCompleter(SqlCompleter sqlCompleter, final Connection connection, String propertyKey, final String buf, final int cursor) {
        SqlCompleter completer;
        block4: {
            String schemaFiltersKey = String.format("%s.%s", propertyKey, COMPLETER_SCHEMA_FILTERS_KEY);
            String sqlCompleterTtlKey = String.format("%s.%s", propertyKey, COMPLETER_TTL_KEY);
            final String schemaFiltersString = this.getProperty(schemaFiltersKey);
            int ttlInSeconds = Integer.valueOf((String)StringUtils.defaultIfEmpty((CharSequence)this.getProperty(sqlCompleterTtlKey), (CharSequence)DEFAULT_COMPLETER_TTL));
            completer = sqlCompleter == null ? new SqlCompleter(ttlInSeconds) : sqlCompleter;
            ExecutorService executorService = Executors.newFixedThreadPool(1);
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    completer.createOrUpdateFromConnection(connection, schemaFiltersString, buf, cursor);
                }
            });
            executorService.shutdown();
            try {
                executorService.awaitTermination(3L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOGGER.warn("Completion timeout", (Throwable)e);
                if (connection == null) break block4;
                try {
                    connection.close();
                }
                catch (SQLException e1) {
                    LOGGER.warn("Error close connection", (Throwable)e1);
                }
            }
        }
        return completer;
    }

    private void initStatementMap() {
        for (JDBCUserConfigurations configurations : this.jdbcUserConfigurationsMap.values()) {
            try {
                configurations.initStatementMap();
            }
            catch (Exception e) {
                LOGGER.error("Error while closing paragraphIdStatementMap statement...", (Throwable)e);
            }
        }
    }

    private void initConnectionPoolMap() {
        for (String key : this.jdbcUserConfigurationsMap.keySet()) {
            try {
                this.closeDBPool(key);
            }
            catch (SQLException e) {
                LOGGER.error("Error while closing database pool.", (Throwable)e);
            }
            try {
                JDBCUserConfigurations configurations = this.jdbcUserConfigurationsMap.get(key);
                configurations.initConnectionPoolMap();
            }
            catch (SQLException e) {
                LOGGER.error("Error while closing initConnectionPoolMap.", (Throwable)e);
            }
        }
    }

    public void close() {
        super.close();
        try {
            this.initStatementMap();
            this.initConnectionPoolMap();
        }
        catch (Exception e) {
            LOGGER.error("Error while closing...", (Throwable)e);
        }
    }

    private String getUser(InterpreterContext context) {
        String userInProperty;
        String user = context.getAuthenticationInfo().getUser();
        if ("anonymous".equalsIgnoreCase(user) && this.basePropertiesMap.containsKey(DEFAULT_KEY) && StringUtils.isNotBlank((CharSequence)(userInProperty = this.basePropertiesMap.get(DEFAULT_KEY).getProperty(USER_KEY)))) {
            user = userInProperty;
        }
        return user;
    }

    private String getEntityName(String replName, String propertyKey) {
        if ("jdbc".equals(replName)) {
            return propertyKey;
        }
        return replName;
    }

    private String getJDBCDriverName(String user) {
        StringBuffer driverName = new StringBuffer();
        driverName.append(DBCP_STRING);
        driverName.append(DEFAULT_KEY);
        driverName.append(user);
        return driverName.toString();
    }

    private boolean existAccountInBaseProperty(String propertyKey) {
        return this.basePropertiesMap.get(propertyKey).containsKey(USER_KEY) && !StringUtils.isEmpty((CharSequence)((String)this.basePropertiesMap.get(propertyKey).get(USER_KEY))) && this.basePropertiesMap.get(propertyKey).containsKey(PASSWORD_KEY);
    }

    private UsernamePassword getUsernamePassword(InterpreterContext interpreterContext, String entity) {
        UserCredentials uc = interpreterContext.getAuthenticationInfo().getUserCredentials();
        if (uc != null) {
            return uc.getUsernamePassword(entity);
        }
        return null;
    }

    public JDBCUserConfigurations getJDBCConfiguration(String user) {
        JDBCUserConfigurations jdbcUserConfigurations = this.jdbcUserConfigurationsMap.get(user);
        if (jdbcUserConfigurations == null) {
            jdbcUserConfigurations = new JDBCUserConfigurations();
            this.jdbcUserConfigurationsMap.put(user, jdbcUserConfigurations);
        }
        return jdbcUserConfigurations;
    }

    private void closeDBPool(String user) throws SQLException {
        PoolingDriver poolingDriver = this.getJDBCConfiguration(user).removeDBDriverPool();
        if (poolingDriver != null) {
            poolingDriver.closePool(DEFAULT_KEY + user);
        }
    }

    private void setUserProperty(InterpreterContext context) throws SQLException, IOException, InterpreterException {
        String password;
        String user = this.getUser(context);
        JDBCUserConfigurations jdbcUserConfigurations = this.getJDBCConfiguration(user);
        if (this.basePropertiesMap.get(DEFAULT_KEY).containsKey(USER_KEY) && !this.basePropertiesMap.get(DEFAULT_KEY).getProperty(USER_KEY).isEmpty() && !StringUtils.isEmpty((CharSequence)(password = this.getPassword(this.basePropertiesMap.get(DEFAULT_KEY))))) {
            this.basePropertiesMap.get(DEFAULT_KEY).setProperty(PASSWORD_KEY, password);
        }
        jdbcUserConfigurations.setProperty(this.basePropertiesMap.get(DEFAULT_KEY));
        if (this.existAccountInBaseProperty(DEFAULT_KEY)) {
            return;
        }
        UsernamePassword usernamePassword = this.getUsernamePassword(context, this.getEntityName(context.getReplName(), DEFAULT_KEY));
        if (usernamePassword != null) {
            jdbcUserConfigurations.cleanUserProperty();
            jdbcUserConfigurations.setUserProperty(usernamePassword);
        } else {
            this.closeDBPool(user);
        }
    }

    private void configConnectionPool(GenericObjectPool connectionPool, Properties properties) {
        boolean testOnBorrow = "true".equalsIgnoreCase(properties.getProperty("testOnBorrow"));
        boolean testOnCreate = "true".equalsIgnoreCase(properties.getProperty("testOnCreate"));
        boolean testOnReturn = "true".equalsIgnoreCase(properties.getProperty("testOnReturn"));
        boolean testWhileIdle = "true".equalsIgnoreCase(properties.getProperty("testWhileIdle"));
        long timeBetweenEvictionRunsMillis = PropertiesUtil.getLong((Properties)properties, (String)"timeBetweenEvictionRunsMillis", (long)-1L);
        long maxWaitMillis = PropertiesUtil.getLong((Properties)properties, (String)"maxWaitMillis", (long)-1L);
        int maxIdle = PropertiesUtil.getInt((Properties)properties, (String)"maxIdle", (int)8);
        int minIdle = PropertiesUtil.getInt((Properties)properties, (String)"minIdle", (int)0);
        int maxTotal = PropertiesUtil.getInt((Properties)properties, (String)"maxTotal", (int)-1);
        connectionPool.setTestOnBorrow(testOnBorrow);
        connectionPool.setTestOnCreate(testOnCreate);
        connectionPool.setTestOnReturn(testOnReturn);
        connectionPool.setTestWhileIdle(testWhileIdle);
        connectionPool.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
        connectionPool.setMaxIdle(maxIdle);
        connectionPool.setMinIdle(minIdle);
        connectionPool.setMaxTotal(maxTotal);
        connectionPool.setMaxWaitMillis(maxWaitMillis);
    }

    private void createConnectionPool(String url, String user, Properties properties) throws SQLException, ClassNotFoundException {
        LOGGER.info("Creating connection pool for url: {}, user: {}", (Object)url, (Object)user);
        String driverClass = properties.getProperty(DRIVER_KEY);
        if (driverClass != null && (driverClass.equals("com.facebook.presto.jdbc.PrestoDriver") || driverClass.equals("io.prestosql.jdbc.PrestoDriver") || driverClass.equals("io.trino.jdbc.TrinoDriver"))) {
            for (String key : properties.stringPropertyNames()) {
                if (PRESTO_PROPERTIES.contains(key)) continue;
                properties.remove(key);
            }
        }
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(url, properties);
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, null);
        String maxConnectionLifetime = (String)StringUtils.defaultIfEmpty((CharSequence)this.getProperty("zeppelin.jdbc.maxConnLifetime"), (CharSequence)"-1");
        poolableConnectionFactory.setMaxConnLifetimeMillis(Long.parseLong(maxConnectionLifetime));
        poolableConnectionFactory.setValidationQuery(PropertiesUtil.getString((Properties)properties, (String)"validationQuery", (String)"show databases"));
        GenericObjectPool connectionPool = new GenericObjectPool((PooledObjectFactory)poolableConnectionFactory);
        this.configConnectionPool(connectionPool, properties);
        poolableConnectionFactory.setPool((ObjectPool)connectionPool);
        Class.forName(driverClass);
        PoolingDriver driver = new PoolingDriver();
        driver.registerPool(DEFAULT_KEY + user, (ObjectPool)connectionPool);
        this.getJDBCConfiguration(user).saveDBDriverPool(driver);
    }

    private Connection getConnectionFromPool(String url, String user, Properties properties) throws SQLException, ClassNotFoundException {
        String jdbcDriver = this.getJDBCDriverName(user);
        if (!this.getJDBCConfiguration(user).isConnectionInDBDriverPool()) {
            this.createConnectionPool(url, user, properties);
        }
        return DriverManager.getConnection(jdbcDriver);
    }

    public Connection getConnection(InterpreterContext context) throws ClassNotFoundException, SQLException, InterpreterException, IOException {
        String authType;
        if (this.basePropertiesMap.get(DEFAULT_KEY) == null) {
            LOGGER.warn("No default config");
            return null;
        }
        Connection connection = null;
        String user = this.getUser(context);
        JDBCUserConfigurations jdbcUserConfigurations = this.getJDBCConfiguration(user);
        this.setUserProperty(context);
        Properties properties = jdbcUserConfigurations.getProperty();
        String url = properties.getProperty(URL_KEY);
        url = this.appendProxyUserToURL(url, user);
        String connectionUrl = this.appendTagsToURL(url, context);
        switch (authType = this.getProperty("zeppelin.jdbc.auth.type", "SIMPLE").trim().toUpperCase()) {
            case "SIMPLE": {
                connection = this.getConnectionFromPool(connectionUrl, user, properties);
                break;
            }
            case "KERBEROS": {
                LOGGER.debug("Calling createSecureConfiguration(); this will do loginUserFromKeytab() if required");
                JDBCSecurityImpl.createSecureConfiguration(this.getProperties(), UserGroupInformation.AuthenticationMethod.KERBEROS);
                LOGGER.debug("createSecureConfiguration() returned");
                boolean isProxyEnabled = Boolean.parseBoolean(this.getProperty("zeppelin.jdbc.auth.kerberos.proxy.enable", "true"));
                if (this.basePropertiesMap.get(DEFAULT_KEY).containsKey("proxy.user.property") || !isProxyEnabled) {
                    connection = this.getConnectionFromPool(connectionUrl, user, properties);
                    break;
                }
                UserGroupInformation ugi = null;
                try {
                    ugi = UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)UserGroupInformation.getCurrentUser());
                }
                catch (Exception e) {
                    LOGGER.error("Error in getCurrentUser", (Throwable)e);
                    throw new InterpreterException("Error in getCurrentUser", (Throwable)e);
                }
                String finalUser = user;
                try {
                    connection = (Connection)ugi.doAs(() -> this.getConnectionFromPool(connectionUrl, finalUser, properties));
                    break;
                }
                catch (Exception e) {
                    LOGGER.error("Error in doAs", (Throwable)e);
                    throw new InterpreterException("Error in doAs", (Throwable)e);
                }
            }
        }
        return connection;
    }

    private String appendProxyUserToURL(String url, String user) {
        StringBuilder connectionUrl = new StringBuilder(url);
        if (user != null && !user.equals("anonymous") && this.basePropertiesMap.get(DEFAULT_KEY).containsKey("proxy.user.property")) {
            Integer lastIndexOfUrl = connectionUrl.indexOf("?");
            if (lastIndexOfUrl == -1) {
                lastIndexOfUrl = connectionUrl.length();
            }
            LOGGER.info("Using proxy user as: {}", (Object)user);
            LOGGER.info("Using proxy property for user as: {}", (Object)this.basePropertiesMap.get(DEFAULT_KEY).getProperty("proxy.user.property"));
            connectionUrl.insert((int)lastIndexOfUrl, ";" + this.basePropertiesMap.get(DEFAULT_KEY).getProperty("proxy.user.property") + "=" + user + ";");
        } else if (user != null && !user.equals("anonymous") && url.contains("hive")) {
            LOGGER.warn("User impersonation for hive has changed please refer: http://zeppelin.apache.org/docs/latest/interpreter/jdbc.html#apache-hive");
        }
        return connectionUrl.toString();
    }

    private String appendTagsToURL(String url, InterpreterContext context) {
        if (!Boolean.parseBoolean(this.getProperty("zeppelin.jdbc.hive.engines.tag.enable", "true"))) {
            return url;
        }
        StringBuilder builder = new StringBuilder(url);
        if (url.startsWith("jdbc:hive2:")) {
            Integer lastIndexOfQMark = builder.indexOf("?");
            if (lastIndexOfQMark == -1) {
                builder.append("?");
                lastIndexOfQMark = builder.length();
            } else {
                Integer n = lastIndexOfQMark;
                Integer n2 = lastIndexOfQMark = Integer.valueOf(lastIndexOfQMark + 1);
            }
            builder.insert((int)lastIndexOfQMark, "mapreduce.job.tags=" + context.getParagraphId() + ";");
            builder.insert((int)lastIndexOfQMark, "tez.application.tags=" + context.getParagraphId() + ";");
        }
        return builder.toString();
    }

    private String getPassword(Properties properties) throws IOException, InterpreterException {
        if (StringUtils.isNotEmpty((CharSequence)properties.getProperty(PASSWORD_KEY))) {
            return properties.getProperty(PASSWORD_KEY);
        }
        if (StringUtils.isNotEmpty((CharSequence)properties.getProperty(JDBC_JCEKS_FILE)) && StringUtils.isNotEmpty((CharSequence)properties.getProperty(JDBC_JCEKS_CREDENTIAL_KEY))) {
            try {
                Configuration configuration = new Configuration();
                configuration.set("hadoop.security.credential.provider.path", properties.getProperty(JDBC_JCEKS_FILE));
                CredentialProvider provider = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)configuration).get(0);
                CredentialProvider.CredentialEntry credEntry = provider.getCredentialEntry(properties.getProperty(JDBC_JCEKS_CREDENTIAL_KEY));
                if (credEntry != null) {
                    return new String(credEntry.getCredential());
                }
                throw new InterpreterException("Failed to retrieve password from JCEKS from key: " + properties.getProperty(JDBC_JCEKS_CREDENTIAL_KEY));
            }
            catch (Exception e) {
                LOGGER.error("Failed to retrieve password from JCEKS \nFor file: {} \nFor key: {}", new Object[]{properties.getProperty(JDBC_JCEKS_FILE), properties.getProperty(JDBC_JCEKS_CREDENTIAL_KEY), e});
                throw e;
            }
        }
        return null;
    }

    private String getResults(ResultSet resultSet, boolean isTableType) throws SQLException {
        ResultSetMetaData md = resultSet.getMetaData();
        StringBuilder msg = isTableType ? new StringBuilder(TABLE_MAGIC_TAG) : new StringBuilder();
        for (int i = 1; i < md.getColumnCount() + 1; ++i) {
            if (i > 1) {
                msg.append('\t');
            }
            if (StringUtils.isNotEmpty((CharSequence)md.getColumnLabel(i))) {
                msg.append(this.removeTablePrefix(this.replaceReservedChars(TableDataUtils.normalizeColumn((String)md.getColumnLabel(i)))));
                continue;
            }
            msg.append(this.removeTablePrefix(this.replaceReservedChars(TableDataUtils.normalizeColumn((String)md.getColumnName(i)))));
        }
        msg.append('\n');
        int displayRowCount = 0;
        boolean truncate = false;
        while (resultSet.next()) {
            if (displayRowCount >= this.getMaxResult()) {
                truncate = true;
                break;
            }
            for (int i = 1; i < md.getColumnCount() + 1; ++i) {
                Object resultObject = resultSet.getObject(i);
                String resultValue = resultObject == null ? "null" : resultSet.getString(i);
                msg.append(this.replaceReservedChars(TableDataUtils.normalizeColumn((String)resultValue)));
                if (i == md.getColumnCount()) continue;
                msg.append('\t');
            }
            msg.append('\n');
            ++displayRowCount;
        }
        if (truncate) {
            msg.append("\n" + ResultMessages.getExceedsLimitRowsMessage((int)this.getMaxResult(), (String)String.format("%s.%s", COMMON_KEY, MAX_LINE_KEY)).toString());
        }
        return msg.toString();
    }

    private boolean isDDLCommand(int updatedCount, int columnCount) throws SQLException {
        return updatedCount < 0 && columnCount <= 0;
    }

    public InterpreterResult executePrecode(InterpreterContext interpreterContext) throws InterpreterException {
        String propertyKey;
        String precode;
        InterpreterResult interpreterResult = null;
        Iterator<String> iterator = this.basePropertiesMap.keySet().iterator();
        while (iterator.hasNext() && (!StringUtils.isNotBlank((CharSequence)(precode = this.getProperty(String.format(PRECODE_KEY_TEMPLATE, propertyKey = iterator.next())))) || (interpreterResult = this.executeSql(precode, interpreterContext)).code() == InterpreterResult.Code.SUCCESS)) {
        }
        return interpreterResult;
    }

    protected List<String> splitSqlQueries(String text) {
        return this.sqlSplitter.splitSql(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InterpreterResult executeSql(String sql, InterpreterContext context) throws InterpreterException {
        Connection connection = null;
        ResultSet resultSet = null;
        String paragraphId = context.getParagraphId();
        String user = this.getUser(context);
        try {
            connection = this.getConnection(context);
        }
        catch (Exception e) {
            LOGGER.error("Fail to getConnection", (Throwable)e);
            try {
                this.closeDBPool(user);
            }
            catch (SQLException e1) {
                LOGGER.error("Cannot close DBPool for user: " + user, (Throwable)e1);
            }
            if (e instanceof SQLException) {
                return new InterpreterResult(InterpreterResult.Code.ERROR, e.getMessage());
            }
            return new InterpreterResult(InterpreterResult.Code.ERROR, ExceptionUtils.getStackTrace((Throwable)e));
        }
        if (connection == null) {
            return new InterpreterResult(InterpreterResult.Code.ERROR, "User's connectin not found.");
        }
        try {
            List sqlArray = this.sqlSplitter.splitSql(sql);
            for (String sqlToExecute : sqlArray) {
                String sqlTrimmedLowerCase = sqlToExecute.trim().toLowerCase();
                if (sqlTrimmedLowerCase.startsWith("set ") || sqlTrimmedLowerCase.startsWith("list ") || sqlTrimmedLowerCase.startsWith("add ") || sqlTrimmedLowerCase.startsWith("delete ")) {
                    sqlToExecute = sqlToExecute.trim();
                }
                LOGGER.info("Execute sql: " + sqlToExecute);
                Statement statement = connection.createStatement();
                statement.setFetchSize(context.getIntLocalProperty("limit", this.getMaxResult()));
                statement.setMaxRows(context.getIntLocalProperty("limit", this.maxRows));
                if (statement == null) {
                    InterpreterResult interpreterResult = new InterpreterResult(InterpreterResult.Code.ERROR, "Prefix not found.");
                    return interpreterResult;
                }
                try {
                    this.getJDBCConfiguration(user).saveStatement(paragraphId, statement);
                    String statementPrecode = this.getProperty(String.format(STATEMENT_PRECODE_KEY_TEMPLATE, DEFAULT_KEY));
                    if (StringUtils.isNotBlank((CharSequence)statementPrecode)) {
                        statement.execute(statementPrecode);
                    }
                    String jdbcURL = this.getJDBCConfiguration(user).getProperty().getProperty(URL_KEY);
                    String driver = this.getJDBCConfiguration(user).getProperty().getProperty(DRIVER_KEY);
                    if (jdbcURL != null && jdbcURL.startsWith("jdbc:hive2://") && driver != null && driver.equals("org.apache.hive.jdbc.HiveDriver")) {
                        HiveUtils.startHiveMonitorThread(statement, context, Boolean.parseBoolean(this.getProperty("hive.log.display", "true")), this);
                    }
                    boolean isResultSetAvailable = statement.execute(sqlToExecute);
                    this.getJDBCConfiguration(user).setConnectionInDBDriverPoolSuccessful();
                    if (isResultSetAvailable) {
                        resultSet = statement.getResultSet();
                        if (this.isDDLCommand(statement.getUpdateCount(), resultSet.getMetaData().getColumnCount())) {
                            context.out.write("%text Query executed successfully.\n");
                            continue;
                        }
                        String template = (String)context.getLocalProperties().get("template");
                        if (!StringUtils.isBlank((CharSequence)template)) {
                            resultSet.next();
                            SingleRowInterpreterResult singleRowResult = new SingleRowInterpreterResult(this.getFirstRow(resultSet), template, context);
                            if (this.isFirstRefreshMap.get(context.getParagraphId()).booleanValue()) {
                                context.out.write(singleRowResult.toAngular());
                                context.out.write("\n%text ");
                                context.out.flush();
                                this.isFirstRefreshMap.put(context.getParagraphId(), false);
                            }
                            singleRowResult.pushAngularObjects();
                            continue;
                        }
                        String results = this.getResults(resultSet, !StringUtils.containsIgnoreCase((CharSequence)sqlToExecute, (CharSequence)EXPLAIN_PREDICATE));
                        context.out.write(results);
                        context.out.write("\n%text ");
                        context.out.flush();
                        continue;
                    }
                    int updateCount = statement.getUpdateCount();
                    context.out.write("\n%text Query executed successfully. Affected rows : " + updateCount + "\n");
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (statement == null) continue;
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        catch (Throwable e) {
            InterpreterResult interpreterResult;
            LOGGER.error("Cannot run " + sql, e);
            if (e instanceof SQLException) {
                interpreterResult = new InterpreterResult(InterpreterResult.Code.ERROR, e.getMessage());
                return interpreterResult;
            }
            interpreterResult = new InterpreterResult(InterpreterResult.Code.ERROR, ExceptionUtils.getStackTrace((Throwable)e));
            return interpreterResult;
        }
        finally {
            if (connection != null) {
                try {
                    if (!connection.getAutoCommit()) {
                        connection.commit();
                    }
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
            this.getJDBCConfiguration(user).removeStatement(paragraphId);
        }
        return new InterpreterResult(InterpreterResult.Code.SUCCESS);
    }

    private List getFirstRow(ResultSet rs) throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        ResultSetMetaData md = rs.getMetaData();
        for (int i = 1; i <= md.getColumnCount(); ++i) {
            Object columnObject = rs.getObject(i);
            String columnValue = null;
            columnValue = columnObject == null ? "null" : rs.getString(i);
            list.add(columnValue);
        }
        return list;
    }

    private String replaceReservedChars(String str) {
        if (str == null) {
            return EMPTY_COLUMN_VALUE;
        }
        return str.replace('\t', ' ').replace('\n', ' ');
    }

    private String removeTablePrefix(String columnName) {
        int index = columnName.indexOf(DOT);
        if (index > 0) {
            return columnName.substring(index + 1);
        }
        return columnName;
    }

    protected boolean isInterpolate() {
        return Boolean.parseBoolean(this.getProperty("zeppelin.jdbc.interpolation", "false"));
    }

    private boolean isRefreshMode(InterpreterContext context) {
        return context.getLocalProperties().get("refreshInterval") != null;
    }

    public InterpreterResult internalInterpret(String cmd, InterpreterContext context) throws InterpreterException {
        String dbprefix = this.getDBPrefix(context);
        if (!StringUtils.equals((CharSequence)dbprefix, (CharSequence)DEFAULT_KEY)) {
            LOGGER.warn("DBprefix like %jdbc(db=mysql) or %jdbc(mysql) is not supported anymore\uff01");
            LOGGER.warn("JDBC Interpreter would try to use default config.");
        }
        LOGGER.debug("Run SQL command '{}'", (Object)cmd);
        if (!this.isRefreshMode(context)) {
            return this.executeSql(cmd, context);
        }
        int refreshInterval = Integer.parseInt((String)context.getLocalProperties().get("refreshInterval"));
        this.paragraphCancelMap.put(context.getParagraphId(), false);
        ScheduledExecutorService refreshExecutor = Executors.newSingleThreadScheduledExecutor();
        this.refreshExecutorServices.put(context.getParagraphId(), refreshExecutor);
        this.isFirstRefreshMap.put(context.getParagraphId(), true);
        AtomicReference interpreterResultRef = new AtomicReference();
        refreshExecutor.scheduleAtFixedRate(() -> {
            context.out.clear(false);
            try {
                InterpreterResult result = this.executeSql(cmd, context);
                context.out.flush();
                interpreterResultRef.set(result);
                if (result.code() != InterpreterResult.Code.SUCCESS) {
                    refreshExecutor.shutdownNow();
                }
            }
            catch (Exception e) {
                LOGGER.warn("Fail to run sql", (Throwable)e);
            }
        }, 0L, refreshInterval, TimeUnit.MILLISECONDS);
        while (!refreshExecutor.isTerminated()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOGGER.error(EMPTY_COLUMN_VALUE);
            }
        }
        this.refreshExecutorServices.remove(context.getParagraphId());
        if (this.paragraphCancelMap.getOrDefault(context.getParagraphId(), false).booleanValue()) {
            return new InterpreterResult(InterpreterResult.Code.ERROR);
        }
        if (((InterpreterResult)interpreterResultRef.get()).code() == InterpreterResult.Code.ERROR) {
            return (InterpreterResult)interpreterResultRef.get();
        }
        return new InterpreterResult(InterpreterResult.Code.SUCCESS);
    }

    public void cancel(InterpreterContext context) {
        if (this.isRefreshMode(context)) {
            LOGGER.info("Shutdown refreshExecutorService for paragraph: {}", (Object)context.getParagraphId());
            ScheduledExecutorService executorService = this.refreshExecutorServices.get(context.getParagraphId());
            if (executorService != null) {
                executorService.shutdownNow();
            }
            this.paragraphCancelMap.put(context.getParagraphId(), true);
            return;
        }
        LOGGER.info("Cancel current query statement.");
        String paragraphId = context.getParagraphId();
        JDBCUserConfigurations jdbcUserConfigurations = this.getJDBCConfiguration(this.getUser(context));
        try {
            jdbcUserConfigurations.cancelStatement(paragraphId);
        }
        catch (SQLException e) {
            LOGGER.error("Error while cancelling...", (Throwable)e);
        }
        String cancelReason = (String)context.getLocalProperties().get(CANCEL_REASON);
        if (StringUtils.isNotBlank((CharSequence)cancelReason)) {
            try {
                context.out.write(cancelReason);
            }
            catch (IOException e) {
                LOGGER.error("Fail to write cancel reason");
            }
        }
    }

    public void cancel(InterpreterContext context, String errorMessage) {
        context.getLocalProperties().put(CANCEL_REASON, errorMessage);
        this.cancel(context);
    }

    public String getDBPrefix(InterpreterContext context) {
        Map localProperties = context.getLocalProperties();
        if (localProperties.containsKey("db")) {
            return (String)localProperties.get("db");
        }
        for (Map.Entry entry : localProperties.entrySet()) {
            if (!((String)entry.getKey()).equals(entry.getValue())) continue;
            return (String)entry.getKey();
        }
        return DEFAULT_KEY;
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.SIMPLE;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public Scheduler getScheduler() {
        String schedulerName = JDBCInterpreter.class.getName() + ((Object)((Object)this)).hashCode();
        return this.isConcurrentExecution() ? SchedulerFactory.singleton().createOrGetParallelScheduler(schedulerName, this.getMaxConcurrentConnection()) : SchedulerFactory.singleton().createOrGetFIFOScheduler(schedulerName);
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext context) throws InterpreterException {
        ArrayList<InterpreterCompletion> candidates = new ArrayList<InterpreterCompletion>();
        String sqlCompleterKey = String.format("%s.%s", this.getUser(context), DEFAULT_KEY);
        SqlCompleter sqlCompleter = this.sqlCompletersMap.get(sqlCompleterKey);
        Connection connection = null;
        try {
            if (context != null) {
                connection = this.getConnection(context);
            }
        }
        catch (IOException | ClassNotFoundException | SQLException e) {
            LOGGER.warn("SQLCompleter will created without use connection");
        }
        sqlCompleter = this.createOrUpdateSqlCompleter(sqlCompleter, connection, DEFAULT_KEY, buf, cursor);
        this.sqlCompletersMap.put(sqlCompleterKey, sqlCompleter);
        sqlCompleter.complete(buf, cursor, candidates);
        return candidates;
    }

    public int getMaxResult() {
        return this.maxLineResults;
    }

    boolean isConcurrentExecution() {
        return Boolean.valueOf(this.getProperty(CONCURRENT_EXECUTION_KEY));
    }

    int getMaxConcurrentConnection() {
        try {
            return Integer.valueOf(this.getProperty(CONCURRENT_EXECUTION_COUNT));
        }
        catch (Exception e) {
            LOGGER.error("Fail to parse {} with value: {}", (Object)CONCURRENT_EXECUTION_COUNT, (Object)this.getProperty(CONCURRENT_EXECUTION_COUNT));
            return 10;
        }
    }
}

