/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jdbc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Pattern;
import jline.console.completer.ArgumentCompleter;
import jline.console.completer.Completer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.zeppelin.completer.CachedCompleter;
import org.apache.zeppelin.completer.CompletionType;
import org.apache.zeppelin.completer.StringsCompleter;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlCompleter {
    private static Logger logger = LoggerFactory.getLogger(SqlCompleter.class);
    private ArgumentCompleter.WhitespaceArgumentDelimiter sqlDelimiter = new ArgumentCompleter.WhitespaceArgumentDelimiter(){
        private Pattern pattern = Pattern.compile(",");

        public boolean isDelimiterChar(CharSequence buffer, int pos) {
            return this.pattern.matcher("" + buffer.charAt(pos)).matches() || super.isDelimiterChar(buffer, pos);
        }
    };
    private CachedCompleter schemasCompleter;
    private Map<String, CachedCompleter> tablesCompleters = new HashMap<String, CachedCompleter>();
    private Map<String, CachedCompleter> columnsCompleters = new HashMap<String, CachedCompleter>();
    private CachedCompleter keywordCompleter;
    private int ttlInSeconds;

    public SqlCompleter(int ttlInSeconds) {
        this.ttlInSeconds = ttlInSeconds;
    }

    public int complete(String buffer, int cursor, List<InterpreterCompletion> candidates) {
        int argumentPosition;
        logger.debug("Complete with buffer = " + buffer + ", cursor = " + cursor);
        ArgumentCompleter.ArgumentList argumentList = this.sqlDelimiter.delimit((CharSequence)buffer, cursor);
        Pattern whitespaceEndPatter = Pattern.compile("\\s$");
        String cursorArgument = null;
        if (buffer.length() == 0 || whitespaceEndPatter.matcher(buffer).find()) {
            argumentPosition = buffer.length() - 1;
        } else {
            cursorArgument = argumentList.getCursorArgument();
            argumentPosition = argumentList.getArgumentPosition();
        }
        int complete = this.completeName(cursorArgument, argumentPosition, candidates, this.findAliasesInSQL(argumentList.getArguments()));
        logger.debug("complete:" + complete + ", size:" + candidates.size());
        return complete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> getSchemaNames(DatabaseMetaData meta, List<String> schemaFilters) {
        HashSet<String> res = new HashSet<String>();
        try (ResultSet schemas = meta.getSchemas();){
            while (schemas.next()) {
                String schemaName = schemas.getString("TABLE_SCHEM");
                if (schemaName == null) {
                    schemaName = "";
                }
                for (String schemaFilter : schemaFilters) {
                    if (!schemaFilter.equals("") && !schemaName.matches(schemaFilter.replace("%", ".*?"))) continue;
                    res.add(schemaName);
                }
            }
        }
        catch (SQLException t) {
            logger.error("Failed to retrieve the schema names", (Throwable)t);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> getCatalogNames(DatabaseMetaData meta, List<String> schemaFilters) {
        HashSet<String> res = new HashSet<String>();
        try (ResultSet schemas = meta.getCatalogs();){
            while (schemas.next()) {
                String schemaName = schemas.getString("TABLE_CAT");
                for (String schemaFilter : schemaFilters) {
                    if (!schemaFilter.equals("") && !schemaName.matches(schemaFilter.replace("%", ".*?"))) continue;
                    res.add(schemaName);
                }
            }
        }
        catch (SQLException t) {
            logger.error("Failed to retrieve the schema names", (Throwable)t);
        }
        return res;
    }

    private static void fillTableNames(String schema, DatabaseMetaData meta, Set<String> tables) {
        try (ResultSet tbls = meta.getTables(schema, schema, "%", new String[]{"TABLE", "VIEW", "ALIAS", "SYNONYM", "GLOBAL TEMPORARY", "LOCAL TEMPORARY"});){
            while (tbls.next()) {
                String table = tbls.getString("TABLE_NAME");
                tables.add(table);
            }
        }
        catch (Throwable t) {
            logger.error("Failed to retrieve the table name", t);
        }
    }

    private static void fillColumnNames(String schema, String table, DatabaseMetaData meta, Set<String> columns) {
        try (ResultSet cols = meta.getColumns(schema, schema, table, "%");){
            while (cols.next()) {
                String column = cols.getString("COLUMN_NAME");
                columns.add(column);
            }
        }
        catch (Throwable t) {
            logger.error("Failed to retrieve the column name", t);
        }
    }

    public static Set<String> getSqlKeywordsCompletions(DatabaseMetaData meta) throws IOException, SQLException {
        String keywords = new BufferedReader(new InputStreamReader(SqlCompleter.class.getResourceAsStream("/ansi.sql.keywords"))).readLine();
        TreeSet<String> completions = new TreeSet<String>();
        if (null != meta) {
            String driverSpecificKeywords = "/" + meta.getDriverName().replace(" ", "-").toLowerCase() + "-sql.keywords";
            logger.info("JDBC DriverName:" + driverSpecificKeywords);
            try {
                if (SqlCompleter.class.getResource(driverSpecificKeywords) != null) {
                    String driverKeywords = new BufferedReader(new InputStreamReader(SqlCompleter.class.getResourceAsStream(driverSpecificKeywords))).readLine();
                    keywords = keywords + "," + driverKeywords.toUpperCase();
                }
            }
            catch (Exception e) {
                logger.debug("fail to get driver specific SQL completions for " + driverSpecificKeywords + " : " + e, (Throwable)e);
            }
            try {
                keywords = keywords + "," + meta.getSQLKeywords();
            }
            catch (Exception e) {
                logger.debug("fail to get SQL key words from database metadata: " + e, (Throwable)e);
            }
            try {
                keywords = keywords + "," + meta.getStringFunctions();
            }
            catch (Exception e) {
                logger.debug("fail to get string function names from database metadata: " + e, (Throwable)e);
            }
            try {
                keywords = keywords + "," + meta.getNumericFunctions();
            }
            catch (Exception e) {
                logger.debug("fail to get numeric function names from database metadata: " + e, (Throwable)e);
            }
            try {
                keywords = keywords + "," + meta.getSystemFunctions();
            }
            catch (Exception e) {
                logger.debug("fail to get system function names from database metadata: " + e, (Throwable)e);
            }
            try {
                keywords = keywords + "," + meta.getTimeDateFunctions();
            }
            catch (Exception e) {
                logger.debug("fail to get time date function names from database metadata: " + e, (Throwable)e);
            }
            keywords = keywords.toLowerCase();
        }
        StringTokenizer tok = new StringTokenizer(keywords, ", ");
        while (tok.hasMoreTokens()) {
            completions.add(tok.nextToken());
        }
        return completions;
    }

    public void createOrUpdateFromConnection(Connection connection, String schemaFiltersString, String buffer, int cursor) {
        try (Connection c = connection;){
            if (schemaFiltersString == null) {
                schemaFiltersString = "";
            }
            List<String> schemaFilters = Arrays.asList(schemaFiltersString.split(","));
            CursorArgument cursorArgument = this.parseCursorArgument(buffer, cursor);
            HashSet<String> tables = new HashSet<String>();
            HashSet<String> columns = new HashSet<String>();
            Set<Object> schemas = new HashSet();
            Set<Object> catalogs = new HashSet();
            HashSet<String> keywords = new HashSet();
            if (c != null) {
                DatabaseMetaData databaseMetaData = c.getMetaData();
                if (this.keywordCompleter == null || this.keywordCompleter.getCompleter() == null || this.keywordCompleter.isExpired()) {
                    keywords = SqlCompleter.getSqlKeywordsCompletions(databaseMetaData);
                    this.initKeywords(keywords);
                }
                if (cursorArgument.needLoadSchemas() && (this.schemasCompleter == null || this.schemasCompleter.getCompleter() == null || this.schemasCompleter.isExpired())) {
                    schemas = SqlCompleter.getSchemaNames(databaseMetaData, schemaFilters);
                    catalogs = SqlCompleter.getCatalogNames(databaseMetaData, schemaFilters);
                    if (schemas.size() == 0) {
                        schemas.addAll(catalogs);
                    }
                    this.initSchemas(schemas);
                }
                CachedCompleter tablesCompleter = this.tablesCompleters.get(cursorArgument.getSchema());
                if (cursorArgument.needLoadTables() && (tablesCompleter == null || tablesCompleter.isExpired())) {
                    SqlCompleter.fillTableNames(cursorArgument.getSchema(), databaseMetaData, tables);
                    this.initTables(cursorArgument.getSchema(), tables);
                }
                String schemaTable = String.format("%s.%s", cursorArgument.getSchema(), cursorArgument.getTable());
                CachedCompleter columnsCompleter = this.columnsCompleters.get(schemaTable);
                if (cursorArgument.needLoadColumns() && (columnsCompleter == null || columnsCompleter.isExpired())) {
                    SqlCompleter.fillColumnNames(cursorArgument.getSchema(), cursorArgument.getTable(), databaseMetaData, columns);
                    this.initColumns(schemaTable, columns);
                }
                logger.info("Completer initialized with " + schemas.size() + " schemas, " + columns.size() + " tables and " + keywords.size() + " keywords");
            }
        }
        catch (IOException | SQLException e) {
            logger.error("Failed to update the metadata completions", (Throwable)e);
        }
    }

    public void initKeywords(Set<String> keywords) {
        if (keywords != null && !keywords.isEmpty()) {
            this.keywordCompleter = new CachedCompleter((Completer)new StringsCompleter(keywords), 0);
        }
    }

    public void initSchemas(Set<String> schemas) {
        if (schemas != null && !schemas.isEmpty()) {
            this.schemasCompleter = new CachedCompleter((Completer)new StringsCompleter(new TreeSet<String>(schemas)), this.ttlInSeconds);
        }
    }

    public void initTables(String schema, Set<String> tables) {
        if (tables != null && !tables.isEmpty()) {
            this.tablesCompleters.put(schema, new CachedCompleter((Completer)new StringsCompleter(new TreeSet<String>(tables)), this.ttlInSeconds));
        }
    }

    public void initColumns(String schemaTable, Set<String> columns) {
        if (columns != null && !columns.isEmpty()) {
            this.columnsCompleters.put(schemaTable, new CachedCompleter((Completer)new StringsCompleter(columns), this.ttlInSeconds));
        }
    }

    public Map<String, String> findAliasesInSQL(String[] sqlArguments) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (int i = 0; i < sqlArguments.length - 1; ++i) {
            if (!this.columnsCompleters.keySet().contains(sqlArguments[i]) || !sqlArguments[i + 1].matches("[a-zA-Z]+")) continue;
            res.put(sqlArguments[i + 1], sqlArguments[i]);
        }
        return res;
    }

    private int completeKeyword(String buffer, int cursor, List<CharSequence> candidates) {
        return this.keywordCompleter.getCompleter().complete(buffer, cursor, candidates);
    }

    private int completeSchema(String buffer, int cursor, List<CharSequence> candidates) {
        return this.schemasCompleter.getCompleter().complete(buffer, cursor, candidates);
    }

    private int completeTable(String schema, String buffer, int cursor, List<CharSequence> candidates) {
        if (schema == null || !this.tablesCompleters.containsKey(schema)) {
            return -1;
        }
        return this.tablesCompleters.get(schema).getCompleter().complete(buffer, cursor, candidates);
    }

    private int completeColumn(String schema, String table, String buffer, int cursor, List<CharSequence> candidates) {
        if (schema == null || table == null || !this.columnsCompleters.containsKey(schema + "." + table)) {
            return -1;
        }
        return this.columnsCompleters.get(schema + "." + table).getCompleter().complete(buffer, cursor, candidates);
    }

    public int completeName(String buffer, int cursor, List<InterpreterCompletion> candidates, Map<String, String> aliases) {
        CursorArgument cursorArgument = this.parseCursorArgument(buffer, cursor);
        if (cursorArgument.getSchema() == null) {
            ArrayList<CharSequence> keywordsCandidates = new ArrayList<CharSequence>();
            ArrayList<CharSequence> schemaCandidates = new ArrayList<CharSequence>();
            int keywordsRes = this.completeKeyword(buffer, cursor, keywordsCandidates);
            int schemaRes = this.completeSchema(buffer, cursor, schemaCandidates);
            this.addCompletions(candidates, keywordsCandidates, CompletionType.keyword.name());
            this.addCompletions(candidates, schemaCandidates, CompletionType.schema.name());
            return NumberUtils.max((int[])new int[]{keywordsRes, schemaRes});
        }
        String schema = cursorArgument.getSchema();
        if (aliases.containsKey(schema)) {
            String alias = aliases.get(schema);
            int pointPos = alias.indexOf(46);
            schema = alias.substring(0, pointPos);
            String table = alias.substring(pointPos + 1);
            String column = cursorArgument.getColumn();
            ArrayList<CharSequence> columnCandidates = new ArrayList<CharSequence>();
            int columnRes = this.completeColumn(schema, table, column, cursorArgument.getCursorPosition(), columnCandidates);
            this.addCompletions(candidates, columnCandidates, CompletionType.column.name());
        } else {
            if (cursorArgument.getTable() != null && cursorArgument.getColumn() == null) {
                ArrayList<CharSequence> tableCandidates = new ArrayList<CharSequence>();
                String table = cursorArgument.getTable();
                int tableRes = this.completeTable(schema, table, cursorArgument.getCursorPosition(), tableCandidates);
                this.addCompletions(candidates, tableCandidates, CompletionType.table.name());
                return tableRes;
            }
            ArrayList<CharSequence> columnCandidates = new ArrayList<CharSequence>();
            String table = cursorArgument.getTable();
            String column = cursorArgument.getColumn();
            int columnRes = this.completeColumn(schema, table, column, cursorArgument.getCursorPosition(), columnCandidates);
            this.addCompletions(candidates, columnCandidates, CompletionType.column.name());
        }
        return -1;
    }

    ArgumentCompleter.WhitespaceArgumentDelimiter getSqlDelimiter() {
        return this.sqlDelimiter;
    }

    private void addCompletions(List<InterpreterCompletion> interpreterCompletions, List<CharSequence> candidates, String meta) {
        for (CharSequence candidate : candidates) {
            interpreterCompletions.add(new InterpreterCompletion(candidate.toString(), candidate.toString(), meta));
        }
    }

    private CursorArgument parseCursorArgument(String buffer, int cursor) {
        ArgumentCompleter.ArgumentList argumentList;
        String cursorArgument;
        String buf;
        CursorArgument result = new CursorArgument();
        if (buffer != null && buffer.length() >= cursor && StringUtils.isNotBlank((CharSequence)(buf = buffer.substring(0, cursor))) && (cursorArgument = (argumentList = this.sqlDelimiter.delimit((CharSequence)buf, cursor)).getCursorArgument()) != null) {
            int pointPos1 = cursorArgument.indexOf(46);
            int pointPos2 = cursorArgument.indexOf(46, pointPos1 + 1);
            if (pointPos1 > -1) {
                result.setSchema(cursorArgument.substring(0, pointPos1).trim());
                if (pointPos2 > -1) {
                    result.setTable(cursorArgument.substring(pointPos1 + 1, pointPos2));
                    result.setColumn(cursorArgument.substring(pointPos2 + 1));
                    result.setCursorPosition(cursor - pointPos2 - 1);
                } else {
                    result.setTable(cursorArgument.substring(pointPos1 + 1));
                    result.setCursorPosition(cursor - pointPos1 - 1);
                }
            }
        }
        return result;
    }

    private class CursorArgument {
        private String schema;
        private String table;
        private String column;
        private int cursorPosition;

        private CursorArgument() {
        }

        public String getSchema() {
            return this.schema;
        }

        public void setSchema(String schema) {
            this.schema = schema;
        }

        public String getTable() {
            return this.table;
        }

        public void setTable(String table) {
            this.table = table;
        }

        public String getColumn() {
            return this.column;
        }

        public void setColumn(String column) {
            this.column = column;
        }

        public int getCursorPosition() {
            return this.cursorPosition;
        }

        public void setCursorPosition(int cursorPosition) {
            this.cursorPosition = cursorPosition;
        }

        public boolean needLoadSchemas() {
            return this.table == null && this.column == null;
        }

        public boolean needLoadTables() {
            return this.schema != null && this.table != null && this.column == null;
        }

        public boolean needLoadColumns() {
            return this.schema != null && this.table != null && this.column != null;
        }
    }
}

