/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jdbc;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.jdbc.SqlCompleter;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCInterpreter
extends Interpreter {
    private Logger logger = LoggerFactory.getLogger(JDBCInterpreter.class);
    static final String COMMON_KEY = "common";
    static final String MAX_LINE_KEY = "max_count";
    static final String MAX_LINE_DEFAULT = "1000";
    static final String DEFAULT_KEY = "default";
    static final String DRIVER_KEY = "driver";
    static final String URL_KEY = "url";
    static final String USER_KEY = "user";
    static final String PASSWORD_KEY = "password";
    static final String DOT = ".";
    private static final char WHITESPACE = ' ';
    private static final char NEWLINE = '\n';
    private static final char TAB = '\t';
    private static final String TABLE_MAGIC_TAG = "%table ";
    private static final String EXPLAIN_PREDICATE = "EXPLAIN ";
    private static final String UPDATE_COUNT_HEADER = "Update Count";
    static final String COMMON_MAX_LINE = "common.max_count";
    static final String DEFAULT_DRIVER = "default.driver";
    static final String DEFAULT_URL = "default.url";
    static final String DEFAULT_USER = "default.user";
    static final String DEFAULT_PASSWORD = "default.password";
    static final String EMPTY_COLUMN_VALUE = "";
    private final String CONCURRENT_EXECUTION_KEY = "zeppelin.jdbc.concurrent.use";
    private final String CONCURRENT_EXECUTION_COUNT = "zeppelin.jdbc.concurrent.max_connection";
    private final HashMap<String, Properties> propertiesMap = new HashMap();
    private final Map<String, Statement> paragraphIdStatementMap;
    private final Map<String, ArrayList<Connection>> propertyKeyUnusedConnectionListMap = new HashMap<String, ArrayList<Connection>>();
    private final Map<String, Connection> paragraphIdConnectionMap;
    private final Map<String, SqlCompleter> propertyKeySqlCompleterMap;
    private static final Function<CharSequence, String> sequenceToStringTransformer = new Function<CharSequence, String>(){

        public String apply(CharSequence seq) {
            return seq.toString();
        }
    };
    private static final List<InterpreterCompletion> NO_COMPLETION = new ArrayList<InterpreterCompletion>();

    public JDBCInterpreter(Properties property) {
        super(property);
        this.paragraphIdStatementMap = new HashMap<String, Statement>();
        this.paragraphIdConnectionMap = new HashMap<String, Connection>();
        this.propertyKeySqlCompleterMap = new HashMap<String, SqlCompleter>();
    }

    public HashMap<String, Properties> getPropertiesMap() {
        return this.propertiesMap;
    }

    public void open() {
        for (String propertyKey : this.property.stringPropertyNames()) {
            Properties prefixProperties;
            this.logger.debug("propertyKey: {}", (Object)propertyKey);
            String[] keyValue = propertyKey.split("\\.", 2);
            if (2 != keyValue.length) continue;
            this.logger.info("key: {}, value: {}", (Object)keyValue[0], (Object)keyValue[1]);
            if (this.propertiesMap.containsKey(keyValue[0])) {
                prefixProperties = this.propertiesMap.get(keyValue[0]);
            } else {
                prefixProperties = new Properties();
                this.propertiesMap.put(keyValue[0], prefixProperties);
            }
            prefixProperties.put(keyValue[1], this.property.getProperty(propertyKey));
        }
        HashSet<String> removeKeySet = new HashSet<String>();
        for (String key : this.propertiesMap.keySet()) {
            Properties properties;
            if (COMMON_KEY.equals(key) || (properties = this.propertiesMap.get(key)).containsKey(DRIVER_KEY) && properties.containsKey(URL_KEY)) continue;
            this.logger.error("{} will be ignored. {}.{} and {}.{} is mandatory.", new Object[]{key, DRIVER_KEY, key, key, URL_KEY});
            removeKeySet.add(key);
        }
        for (String key : removeKeySet) {
            this.propertiesMap.remove(key);
        }
        this.logger.debug("propertiesMap: {}", this.propertiesMap);
        Connection connection = null;
        SqlCompleter sqlCompleter = null;
        for (String propertyKey : this.propertiesMap.keySet()) {
            try {
                connection = this.getConnection(propertyKey);
                sqlCompleter = this.createSqlCompleter(connection);
            }
            catch (Exception e) {
                sqlCompleter = this.createSqlCompleter(null);
            }
            this.propertyKeySqlCompleterMap.put(propertyKey, sqlCompleter);
        }
    }

    private SqlCompleter createSqlCompleter(Connection jdbcConnection) {
        SqlCompleter completer = null;
        try {
            Set<String> keywordsCompletions = SqlCompleter.getSqlKeywordsCompletions(jdbcConnection);
            Set<String> dataModelCompletions = SqlCompleter.getDataModelMetadataCompletions(jdbcConnection);
            Sets.SetView allCompletions = Sets.union(keywordsCompletions, dataModelCompletions);
            completer = new SqlCompleter((Set<String>)allCompletions, dataModelCompletions);
        }
        catch (IOException | SQLException e) {
            this.logger.error("Cannot create SQL completer", (Throwable)e);
        }
        return completer;
    }

    public Connection getConnection(String propertyKey) throws ClassNotFoundException, SQLException {
        ArrayList<Connection> connectionList;
        Connection connection = null;
        if (propertyKey == null || this.propertiesMap.get(propertyKey) == null) {
            return null;
        }
        if (this.propertyKeyUnusedConnectionListMap.containsKey(propertyKey) && 0 != (connectionList = this.propertyKeyUnusedConnectionListMap.get(propertyKey)).size() && null != (connection = this.propertyKeyUnusedConnectionListMap.get(propertyKey).remove(0)) && connection.isClosed()) {
            connection.close();
            connection = null;
        }
        if (null == connection) {
            Properties properties = this.propertiesMap.get(propertyKey);
            this.logger.info(properties.getProperty(DRIVER_KEY));
            Class.forName(properties.getProperty(DRIVER_KEY));
            String url = properties.getProperty(URL_KEY);
            connection = DriverManager.getConnection(url, properties);
        }
        return connection;
    }

    public Statement getStatement(String propertyKey, String paragraphId) throws SQLException, ClassNotFoundException {
        Connection connection = this.paragraphIdConnectionMap.containsKey(paragraphId) ? this.paragraphIdConnectionMap.get(paragraphId) : this.getConnection(propertyKey);
        if (connection == null) {
            return null;
        }
        Statement statement = connection.createStatement();
        if (this.isStatementClosed(statement)) {
            connection = this.getConnection(propertyKey);
            statement = connection.createStatement();
        }
        this.paragraphIdConnectionMap.put(paragraphId, connection);
        this.paragraphIdStatementMap.put(paragraphId, statement);
        return statement;
    }

    private boolean isStatementClosed(Statement statement) {
        try {
            return statement.isClosed();
        }
        catch (Throwable t) {
            this.logger.debug("{} doesn't support isClosed method", (Object)statement);
            return false;
        }
    }

    public void close() {
        try {
            for (List list : this.propertyKeyUnusedConnectionListMap.values()) {
                for (Connection c : list) {
                    try {
                        c.close();
                    }
                    catch (Exception e) {
                        this.logger.error("Error while closing propertyKeyUnusedConnectionListMap connection...", (Throwable)e);
                    }
                }
            }
            for (Statement statement : this.paragraphIdStatementMap.values()) {
                try {
                    statement.close();
                }
                catch (Exception e) {
                    this.logger.error("Error while closing paragraphIdStatementMap statement...", (Throwable)e);
                }
            }
            this.paragraphIdStatementMap.clear();
            for (Connection connection : this.paragraphIdConnectionMap.values()) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    this.logger.error("Error while closing paragraphIdConnectionMap connection...", (Throwable)e);
                }
            }
            this.paragraphIdConnectionMap.clear();
        }
        catch (Exception e) {
            this.logger.error("Error while closing...", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InterpreterResult executeSql(String propertyKey, String sql, InterpreterContext interpreterContext) {
        String paragraphId = interpreterContext.getParagraphId();
        try {
            Statement statement = this.getStatement(propertyKey, paragraphId);
            if (statement == null) {
                return new InterpreterResult(InterpreterResult.Code.ERROR, "Prefix not found.");
            }
            statement.setMaxRows(this.getMaxResult());
            StringBuilder msg = null;
            boolean isTableType = false;
            if (StringUtils.containsIgnoreCase((String)sql, (String)EXPLAIN_PREDICATE)) {
                msg = new StringBuilder();
            } else {
                msg = new StringBuilder(TABLE_MAGIC_TAG);
                isTableType = true;
            }
            ResultSet resultSet = null;
            try {
                boolean isResultSetAvailable = statement.execute(sql);
                if (isResultSetAvailable) {
                    resultSet = statement.getResultSet();
                    ResultSetMetaData md = resultSet.getMetaData();
                    for (int i = 1; i < md.getColumnCount() + 1; ++i) {
                        if (i > 1) {
                            msg.append('\t');
                        }
                        msg.append(this.replaceReservedChars(isTableType, md.getColumnName(i)));
                    }
                    msg.append('\n');
                    for (int displayRowCount = 0; resultSet.next() && displayRowCount < this.getMaxResult(); ++displayRowCount) {
                        for (int i = 1; i < md.getColumnCount() + 1; ++i) {
                            Object resultObject = resultSet.getObject(i);
                            String resultValue = resultObject == null ? "null" : resultSet.getString(i);
                            msg.append(this.replaceReservedChars(isTableType, resultValue));
                            if (i == md.getColumnCount()) continue;
                            msg.append('\t');
                        }
                        msg.append('\n');
                    }
                } else {
                    int updateCount = statement.getUpdateCount();
                    msg.append(UPDATE_COUNT_HEADER).append('\n');
                    msg.append(updateCount).append('\n');
                }
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    statement.close();
                }
                finally {
                    statement = null;
                }
            }
            return new InterpreterResult(InterpreterResult.Code.SUCCESS, msg.toString());
        }
        catch (Exception e) {
            this.logger.error("Cannot run " + sql, (Throwable)e);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(e.getMessage()).append("\n");
            stringBuilder.append(e.getClass().toString()).append("\n");
            stringBuilder.append(org.apache.commons.lang3.StringUtils.join((Object[])e.getStackTrace(), (String)"\n"));
            return new InterpreterResult(InterpreterResult.Code.ERROR, stringBuilder.toString());
        }
    }

    private String replaceReservedChars(boolean isTableResponseType, String str) {
        if (str == null) {
            return EMPTY_COLUMN_VALUE;
        }
        return !isTableResponseType ? str : str.replace('\t', ' ').replace('\n', ' ');
    }

    public InterpreterResult interpret(String cmd, InterpreterContext contextInterpreter) {
        this.logger.info("Run SQL command '{}'", (Object)cmd);
        String propertyKey = this.getPropertyKey(cmd);
        if (null != propertyKey && !propertyKey.equals(DEFAULT_KEY)) {
            cmd = cmd.substring(propertyKey.length() + 2);
        }
        cmd = cmd.trim();
        this.logger.info("PropertyKey: {}, SQL command: '{}'", (Object)propertyKey, (Object)cmd);
        return this.executeSql(propertyKey, cmd, contextInterpreter);
    }

    public void cancel(InterpreterContext context) {
        this.logger.info("Cancel current query statement.");
        String paragraphId = context.getParagraphId();
        try {
            this.paragraphIdStatementMap.get(paragraphId).cancel();
        }
        catch (SQLException e) {
            this.logger.error("Error while cancelling...", (Throwable)e);
        }
    }

    public String getPropertyKey(String cmd) {
        boolean firstLineIndex = cmd.startsWith("(");
        if (firstLineIndex) {
            int configStartIndex = cmd.indexOf("(");
            int configLastIndex = cmd.indexOf(")");
            if (configStartIndex != -1 && configLastIndex != -1) {
                return cmd.substring(configStartIndex + 1, configLastIndex);
            }
            return null;
        }
        return DEFAULT_KEY;
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.SIMPLE;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public Scheduler getScheduler() {
        String schedulerName = JDBCInterpreter.class.getName() + ((Object)((Object)this)).hashCode();
        return this.isConcurrentExecution() ? SchedulerFactory.singleton().createOrGetParallelScheduler(schedulerName, 10) : SchedulerFactory.singleton().createOrGetFIFOScheduler(schedulerName);
    }

    public List<InterpreterCompletion> completion(String buf, int cursor) {
        ArrayList<CharSequence> candidates = new ArrayList<CharSequence>();
        SqlCompleter sqlCompleter = this.propertyKeySqlCompleterMap.get(this.getPropertyKey(buf));
        if (sqlCompleter != null && sqlCompleter.complete(buf, cursor, candidates) >= 0) {
            List completion = Lists.transform(candidates, sequenceToStringTransformer);
            return completion;
        }
        return NO_COMPLETION;
    }

    public int getMaxResult() {
        return Integer.valueOf(this.propertiesMap.get(COMMON_KEY).getProperty(MAX_LINE_KEY, MAX_LINE_DEFAULT));
    }

    boolean isConcurrentExecution() {
        return Boolean.valueOf(this.getProperty("zeppelin.jdbc.concurrent.use"));
    }

    int getMaxConcurrentConnection() {
        try {
            return Integer.valueOf(this.getProperty("zeppelin.jdbc.concurrent.max_connection"));
        }
        catch (Exception e) {
            return 10;
        }
    }
}

