/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jdbc;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.dbcp2.PoolingDriver;
import org.apache.zeppelin.user.UsernamePassword;

public class JDBCUserConfigurations {
    private final Map<String, Statement> paragraphIdStatementMap = new HashMap<String, Statement>();
    private final Map<String, PoolingDriver> poolingDriverMap = new HashMap<String, PoolingDriver>();
    private final HashMap<String, Properties> propertiesMap = new HashMap();

    public void initStatementMap() throws SQLException {
        for (Statement statement : this.paragraphIdStatementMap.values()) {
            statement.close();
        }
        this.paragraphIdStatementMap.clear();
    }

    public void initConnectionPoolMap() throws SQLException {
        Iterator<String> it = this.poolingDriverMap.keySet().iterator();
        while (it.hasNext()) {
            String driverName = it.next();
            this.poolingDriverMap.get(driverName).closePool(driverName);
            it.remove();
        }
        this.poolingDriverMap.clear();
    }

    public void setPropertyMap(String key, Properties properties) {
        Properties p = (Properties)properties.clone();
        this.propertiesMap.put(key, p);
    }

    public Properties getPropertyMap(String key) {
        return this.propertiesMap.get(key);
    }

    public void cleanUserProperty(String propertyKey) {
        this.propertiesMap.get(propertyKey).remove("user");
        this.propertiesMap.get(propertyKey).remove("password");
    }

    public void setUserProperty(String propertyKey, UsernamePassword usernamePassword) {
        this.propertiesMap.get(propertyKey).setProperty("user", usernamePassword.getUsername());
        this.propertiesMap.get(propertyKey).setProperty("password", usernamePassword.getPassword());
    }

    public void saveStatement(String key, Statement statement) throws SQLException {
        this.paragraphIdStatementMap.put(key, statement);
    }

    public void cancelStatement(String key) throws SQLException {
        this.paragraphIdStatementMap.get(key).cancel();
    }

    public void removeStatement(String key) {
        this.paragraphIdStatementMap.remove(key);
    }

    public void saveDBDriverPool(String key, PoolingDriver driver) throws SQLException {
        this.poolingDriverMap.put(key, driver);
    }

    public PoolingDriver removeDBDriverPool(String key) throws SQLException {
        return this.poolingDriverMap.remove(key);
    }

    public boolean isConnectionInDBDriverPool(String key) {
        return this.poolingDriverMap.containsKey(key);
    }
}

