/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jdbc.security;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCSecurityImpl {
    private static Logger LOGGER = LoggerFactory.getLogger(JDBCSecurityImpl.class);

    public static void createSecureConfiguration(Properties properties) {
        UserGroupInformation.AuthenticationMethod authType = JDBCSecurityImpl.getAuthtype(properties);
        switch (authType) {
            case KERBEROS: {
                Configuration conf = new Configuration();
                conf.set("hadoop.security.authentication", UserGroupInformation.AuthenticationMethod.KERBEROS.toString());
                UserGroupInformation.setConfiguration((Configuration)conf);
                try {
                    UserGroupInformation.loginUserFromKeytab((String)properties.getProperty("zeppelin.jdbc.principal"), (String)properties.getProperty("zeppelin.jdbc.keytab.location"));
                    break;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to get either keytab location or principal name in the interpreter", (Throwable)e);
                }
            }
        }
    }

    public static UserGroupInformation.AuthenticationMethod getAuthtype(Properties properties) {
        UserGroupInformation.AuthenticationMethod authType;
        try {
            authType = UserGroupInformation.AuthenticationMethod.valueOf((String)properties.getProperty("zeppelin.jdbc.auth.type").trim().toUpperCase());
        }
        catch (Exception e) {
            LOGGER.error(String.format("Invalid auth.type detected with value %s, defaulting auth.type to SIMPLE", properties.getProperty("zeppelin.jdbc.auth.type")));
            authType = UserGroupInformation.AuthenticationMethod.SIMPLE;
        }
        return authType;
    }
}

