/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jdbc;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Pattern;
import jline.console.completer.ArgumentCompleter;
import jline.console.completer.StringsCompleter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlCompleter
extends StringsCompleter {
    private static Logger logger = LoggerFactory.getLogger(SqlCompleter.class);
    private ArgumentCompleter.WhitespaceArgumentDelimiter sqlDelimiter = new ArgumentCompleter.WhitespaceArgumentDelimiter(){
        private Pattern pattern = Pattern.compile("[\\.:;,]");

        public boolean isDelimiterChar(CharSequence buffer, int pos) {
            return this.pattern.matcher("" + buffer.charAt(pos)).matches() || super.isDelimiterChar(buffer, pos);
        }
    };
    private Set<String> modelCompletions = new HashSet<String>();

    public SqlCompleter(Set<String> allCompletions, Set<String> dataModelCompletions) {
        super(allCompletions);
        this.modelCompletions = dataModelCompletions;
    }

    public int complete(String buffer, int cursor, List<CharSequence> candidates) {
        if (StringUtils.isBlank((String)buffer) || cursor > buffer.length() + 1) {
            return -1;
        }
        ArgumentCompleter.ArgumentList argumentList = this.sqlDelimiter.delimit((CharSequence)buffer, cursor);
        String argument = argumentList.getCursorArgument();
        int argumentPosition = argumentList.getArgumentPosition();
        if (StringUtils.isBlank((String)argument)) {
            int argumentsCount = argumentList.getArguments().length;
            if (argumentsCount <= 0 || buffer.length() + 2 < cursor || this.sqlDelimiter.isDelimiterChar((CharSequence)buffer, cursor - 2)) {
                return -1;
            }
            argument = argumentList.getArguments()[argumentsCount - 1];
            argumentPosition = argument.length();
        }
        int complete = super.complete(argument, argumentPosition, candidates);
        logger.debug("complete:" + complete + ", size:" + candidates.size());
        return complete;
    }

    public void updateDataModelMetaData(Connection connection) {
        try {
            Set<String> newModelCompletions = SqlCompleter.getDataModelMetadataCompletions(connection);
            logger.debug("New model metadata is:" + Joiner.on((char)',').join(newModelCompletions));
            Sets.SetView removedCompletions = Sets.difference(this.modelCompletions, newModelCompletions);
            logger.debug("Removed Model Completions: " + Joiner.on((char)',').join((Iterable)removedCompletions));
            this.getStrings().removeAll((Collection<?>)removedCompletions);
            Sets.SetView newCompletions = Sets.difference(newModelCompletions, this.modelCompletions);
            logger.debug("New Completions: " + Joiner.on((char)',').join((Iterable)newCompletions));
            this.getStrings().addAll(newCompletions);
            this.modelCompletions = newModelCompletions;
        }
        catch (SQLException e) {
            logger.error("Failed to update the metadata conmpletions", (Throwable)e);
        }
    }

    public static Set<String> getSqlKeywordsCompletions(Connection connection) throws IOException, SQLException {
        String keywords = new BufferedReader(new InputStreamReader(SqlCompleter.class.getResourceAsStream("/ansi.sql.keywords"))).readLine();
        TreeSet<String> completions = new TreeSet<String>();
        if (null != connection) {
            DatabaseMetaData metaData = connection.getMetaData();
            String driverSpecificKeywords = "/" + metaData.getDriverName().replace(" ", "-").toLowerCase() + "-sql.keywords";
            logger.info("JDBC DriverName:" + driverSpecificKeywords);
            if (SqlCompleter.class.getResource(driverSpecificKeywords) != null) {
                String driverKeywords = new BufferedReader(new InputStreamReader(SqlCompleter.class.getResourceAsStream(driverSpecificKeywords))).readLine();
                keywords = keywords + "," + driverKeywords.toUpperCase();
            }
            try {
                keywords = keywords + "," + metaData.getSQLKeywords();
            }
            catch (Exception e) {
                logger.debug("fail to get SQL key words from database metadata: " + e, (Throwable)e);
            }
            try {
                keywords = keywords + "," + metaData.getStringFunctions();
            }
            catch (Exception e) {
                logger.debug("fail to get string function names from database metadata: " + e, (Throwable)e);
            }
            try {
                keywords = keywords + "," + metaData.getNumericFunctions();
            }
            catch (Exception e) {
                logger.debug("fail to get numeric function names from database metadata: " + e, (Throwable)e);
            }
            try {
                keywords = keywords + "," + metaData.getSystemFunctions();
            }
            catch (Exception e) {
                logger.debug("fail to get system function names from database metadata: " + e, (Throwable)e);
            }
            try {
                keywords = keywords + "," + metaData.getTimeDateFunctions();
            }
            catch (Exception e) {
                logger.debug("fail to get time date function names from database metadata: " + e, (Throwable)e);
            }
            keywords = keywords + "," + keywords.toLowerCase();
        }
        StringTokenizer tok = new StringTokenizer(keywords, ", ");
        while (tok.hasMoreTokens()) {
            completions.add(tok.nextToken());
        }
        return completions;
    }

    public static Set<String> getDataModelMetadataCompletions(Connection connection) throws SQLException {
        TreeSet<String> completions = new TreeSet<String>();
        if (null != connection) {
            SqlCompleter.getColumnNames(connection.getMetaData(), completions);
            SqlCompleter.getSchemaNames(connection.getMetaData(), completions);
        }
        return completions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getColumnNames(DatabaseMetaData meta, Set<String> names) throws SQLException {
        try {
            try (ResultSet columns = meta.getColumns(meta.getConnection().getCatalog(), null, "%", "%");){
                while (columns.next()) {
                    String name = columns.getString("TABLE_NAME");
                    if (StringUtils.isBlank((String)name)) continue;
                    names.add(name);
                    names.add(columns.getString("COLUMN_NAME"));
                }
            }
            logger.debug(Joiner.on((char)',').join(names));
        }
        catch (Exception e) {
            logger.error("Failed to retrieve the column name", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getSchemaNames(DatabaseMetaData meta, Set<String> names) throws SQLException {
        try (ResultSet schemas = meta.getSchemas();){
            while (schemas.next()) {
                String schemaName = schemas.getString("TABLE_SCHEM");
                if (schemaName == null) {
                    schemaName = "";
                }
                if (StringUtils.isBlank((String)schemaName)) continue;
                names.add(schemaName + ".");
            }
        }
        catch (Exception e) {
            logger.error("Failed to retrieve the column name", (Throwable)e);
        }
    }

    ArgumentCompleter.WhitespaceArgumentDelimiter getSqlDelimiter() {
        return this.sqlDelimiter;
    }
}

