/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jdbc;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverManagerConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDriver;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.apache.thrift.transport.TTransportException;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.jdbc.JDBCUserConfigurations;
import org.apache.zeppelin.jdbc.SqlCompleter;
import org.apache.zeppelin.jdbc.security.JDBCSecurityImpl;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.apache.zeppelin.user.UserCredentials;
import org.apache.zeppelin.user.UsernamePassword;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCInterpreter
extends Interpreter {
    private Logger logger = LoggerFactory.getLogger(JDBCInterpreter.class);
    static final String INTERPRETER_NAME = "jdbc";
    static final String COMMON_KEY = "common";
    static final String MAX_LINE_KEY = "max_count";
    static final int MAX_LINE_DEFAULT = 1000;
    static final String DEFAULT_KEY = "default";
    static final String DRIVER_KEY = "driver";
    static final String URL_KEY = "url";
    static final String USER_KEY = "user";
    static final String PASSWORD_KEY = "password";
    static final String JDBC_JCEKS_FILE = "jceks.file";
    static final String JDBC_JCEKS_CREDENTIAL_KEY = "jceks.credentialKey";
    static final String DOT = ".";
    private static final char WHITESPACE = ' ';
    private static final char NEWLINE = '\n';
    private static final char TAB = '\t';
    private static final String TABLE_MAGIC_TAG = "%table ";
    private static final String EXPLAIN_PREDICATE = "EXPLAIN ";
    static final String COMMON_MAX_LINE = "common.max_count";
    static final String DEFAULT_DRIVER = "default.driver";
    static final String DEFAULT_URL = "default.url";
    static final String DEFAULT_USER = "default.user";
    static final String DEFAULT_PASSWORD = "default.password";
    static final String EMPTY_COLUMN_VALUE = "";
    private final String CONCURRENT_EXECUTION_KEY = "zeppelin.jdbc.concurrent.use";
    private final String CONCURRENT_EXECUTION_COUNT = "zeppelin.jdbc.concurrent.max_connection";
    private final String DBCP_STRING = "jdbc:apache:commons:dbcp:";
    private final HashMap<String, Properties> basePropretiesMap;
    private final HashMap<String, JDBCUserConfigurations> jdbcUserConfigurationsMap = new HashMap();
    private final Map<String, SqlCompleter> propertyKeySqlCompleterMap = new HashMap<String, SqlCompleter>();
    private static final Function<CharSequence, InterpreterCompletion> sequenceToStringTransformer = new Function<CharSequence, InterpreterCompletion>(){

        public InterpreterCompletion apply(CharSequence seq) {
            return new InterpreterCompletion(seq.toString(), seq.toString());
        }
    };
    private static final List<InterpreterCompletion> NO_COMPLETION = new ArrayList<InterpreterCompletion>();
    private int maxLineResults = 1000;

    public JDBCInterpreter(Properties property) {
        super(property);
        this.basePropretiesMap = new HashMap();
    }

    public HashMap<String, Properties> getPropertiesMap() {
        return this.basePropretiesMap;
    }

    public void open() {
        for (String propertyKey : this.property.stringPropertyNames()) {
            Properties prefixProperties;
            this.logger.debug("propertyKey: {}", (Object)propertyKey);
            String[] keyValue = propertyKey.split("\\.", 2);
            if (2 != keyValue.length) continue;
            this.logger.debug("key: {}, value: {}", (Object)keyValue[0], (Object)keyValue[1]);
            if (this.basePropretiesMap.containsKey(keyValue[0])) {
                prefixProperties = this.basePropretiesMap.get(keyValue[0]);
            } else {
                prefixProperties = new Properties();
                this.basePropretiesMap.put(keyValue[0].trim(), prefixProperties);
            }
            prefixProperties.put(keyValue[1].trim(), this.property.getProperty(propertyKey));
        }
        HashSet<String> removeKeySet = new HashSet<String>();
        for (String key : this.basePropretiesMap.keySet()) {
            Properties properties;
            if (COMMON_KEY.equals(key) || (properties = this.basePropretiesMap.get(key)).containsKey(DRIVER_KEY) && properties.containsKey(URL_KEY)) continue;
            this.logger.error("{} will be ignored. {}.{} and {}.{} is mandatory.", new Object[]{key, DRIVER_KEY, key, key, URL_KEY});
            removeKeySet.add(key);
        }
        for (String key : removeKeySet) {
            this.basePropretiesMap.remove(key);
        }
        this.logger.debug("JDBC PropretiesMap: {}", this.basePropretiesMap);
        if (!StringUtils.isEmpty((String)this.property.getProperty("zeppelin.jdbc.auth.type"))) {
            JDBCSecurityImpl.createSecureConfiguration(this.property);
        }
        for (String propertyKey : this.basePropretiesMap.keySet()) {
            this.propertyKeySqlCompleterMap.put(propertyKey, this.createSqlCompleter(null));
        }
        this.setMaxLineResults();
    }

    private void setMaxLineResults() {
        if (this.basePropretiesMap.containsKey(COMMON_KEY) && this.basePropretiesMap.get(COMMON_KEY).containsKey(MAX_LINE_KEY)) {
            this.maxLineResults = Integer.valueOf(this.basePropretiesMap.get(COMMON_KEY).getProperty(MAX_LINE_KEY));
        }
    }

    private SqlCompleter createSqlCompleter(Connection jdbcConnection) {
        SqlCompleter completer = null;
        try {
            Set<String> keywordsCompletions = SqlCompleter.getSqlKeywordsCompletions(jdbcConnection);
            Set<String> dataModelCompletions = SqlCompleter.getDataModelMetadataCompletions(jdbcConnection);
            Sets.SetView allCompletions = Sets.union(keywordsCompletions, dataModelCompletions);
            completer = new SqlCompleter((Set<String>)allCompletions, dataModelCompletions);
        }
        catch (IOException | SQLException e) {
            this.logger.error("Cannot create SQL completer", (Throwable)e);
        }
        return completer;
    }

    private void initStatementMap() {
        for (JDBCUserConfigurations configurations : this.jdbcUserConfigurationsMap.values()) {
            try {
                configurations.initStatementMap();
            }
            catch (Exception e) {
                this.logger.error("Error while closing paragraphIdStatementMap statement...", (Throwable)e);
            }
        }
    }

    private void initConnectionPoolMap() {
        for (String key : this.jdbcUserConfigurationsMap.keySet()) {
            try {
                this.closeDBPool(key, DEFAULT_KEY);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                JDBCUserConfigurations configurations = this.jdbcUserConfigurationsMap.get(key);
                configurations.initConnectionPoolMap();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void close() {
        try {
            this.initStatementMap();
            this.initConnectionPoolMap();
        }
        catch (Exception e) {
            this.logger.error("Error while closing...", (Throwable)e);
        }
    }

    private String getEntityName(String replName) {
        StringBuffer entityName = new StringBuffer();
        entityName.append(INTERPRETER_NAME);
        entityName.append(DOT);
        entityName.append(replName);
        return entityName.toString();
    }

    private String getJDBCDriverName(String user, String propertyKey) {
        StringBuffer driverName = new StringBuffer();
        driverName.append("jdbc:apache:commons:dbcp:");
        driverName.append(propertyKey);
        driverName.append(user);
        return driverName.toString();
    }

    private boolean existAccountInBaseProperty(String propertyKey) {
        return this.basePropretiesMap.get(propertyKey).containsKey(USER_KEY) && !StringUtils.isEmpty((String)((String)this.basePropretiesMap.get(propertyKey).get(USER_KEY))) && this.basePropretiesMap.get(propertyKey).containsKey(PASSWORD_KEY);
    }

    private UsernamePassword getUsernamePassword(InterpreterContext interpreterContext, String replName) {
        UserCredentials uc = interpreterContext.getAuthenticationInfo().getUserCredentials();
        if (uc != null) {
            return uc.getUsernamePassword(replName);
        }
        return null;
    }

    public JDBCUserConfigurations getJDBCConfiguration(String user) {
        JDBCUserConfigurations jdbcUserConfigurations = this.jdbcUserConfigurationsMap.get(user);
        if (jdbcUserConfigurations == null) {
            jdbcUserConfigurations = new JDBCUserConfigurations();
            this.jdbcUserConfigurationsMap.put(user, jdbcUserConfigurations);
        }
        return jdbcUserConfigurations;
    }

    private void closeDBPool(String user, String propertyKey) throws SQLException {
        PoolingDriver poolingDriver = this.getJDBCConfiguration(user).removeDBDriverPool(propertyKey);
        if (poolingDriver != null) {
            poolingDriver.closePool(propertyKey + user);
        }
    }

    private void setUserProperty(String propertyKey, InterpreterContext interpreterContext) throws SQLException, IOException {
        String password;
        String user = interpreterContext.getAuthenticationInfo().getUser();
        JDBCUserConfigurations jdbcUserConfigurations = this.getJDBCConfiguration(user);
        if (this.basePropretiesMap.get(propertyKey).containsKey(USER_KEY) && !this.basePropretiesMap.get(propertyKey).getProperty(USER_KEY).isEmpty() && !StringUtils.isEmpty((String)(password = this.getPassword(this.basePropretiesMap.get(propertyKey))))) {
            this.basePropretiesMap.get(propertyKey).setProperty(PASSWORD_KEY, password);
        }
        jdbcUserConfigurations.setPropertyMap(propertyKey, this.basePropretiesMap.get(propertyKey));
        if (this.existAccountInBaseProperty(propertyKey)) {
            return;
        }
        jdbcUserConfigurations.cleanUserProperty(propertyKey);
        UsernamePassword usernamePassword = this.getUsernamePassword(interpreterContext, this.getEntityName(interpreterContext.getReplName()));
        if (usernamePassword != null) {
            jdbcUserConfigurations.setUserProperty(propertyKey, usernamePassword);
        } else {
            this.closeDBPool(user, propertyKey);
        }
    }

    private void createConnectionPool(String url, String user, String propertyKey, Properties properties) throws SQLException, ClassNotFoundException {
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(url, properties);
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, null);
        GenericObjectPool connectionPool = new GenericObjectPool((PooledObjectFactory)poolableConnectionFactory);
        poolableConnectionFactory.setPool((ObjectPool)connectionPool);
        Class.forName(properties.getProperty(DRIVER_KEY));
        PoolingDriver driver = new PoolingDriver();
        driver.registerPool(propertyKey + user, (ObjectPool)connectionPool);
        this.getJDBCConfiguration(user).saveDBDriverPool(propertyKey, driver);
    }

    private Connection getConnectionFromPool(String url, String user, String propertyKey, Properties properties) throws SQLException, ClassNotFoundException {
        String jdbcDriver = this.getJDBCDriverName(user, propertyKey);
        if (!this.getJDBCConfiguration(user).isConnectionInDBDriverPool(propertyKey)) {
            this.createConnectionPool(url, user, propertyKey, properties);
        }
        return DriverManager.getConnection(jdbcDriver);
    }

    public Connection getConnection(String propertyKey, InterpreterContext interpreterContext) throws ClassNotFoundException, SQLException, InterpreterException, IOException {
        final String user = interpreterContext.getAuthenticationInfo().getUser();
        Connection connection = null;
        if (propertyKey == null || this.basePropretiesMap.get(propertyKey) == null) {
            return null;
        }
        JDBCUserConfigurations jdbcUserConfigurations = this.getJDBCConfiguration(user);
        this.setUserProperty(propertyKey, interpreterContext);
        final Properties properties = jdbcUserConfigurations.getPropertyMap(propertyKey);
        final String url = properties.getProperty(URL_KEY);
        if (StringUtils.isEmpty((String)this.property.getProperty("zeppelin.jdbc.auth.type"))) {
            connection = this.getConnectionFromPool(url, user, propertyKey, properties);
        } else {
            UserGroupInformation.AuthenticationMethod authType = JDBCSecurityImpl.getAuthtype(this.property);
            switch (authType) {
                case KERBEROS: {
                    if (user == null || "false".equalsIgnoreCase(this.property.getProperty("zeppelin.jdbc.auth.kerberos.proxy.enable"))) {
                        connection = this.getConnectionFromPool(url, user, propertyKey, properties);
                        break;
                    }
                    if (url.trim().startsWith("jdbc:hive")) {
                        StringBuilder connectionUrl = new StringBuilder(url);
                        Integer lastIndexOfUrl = connectionUrl.indexOf("?");
                        if (lastIndexOfUrl == -1) {
                            lastIndexOfUrl = connectionUrl.length();
                        }
                        connectionUrl.insert((int)lastIndexOfUrl, ";hive.server2.proxy.user=" + user + ";");
                        connection = this.getConnectionFromPool(connectionUrl.toString(), user, propertyKey, properties);
                        break;
                    }
                    UserGroupInformation ugi = null;
                    try {
                        ugi = UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)UserGroupInformation.getCurrentUser());
                    }
                    catch (Exception e) {
                        this.logger.error("Error in createProxyUser", (Throwable)e);
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(e.getMessage()).append("\n");
                        stringBuilder.append(e.getCause());
                        throw new InterpreterException(stringBuilder.toString());
                    }
                    final String poolKey = propertyKey;
                    try {
                        connection = (Connection)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Connection>(){

                            @Override
                            public Connection run() throws Exception {
                                return JDBCInterpreter.this.getConnectionFromPool(url, user, poolKey, properties);
                            }
                        });
                        break;
                    }
                    catch (Exception e) {
                        this.logger.error("Error in doAs", (Throwable)e);
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(e.getMessage()).append("\n");
                        stringBuilder.append(e.getCause());
                        throw new InterpreterException(stringBuilder.toString());
                    }
                }
                default: {
                    connection = this.getConnectionFromPool(url, user, propertyKey, properties);
                }
            }
        }
        this.propertyKeySqlCompleterMap.put(propertyKey, this.createSqlCompleter(connection));
        return connection;
    }

    private String getPassword(Properties properties) throws IOException {
        if (StringUtils.isNotEmpty((String)properties.getProperty(PASSWORD_KEY))) {
            return properties.getProperty(PASSWORD_KEY);
        }
        if (StringUtils.isNotEmpty((String)properties.getProperty(JDBC_JCEKS_FILE)) && StringUtils.isNotEmpty((String)properties.getProperty(JDBC_JCEKS_CREDENTIAL_KEY))) {
            try {
                Configuration configuration = new Configuration();
                configuration.set("hadoop.security.credential.provider.path", properties.getProperty(JDBC_JCEKS_FILE));
                CredentialProvider provider = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)configuration).get(0);
                CredentialProvider.CredentialEntry credEntry = provider.getCredentialEntry(properties.getProperty(JDBC_JCEKS_CREDENTIAL_KEY));
                if (credEntry != null) {
                    return new String(credEntry.getCredential());
                }
                throw new InterpreterException("Failed to retrieve password from JCEKS from key: " + properties.getProperty(JDBC_JCEKS_CREDENTIAL_KEY));
            }
            catch (Exception e) {
                this.logger.error("Failed to retrieve password from JCEKS \nFor file: " + properties.getProperty(JDBC_JCEKS_FILE) + "\nFor key: " + properties.getProperty(JDBC_JCEKS_CREDENTIAL_KEY), (Throwable)e);
                throw e;
            }
        }
        return null;
    }

    private String getResults(ResultSet resultSet, boolean isTableType) throws SQLException {
        ResultSetMetaData md = resultSet.getMetaData();
        StringBuilder msg = isTableType ? new StringBuilder(TABLE_MAGIC_TAG) : new StringBuilder();
        for (int i = 1; i < md.getColumnCount() + 1; ++i) {
            if (i > 1) {
                msg.append('\t');
            }
            msg.append(this.replaceReservedChars(md.getColumnName(i)));
        }
        msg.append('\n');
        for (int displayRowCount = 0; resultSet.next() && displayRowCount < this.getMaxResult(); ++displayRowCount) {
            for (int i = 1; i < md.getColumnCount() + 1; ++i) {
                Object resultObject = resultSet.getObject(i);
                String resultValue = resultObject == null ? "null" : resultSet.getString(i);
                msg.append(this.replaceReservedChars(resultValue));
                if (i == md.getColumnCount()) continue;
                msg.append('\t');
            }
            msg.append('\n');
        }
        return msg.toString();
    }

    private boolean isDDLCommand(int updatedCount, int columnCount) throws SQLException {
        return updatedCount < 0 && columnCount <= 0;
    }

    protected ArrayList<String> splitSqlQueries(String sql) {
        ArrayList<String> queries = new ArrayList<String>();
        StringBuilder query = new StringBuilder();
        Boolean antiSlash = false;
        Boolean quoteString = false;
        Boolean doubleQuoteString = false;
        for (int item = 0; item < sql.length(); ++item) {
            Character character = Character.valueOf(sql.charAt(item));
            if (character.equals(Character.valueOf('\\'))) {
                antiSlash = true;
            }
            if (character.equals(Character.valueOf('\''))) {
                if (antiSlash.booleanValue()) {
                    antiSlash = false;
                } else if (quoteString.booleanValue()) {
                    quoteString = false;
                } else if (!doubleQuoteString.booleanValue()) {
                    quoteString = true;
                }
            }
            if (character.equals(Character.valueOf('\"'))) {
                if (antiSlash.booleanValue()) {
                    antiSlash = false;
                } else if (doubleQuoteString.booleanValue()) {
                    doubleQuoteString = false;
                } else if (!quoteString.booleanValue()) {
                    doubleQuoteString = true;
                }
            }
            if (character.equals(Character.valueOf(';')) && !antiSlash.booleanValue() && !quoteString.booleanValue() && !doubleQuoteString.booleanValue()) {
                queries.add(query.toString());
                query = new StringBuilder();
                continue;
            }
            if (item == sql.length() - 1) {
                query.append(character);
                queries.add(query.toString());
                continue;
            }
            query.append(character);
        }
        return queries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InterpreterResult executeSql(String propertyKey, String sql, InterpreterContext interpreterContext) {
        Connection connection = null;
        ResultSet resultSet = null;
        String paragraphId = interpreterContext.getParagraphId();
        String user = interpreterContext.getAuthenticationInfo().getUser();
        InterpreterResult interpreterResult = new InterpreterResult(InterpreterResult.Code.SUCCESS);
        try {
            connection = this.getConnection(propertyKey, interpreterContext);
        }
        catch (Exception e) {
            String errorMsg = Throwables.getStackTraceAsString((Throwable)e);
            try {
                this.closeDBPool(user, propertyKey);
            }
            catch (SQLException e1) {
                this.logger.error("Cannot close DBPool for user, propertyKey: " + user + propertyKey, (Throwable)e1);
            }
            interpreterResult.add(errorMsg);
            return new InterpreterResult(InterpreterResult.Code.ERROR, interpreterResult.message());
        }
        if (connection == null) {
            return new InterpreterResult(InterpreterResult.Code.ERROR, "Prefix not found.");
        }
        try {
            ArrayList<String> multipleSqlArray = this.splitSqlQueries(sql);
            for (int i = 0; i < multipleSqlArray.size(); ++i) {
                String sqlToExecute = multipleSqlArray.get(i);
                Statement statement = connection.createStatement();
                if (statement == null) {
                    InterpreterResult interpreterResult2 = new InterpreterResult(InterpreterResult.Code.ERROR, "Prefix not found.");
                    return interpreterResult2;
                }
                try {
                    this.getJDBCConfiguration(user).saveStatement(paragraphId, statement);
                    boolean isResultSetAvailable = statement.execute(sqlToExecute);
                    this.getJDBCConfiguration(user).setConnectionInDBDriverPoolSuccessful(propertyKey);
                    if (isResultSetAvailable) {
                        resultSet = statement.getResultSet();
                        if (this.isDDLCommand(statement.getUpdateCount(), resultSet.getMetaData().getColumnCount())) {
                            interpreterResult.add(InterpreterResult.Type.TEXT, "Query executed successfully.");
                            continue;
                        }
                        interpreterResult.add(this.getResults(resultSet, !StringUtils.containsIgnoreCase((String)sqlToExecute, (String)EXPLAIN_PREDICATE)));
                        continue;
                    }
                    int updateCount = statement.getUpdateCount();
                    interpreterResult.add(InterpreterResult.Type.TEXT, "Query executed successfully. Affected rows : " + updateCount);
                    continue;
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
        }
        catch (Throwable e) {
            if (e.getCause() instanceof TTransportException && Throwables.getStackTraceAsString((Throwable)e).contains("GSS") && this.getJDBCConfiguration(user).isConnectionInDBDriverPoolSuccessful(propertyKey)) {
                InterpreterResult i = this.reLoginFromKeytab(propertyKey, sql, interpreterContext, interpreterResult);
                return i;
            }
            this.logger.error("Cannot run " + sql, e);
            String errorMsg = Throwables.getStackTraceAsString((Throwable)e);
            try {
                this.closeDBPool(user, propertyKey);
            }
            catch (SQLException e1) {
                this.logger.error("Cannot close DBPool for user, propertyKey: " + user + propertyKey, (Throwable)e1);
            }
            interpreterResult.add(errorMsg);
            InterpreterResult interpreterResult3 = new InterpreterResult(InterpreterResult.Code.ERROR, interpreterResult.message());
            return interpreterResult3;
        }
        finally {
            if (connection != null) {
                try {
                    if (!connection.getAutoCommit()) {
                        connection.commit();
                    }
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
            this.getJDBCConfiguration(user).removeStatement(paragraphId);
        }
        return interpreterResult;
    }

    private InterpreterResult reLoginFromKeytab(String propertyKey, String sql, InterpreterContext interpreterContext, InterpreterResult interpreterResult) {
        String user = interpreterContext.getAuthenticationInfo().getUser();
        try {
            this.closeDBPool(user, propertyKey);
        }
        catch (SQLException e) {
            this.logger.error("Error, could not close DB pool in reLoginFromKeytab ", (Throwable)e);
        }
        UserGroupInformation.AuthenticationMethod authType = JDBCSecurityImpl.getAuthtype(this.property);
        if (authType.equals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS)) {
            try {
                if (UserGroupInformation.isLoginKeytabBased()) {
                    UserGroupInformation.getLoginUser().reloginFromKeytab();
                } else if (UserGroupInformation.isLoginTicketBased()) {
                    UserGroupInformation.getLoginUser().reloginFromTicketCache();
                }
            }
            catch (IOException e) {
                this.logger.error("Cannot reloginFromKeytab " + sql, (Throwable)e);
                interpreterResult.add(e.getMessage());
                return new InterpreterResult(InterpreterResult.Code.ERROR, interpreterResult.message());
            }
        }
        return this.executeSql(propertyKey, sql, interpreterContext);
    }

    private String replaceReservedChars(String str) {
        if (str == null) {
            return EMPTY_COLUMN_VALUE;
        }
        return str.replace('\t', ' ').replace('\n', ' ');
    }

    public InterpreterResult interpret(String cmd, InterpreterContext contextInterpreter) {
        this.logger.debug("Run SQL command '{}'", (Object)cmd);
        String propertyKey = this.getPropertyKey(cmd);
        if (null != propertyKey && !propertyKey.equals(DEFAULT_KEY)) {
            cmd = cmd.substring(propertyKey.length() + 2);
        }
        cmd = cmd.trim();
        this.logger.debug("PropertyKey: {}, SQL command: '{}'", (Object)propertyKey, (Object)cmd);
        return this.executeSql(propertyKey, cmd, contextInterpreter);
    }

    public void cancel(InterpreterContext context) {
        this.logger.info("Cancel current query statement.");
        String paragraphId = context.getParagraphId();
        JDBCUserConfigurations jdbcUserConfigurations = this.getJDBCConfiguration(context.getAuthenticationInfo().getUser());
        try {
            jdbcUserConfigurations.cancelStatement(paragraphId);
        }
        catch (SQLException e) {
            this.logger.error("Error while cancelling...", (Throwable)e);
        }
    }

    public String getPropertyKey(String cmd) {
        boolean firstLineIndex = cmd.startsWith("(");
        if (firstLineIndex) {
            int configStartIndex = cmd.indexOf("(");
            int configLastIndex = cmd.indexOf(")");
            if (configStartIndex != -1 && configLastIndex != -1) {
                return cmd.substring(configStartIndex + 1, configLastIndex);
            }
            return null;
        }
        return DEFAULT_KEY;
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.SIMPLE;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public Scheduler getScheduler() {
        String schedulerName = JDBCInterpreter.class.getName() + ((Object)((Object)this)).hashCode();
        return this.isConcurrentExecution() ? SchedulerFactory.singleton().createOrGetParallelScheduler(schedulerName, this.getMaxConcurrentConnection()) : SchedulerFactory.singleton().createOrGetFIFOScheduler(schedulerName);
    }

    public List<InterpreterCompletion> completion(String buf, int cursor) {
        ArrayList<CharSequence> candidates = new ArrayList<CharSequence>();
        SqlCompleter sqlCompleter = this.propertyKeySqlCompleterMap.get(this.getPropertyKey(buf));
        if (sqlCompleter != null && sqlCompleter.complete(buf, cursor, candidates) >= 0) {
            List completion = Lists.transform(candidates, sequenceToStringTransformer);
            return completion;
        }
        return NO_COMPLETION;
    }

    public int getMaxResult() {
        return this.maxLineResults;
    }

    boolean isConcurrentExecution() {
        return Boolean.valueOf(this.getProperty("zeppelin.jdbc.concurrent.use"));
    }

    int getMaxConcurrentConnection() {
        try {
            return Integer.valueOf(this.getProperty("zeppelin.jdbc.concurrent.max_connection"));
        }
        catch (Exception e) {
            return 10;
        }
    }
}

