/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.rest;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.zeppelin.server.JsonResponse;
import org.apache.zeppelin.user.Credentials;
import org.apache.zeppelin.user.UserCredentials;
import org.apache.zeppelin.user.UsernamePassword;
import org.apache.zeppelin.utils.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/credential")
@Produces(value={"application/json"})
public class CredentialRestApi {
    Logger logger = LoggerFactory.getLogger(CredentialRestApi.class);
    private Credentials credentials;
    private Gson gson = new Gson();
    @Context
    private HttpServletRequest servReq;

    public CredentialRestApi() {
    }

    public CredentialRestApi(Credentials credentials) {
        this.credentials = credentials;
    }

    @PUT
    public Response putCredentials(String message) throws IOException {
        Map messageMap = (Map)this.gson.fromJson(message, new TypeToken<Map<String, String>>(){}.getType());
        String entity = (String)messageMap.get("entity");
        String username = (String)messageMap.get("username");
        String password = (String)messageMap.get("password");
        if (entity == null || username == null || password == null) {
            return new JsonResponse<String>(Response.Status.BAD_REQUEST, "", "").build();
        }
        String user = SecurityUtils.getPrincipal();
        this.logger.info("Update credentials for user {} entity {}", (Object)user, (Object)entity);
        UserCredentials uc = this.credentials.getUserCredentials(user);
        uc.putUsernamePassword(entity, new UsernamePassword(username, password));
        this.credentials.putUserCredentials(user, uc);
        return new JsonResponse<String>(Response.Status.OK, "", "").build();
    }
}

