/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.rest;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.zeppelin.annotation.ZeppelinApi;
import org.apache.zeppelin.dep.Repository;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterFactory;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.rest.message.NewInterpreterSettingRequest;
import org.apache.zeppelin.rest.message.RestartInterpreterRequest;
import org.apache.zeppelin.rest.message.UpdateInterpreterSettingRequest;
import org.apache.zeppelin.server.JsonResponse;
import org.apache.zeppelin.utils.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/interpreter")
@Produces(value={"application/json"})
public class InterpreterRestApi {
    private static final Logger logger = LoggerFactory.getLogger(InterpreterRestApi.class);
    private InterpreterFactory interpreterFactory;
    Gson gson = new Gson();

    public InterpreterRestApi() {
    }

    public InterpreterRestApi(InterpreterFactory interpreterFactory) {
        this.interpreterFactory = interpreterFactory;
    }

    @GET
    @Path(value="setting")
    @ZeppelinApi
    public Response listSettings() {
        return new JsonResponse<List>(Response.Status.OK, "", this.interpreterFactory.get()).build();
    }

    @GET
    @Path(value="setting/{settingId}")
    @ZeppelinApi
    public Response getSetting(@PathParam(value="settingId") String settingId) {
        try {
            InterpreterSetting setting = this.interpreterFactory.get(settingId);
            if (setting == null) {
                return new JsonResponse(Response.Status.NOT_FOUND).build();
            }
            return new JsonResponse<InterpreterSetting>(Response.Status.OK, "", setting).build();
        }
        catch (NullPointerException e) {
            logger.error("Exception in InterpreterRestApi while creating ", (Throwable)e);
            return new JsonResponse<String>(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)).build();
        }
    }

    @POST
    @Path(value="setting")
    @ZeppelinApi
    public Response newSettings(String message) {
        try {
            NewInterpreterSettingRequest request = (NewInterpreterSettingRequest)this.gson.fromJson(message, NewInterpreterSettingRequest.class);
            if (request == null) {
                return new JsonResponse(Response.Status.BAD_REQUEST).build();
            }
            Properties p = new Properties();
            p.putAll(request.getProperties());
            InterpreterSetting interpreterSetting = this.interpreterFactory.createNewSetting(request.getName(), request.getGroup(), request.getDependencies(), request.getOption(), p);
            logger.info("new setting created with {}", (Object)interpreterSetting.getId());
            return new JsonResponse<InterpreterSetting>(Response.Status.CREATED, "", interpreterSetting).build();
        }
        catch (IOException | InterpreterException e) {
            logger.error("Exception in InterpreterRestApi while creating ", e);
            return new JsonResponse<String>(Response.Status.NOT_FOUND, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)).build();
        }
    }

    @PUT
    @Path(value="setting/{settingId}")
    @ZeppelinApi
    public Response updateSetting(String message, @PathParam(value="settingId") String settingId) {
        logger.info("Update interpreterSetting {}", (Object)settingId);
        try {
            UpdateInterpreterSettingRequest request = (UpdateInterpreterSettingRequest)this.gson.fromJson(message, UpdateInterpreterSettingRequest.class);
            this.interpreterFactory.setPropertyAndRestart(settingId, request.getOption(), request.getProperties(), request.getDependencies());
        }
        catch (InterpreterException e) {
            logger.error("Exception in InterpreterRestApi while updateSetting ", (Throwable)e);
            return new JsonResponse<String>(Response.Status.NOT_FOUND, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)).build();
        }
        catch (IOException e) {
            logger.error("Exception in InterpreterRestApi while updateSetting ", (Throwable)e);
            return new JsonResponse<String>(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)).build();
        }
        InterpreterSetting setting = this.interpreterFactory.get(settingId);
        if (setting == null) {
            return new JsonResponse<String>(Response.Status.NOT_FOUND, "", settingId).build();
        }
        return new JsonResponse<InterpreterSetting>(Response.Status.OK, "", setting).build();
    }

    @DELETE
    @Path(value="setting/{settingId}")
    @ZeppelinApi
    public Response removeSetting(@PathParam(value="settingId") String settingId) throws IOException {
        logger.info("Remove interpreterSetting {}", (Object)settingId);
        this.interpreterFactory.remove(settingId);
        return new JsonResponse(Response.Status.OK).build();
    }

    @PUT
    @Path(value="setting/restart/{settingId}")
    @ZeppelinApi
    public Response restartSetting(String message, @PathParam(value="settingId") String settingId) {
        logger.info("Restart interpreterSetting {}, msg={}", (Object)settingId, (Object)message);
        try {
            RestartInterpreterRequest request = (RestartInterpreterRequest)this.gson.fromJson(message, RestartInterpreterRequest.class);
            String noteId = request == null ? null : request.getNoteId();
            this.interpreterFactory.restart(settingId, noteId, SecurityUtils.getPrincipal());
        }
        catch (InterpreterException e) {
            logger.error("Exception in InterpreterRestApi while restartSetting ", (Throwable)e);
            return new JsonResponse<String>(Response.Status.NOT_FOUND, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)).build();
        }
        InterpreterSetting setting = this.interpreterFactory.get(settingId);
        if (setting == null) {
            return new JsonResponse<String>(Response.Status.NOT_FOUND, "", settingId).build();
        }
        return new JsonResponse<InterpreterSetting>(Response.Status.OK, "", setting).build();
    }

    @GET
    @ZeppelinApi
    public Response listInterpreter(String message) {
        Map m = this.interpreterFactory.getAvailableInterpreterSettings();
        return new JsonResponse<Map>(Response.Status.OK, "", m).build();
    }

    @GET
    @Path(value="repository")
    @ZeppelinApi
    public Response listRepositories() {
        List interpreterRepositories = this.interpreterFactory.getRepositories();
        return new JsonResponse<List>(Response.Status.OK, "", interpreterRepositories).build();
    }

    @POST
    @Path(value="repository")
    @ZeppelinApi
    public Response addRepository(String message) {
        try {
            Repository request = (Repository)this.gson.fromJson(message, Repository.class);
            this.interpreterFactory.addRepository(request.getId(), request.getUrl(), request.isSnapshot(), request.getAuthentication(), request.getProxy());
            logger.info("New repository {} added", (Object)request.getId());
        }
        catch (Exception e) {
            logger.error("Exception in InterpreterRestApi while adding repository ", (Throwable)e);
            return new JsonResponse<String>(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)).build();
        }
        return new JsonResponse(Response.Status.CREATED).build();
    }

    @GET
    @Path(value="getmetainfos/{settingId}")
    public Response getMetaInfo(@Context HttpServletRequest req, @PathParam(value="settingId") String settingId) {
        String propName = req.getParameter("propName");
        if (propName == null) {
            return new JsonResponse(Response.Status.BAD_REQUEST).build();
        }
        String propValue = null;
        InterpreterSetting interpreterSetting = this.interpreterFactory.get(settingId);
        Map infos = interpreterSetting.getInfos();
        if (infos != null) {
            propValue = (String)infos.get(propName);
        }
        HashMap<String, String> respMap = new HashMap<String, String>();
        respMap.put(propName, propValue);
        logger.debug("Get meta info");
        logger.debug("Interpretersetting Id: {}, property Name:{}, property value: {}", new Object[]{settingId, propName, propValue});
        return new JsonResponse(Response.Status.OK, respMap).build();
    }

    @DELETE
    @Path(value="repository/{repoId}")
    @ZeppelinApi
    public Response removeRepository(@PathParam(value="repoId") String repoId) {
        logger.info("Remove repository {}", (Object)repoId);
        try {
            this.interpreterFactory.removeRepository(repoId);
        }
        catch (Exception e) {
            logger.error("Exception in InterpreterRestApi while removing repository ", (Throwable)e);
            return new JsonResponse<String>(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)).build();
        }
        return new JsonResponse(Response.Status.OK).build();
    }
}

