/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.rest;

import java.util.HashMap;
import java.util.HashSet;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.apache.zeppelin.annotation.ZeppelinApi;
import org.apache.zeppelin.notebook.NotebookAuthorization;
import org.apache.zeppelin.server.JsonResponse;
import org.apache.zeppelin.ticket.TicketContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/login")
@Produces(value={"application/json"})
public class LoginRestApi {
    private static final Logger LOG = LoggerFactory.getLogger(LoginRestApi.class);

    @POST
    @ZeppelinApi
    public Response postLogin(@FormParam(value="userName") String userName, @FormParam(value="password") String password) {
        JsonResponse<Object> response = null;
        Subject currentUser = SecurityUtils.getSubject();
        if (currentUser.isAuthenticated()) {
            currentUser.logout();
        }
        if (!currentUser.isAuthenticated()) {
            try {
                UsernamePasswordToken token = new UsernamePasswordToken(userName, password);
                currentUser.login((AuthenticationToken)token);
                HashSet<String> roles = org.apache.zeppelin.utils.SecurityUtils.getRoles();
                String principal = org.apache.zeppelin.utils.SecurityUtils.getPrincipal();
                String ticket = "anonymous".equals(principal) ? "anonymous" : TicketContainer.instance.getTicket(principal);
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("principal", principal);
                data.put("roles", roles.toString());
                data.put("ticket", ticket);
                response = new JsonResponse(Response.Status.OK, "", data);
                NotebookAuthorization.getInstance().setRoles(principal, roles);
            }
            catch (UnknownAccountException uae) {
                LOG.error("Exception in login: ", (Throwable)uae);
            }
            catch (IncorrectCredentialsException ice) {
                LOG.error("Exception in login: ", (Throwable)ice);
            }
            catch (LockedAccountException lae) {
                LOG.error("Exception in login: ", (Throwable)lae);
            }
            catch (AuthenticationException ae) {
                LOG.error("Exception in login: ", (Throwable)ae);
            }
        }
        if (response == null) {
            response = new JsonResponse<String>(Response.Status.FORBIDDEN, "", "");
        }
        LOG.warn(response.toString());
        return response.build();
    }

    @POST
    @Path(value="logout")
    @ZeppelinApi
    public Response logout() {
        Subject currentUser = SecurityUtils.getSubject();
        currentUser.logout();
        JsonResponse<String> response = new JsonResponse<String>(Response.Status.UNAUTHORIZED, "", "");
        LOG.warn(response.toString());
        return response.build();
    }
}

