/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.rest;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.zeppelin.annotation.ZeppelinApi;
import org.apache.zeppelin.notebook.repo.NotebookRepoSync;
import org.apache.zeppelin.notebook.repo.NotebookRepoWithSettings;
import org.apache.zeppelin.rest.message.NotebookRepoSettingsRequest;
import org.apache.zeppelin.server.JsonResponse;
import org.apache.zeppelin.socket.NotebookServer;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.apache.zeppelin.utils.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/notebook-repositories")
@Produces(value={"application/json"})
public class NotebookRepoRestApi {
    private static final Logger LOG = LoggerFactory.getLogger(NotebookRepoRestApi.class);
    private Gson gson = new Gson();
    private NotebookRepoSync noteRepos;
    private NotebookServer notebookWsServer;

    public NotebookRepoRestApi() {
    }

    public NotebookRepoRestApi(NotebookRepoSync noteRepos, NotebookServer notebookWsServer) {
        this.noteRepos = noteRepos;
        this.notebookWsServer = notebookWsServer;
    }

    @GET
    @ZeppelinApi
    public Response listRepoSettings() {
        AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
        LOG.info("Getting list of NoteRepo with Settings for user {}", (Object)subject.getUser());
        List settings = this.noteRepos.getNotebookRepos(subject);
        return new JsonResponse<List>(Response.Status.OK, "", settings).build();
    }

    @GET
    @Path(value="reload")
    @ZeppelinApi
    public Response refreshRepo() {
        AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
        LOG.info("Reloading notebook repository for user {}", (Object)subject.getUser());
        this.notebookWsServer.broadcastReloadedNoteList(subject, null);
        return new JsonResponse<Object>(Response.Status.OK, "", null).build();
    }

    @PUT
    @ZeppelinApi
    public Response updateRepoSetting(String payload) {
        if (StringUtils.isBlank((String)payload)) {
            return new JsonResponse(Response.Status.NOT_FOUND, "", Collections.emptyMap()).build();
        }
        AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
        NotebookRepoSettingsRequest newSettings = NotebookRepoSettingsRequest.EMPTY;
        try {
            newSettings = (NotebookRepoSettingsRequest)this.gson.fromJson(payload, NotebookRepoSettingsRequest.class);
        }
        catch (JsonSyntaxException e) {
            LOG.error("Cannot update notebook repo settings", (Throwable)e);
            return new JsonResponse<ImmutableMap>(Response.Status.NOT_ACCEPTABLE, "", ImmutableMap.of((Object)"error", (Object)"Invalid payload structure")).build();
        }
        if (NotebookRepoSettingsRequest.isEmpty(newSettings)) {
            LOG.error("Invalid property");
            return new JsonResponse<ImmutableMap>(Response.Status.NOT_ACCEPTABLE, "", ImmutableMap.of((Object)"error", (Object)"Invalid payload")).build();
        }
        LOG.info("User {} is going to change repo setting", (Object)subject.getUser());
        NotebookRepoWithSettings updatedSettings = this.noteRepos.updateNotebookRepo(newSettings.name, newSettings.settings, subject);
        if (!updatedSettings.isEmpty()) {
            LOG.info("Broadcasting note list to user {}", (Object)subject.getUser());
            this.notebookWsServer.broadcastReloadedNoteList(subject, null);
        }
        return new JsonResponse<NotebookRepoWithSettings>(Response.Status.OK, "", updatedSettings).build();
    }
}

