/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.realm.jwt;

import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.SignedJWT;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Groups;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAccount;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.zeppelin.realm.jwt.JWTAuthenticationToken;
import org.apache.zeppelin.realm.jwt.PrincipalMappingException;
import org.apache.zeppelin.realm.jwt.SimplePrincipalMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnoxJwtRealm
extends AuthorizingRealm {
    private static final Logger LOGGER = LoggerFactory.getLogger(KnoxJwtRealm.class);
    private String providerUrl;
    private String redirectParam;
    private String cookieName;
    private String publicKeyPath;
    private String login;
    private String logout;
    private Boolean logoutAPI;
    private String principalMapping;
    private String groupPrincipalMapping;
    private SimplePrincipalMapper mapper = new SimplePrincipalMapper();
    private Configuration hadoopConfig;
    private Groups hadoopGroups;

    protected void onInit() {
        super.onInit();
        if (this.principalMapping != null && !this.principalMapping.isEmpty() || this.groupPrincipalMapping != null && !this.groupPrincipalMapping.isEmpty()) {
            try {
                this.mapper.loadMappingTable(this.principalMapping, this.groupPrincipalMapping);
            }
            catch (PrincipalMappingException e) {
                LOGGER.error("PrincipalMappingException in onInit", (Throwable)e);
            }
        }
        try {
            this.hadoopConfig = new Configuration();
            this.hadoopGroups = new Groups(this.hadoopConfig);
        }
        catch (Exception e) {
            LOGGER.error("Exception in onInit", (Throwable)e);
        }
    }

    public boolean supports(AuthenticationToken token) {
        return token != null && token instanceof JWTAuthenticationToken;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) {
        JWTAuthenticationToken upToken = (JWTAuthenticationToken)token;
        if (this.validateToken(upToken.getToken())) {
            try {
                SimpleAccount account = new SimpleAccount((Object)this.getName(upToken), (Object)upToken.getToken(), this.getName());
                account.addRole(this.mapGroupPrincipals(this.getName(upToken)));
                return account;
            }
            catch (ParseException e) {
                LOGGER.error("ParseException in doGetAuthenticationInfo", (Throwable)e);
            }
        }
        return null;
    }

    public String getName(JWTAuthenticationToken upToken) throws ParseException {
        SignedJWT signed = SignedJWT.parse((String)upToken.getToken());
        String userName = signed.getJWTClaimsSet().getSubject();
        return userName;
    }

    protected boolean validateToken(String token) {
        try {
            SignedJWT signed = SignedJWT.parse((String)token);
            boolean sigValid = this.validateSignature(signed);
            if (!sigValid) {
                LOGGER.warn("Signature of JWT token could not be verified. Please check the public key");
                return false;
            }
            boolean expValid = this.validateExpiration(signed);
            if (!expValid) {
                LOGGER.warn("Expiration time validation of JWT token failed.");
                return false;
            }
            String currentUser = (String)SecurityUtils.getSubject().getPrincipal();
            if (currentUser == null) {
                return true;
            }
            String cookieUser = signed.getJWTClaimsSet().getSubject();
            return cookieUser.equals(currentUser);
        }
        catch (ParseException ex) {
            LOGGER.info("ParseException in validateToken", (Throwable)ex);
            return false;
        }
    }

    public static RSAPublicKey parseRSAPublicKey(String pem) throws IOException, ServletException {
        String pemHeader = "-----BEGIN CERTIFICATE-----\n";
        String pemFooter = "\n-----END CERTIFICATE-----";
        String fullPem = "-----BEGIN CERTIFICATE-----\n" + pem + "\n-----END CERTIFICATE-----";
        PublicKey key = null;
        try {
            CertificateFactory fact = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream is = new ByteArrayInputStream(FileUtils.readFileToString((File)new File(pem)).getBytes("UTF8"));
            X509Certificate cer = (X509Certificate)fact.generateCertificate(is);
            key = cer.getPublicKey();
        }
        catch (CertificateException ce) {
            String message = null;
            message = pem.startsWith("-----BEGIN CERTIFICATE-----\n") ? "CertificateException - be sure not to include PEM header and footer in the PEM configuration element." : "CertificateException - PEM may be corrupt";
            throw new ServletException(message, (Throwable)ce);
        }
        catch (UnsupportedEncodingException uee) {
            throw new ServletException((Throwable)uee);
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        return (RSAPublicKey)key;
    }

    protected boolean validateSignature(SignedJWT jwtToken) {
        boolean valid = false;
        if (JWSObject.State.SIGNED == jwtToken.getState() && jwtToken.getSignature() != null) {
            try {
                RSAPublicKey publicKey = KnoxJwtRealm.parseRSAPublicKey(this.publicKeyPath);
                RSASSAVerifier verifier = new RSASSAVerifier(publicKey);
                if (verifier != null && jwtToken.verify((JWSVerifier)verifier)) {
                    valid = true;
                }
            }
            catch (Exception e) {
                LOGGER.info("Exception in validateSignature", (Throwable)e);
            }
        }
        return valid;
    }

    protected boolean validateExpiration(SignedJWT jwtToken) {
        boolean valid = false;
        try {
            Date expires = jwtToken.getJWTClaimsSet().getExpirationTime();
            if (expires == null || new Date().before(expires)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("SSO token expiration date has been successfully validated");
                }
                valid = true;
            } else {
                LOGGER.warn("SSO expiration date validation failed.");
            }
        }
        catch (ParseException pe) {
            LOGGER.warn("SSO expiration date validation failed.", (Throwable)pe);
        }
        return valid;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        Set<String> roles = this.mapGroupPrincipals(principals.toString());
        return new SimpleAuthorizationInfo(roles);
    }

    public Set<String> mapGroupPrincipals(String mappedPrincipalName) {
        HashSet<String> groups = null;
        try {
            this.hadoopGroups.refresh();
            List groupList = this.hadoopGroups.getGroups(mappedPrincipalName);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("group found %s, %s", mappedPrincipalName, groupList.toString()));
            }
            groups = new HashSet<String>(groupList);
        }
        catch (IOException e) {
            if (e.toString().contains("No groups found for user")) {
                LOGGER.info(String.format("No groups found for user %s", mappedPrincipalName));
            } else {
                LOGGER.info(String.format("errorGettingUserGroups for %s", mappedPrincipalName));
            }
            groups = new HashSet();
        }
        return groups;
    }

    public String getProviderUrl() {
        return this.providerUrl;
    }

    public void setProviderUrl(String providerUrl) {
        this.providerUrl = providerUrl;
    }

    public String getRedirectParam() {
        return this.redirectParam;
    }

    public void setRedirectParam(String redirectParam) {
        this.redirectParam = redirectParam;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public String getPublicKeyPath() {
        return this.publicKeyPath;
    }

    public void setPublicKeyPath(String publicKeyPath) {
        this.publicKeyPath = publicKeyPath;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getLogout() {
        return this.logout;
    }

    public void setLogout(String logout) {
        this.logout = logout;
    }

    public Boolean getLogoutAPI() {
        return this.logoutAPI;
    }

    public void setLogoutAPI(Boolean logoutAPI) {
        this.logoutAPI = logoutAPI;
    }

    public String getPrincipalMapping() {
        return this.principalMapping;
    }

    public void setPrincipalMapping(String principalMapping) {
        this.principalMapping = principalMapping;
    }

    public String getGroupPrincipalMapping() {
        return this.groupPrincipalMapping;
    }

    public void setGroupPrincipalMapping(String groupPrincipalMapping) {
        this.groupPrincipalMapping = groupPrincipalMapping;
    }
}

