/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.rest;

import com.google.common.collect.Lists;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.annotation.ZeppelinApi;
import org.apache.zeppelin.rest.message.LoggerRequest;
import org.apache.zeppelin.service.AdminService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/admin")
@Singleton
public class AdminRestApi {
    private static final Logger logger = LoggerFactory.getLogger(AdminRestApi.class);
    private AdminService adminService;

    @Inject
    public AdminRestApi(AdminService adminService) {
        this.adminService = adminService;
    }

    @GET
    @ZeppelinApi
    public List<org.apache.log4j.Logger> getLoggerSetting(@QueryParam(value="name") String name) {
        logger.debug("name: {}", (Object)name);
        return null == name || name.isEmpty() ? this.adminService.getLoggers() : Lists.newArrayList((Object[])new org.apache.log4j.Logger[]{this.adminService.getLogger(name)});
    }

    @POST
    @ZeppelinApi
    public List<org.apache.log4j.Logger> setLoggerLevel(LoggerRequest loggerRequest) {
        if (null == loggerRequest || StringUtils.isEmpty((CharSequence)loggerRequest.getName()) || StringUtils.isEmpty((CharSequence)loggerRequest.getLevel())) {
            logger.trace("loggerRequest: {}", (Object)loggerRequest);
            throw new BadRequestException("Wrong request body");
        }
        logger.debug("loggerRequest: {}", (Object)loggerRequest);
        this.adminService.setLoggerLevel(loggerRequest);
        return Lists.newArrayList((Object[])new org.apache.log4j.Logger[]{this.adminService.getLogger(loggerRequest.getName())});
    }
}

