/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.server;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import org.eclipse.jetty.util.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlAddonResource
extends Resource {
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlAddonResource.class);
    private static final String TAG_BODY_OPENING = "<body";
    private static final String TAG_BODY_CLOSING = "</body>";
    private static final String TAG_HEAD_CLOSING = "</head>";
    private static final String TAG_HTML_CLOSING = "</html>";
    public static final String HTML_ADDON_IDENTIFIER = "zeppelin-index-with-addon";
    public static final String INDEX_HTML_PATH = "/index.html";
    private final Resource indexResource;
    private File alteredTempFile = null;
    private byte[] alteredContent;

    public HtmlAddonResource(Resource indexResource, String bodyAddon, String headAddon) {
        LOGGER.info("Enabling html addons in " + indexResource + ": body='{}' head='{}'", (Object)bodyAddon, (Object)headAddon);
        this.indexResource = indexResource;
        try {
            String content;
            try (InputStreamReader reader = new InputStreamReader(indexResource.getInputStream());){
                content = CharStreams.toString((Readable)reader);
            }
            if (bodyAddon != null) {
                content = content.contains(TAG_BODY_CLOSING) ? content.replace(TAG_BODY_CLOSING, bodyAddon + TAG_BODY_CLOSING) : (content.contains(TAG_HTML_CLOSING) ? content.replace(TAG_HTML_CLOSING, bodyAddon + TAG_HTML_CLOSING) : content + bodyAddon);
            }
            if (headAddon != null) {
                if (content.contains(TAG_HEAD_CLOSING)) {
                    content = content.replace(TAG_HEAD_CLOSING, headAddon + TAG_HEAD_CLOSING);
                } else if (content.contains(TAG_BODY_OPENING)) {
                    content = content.replace(TAG_BODY_OPENING, headAddon + TAG_BODY_OPENING);
                } else {
                    LOGGER.error("Unable to process Head html addon. Could not find proper anchor in index.html.");
                }
            }
            this.alteredContent = content.getBytes(Charsets.UTF_8);
            if (indexResource.getFile() != null) {
                this.alteredTempFile = File.createTempFile(HTML_ADDON_IDENTIFIER, ".html");
                this.alteredTempFile.deleteOnExit();
                Files.write((byte[])this.alteredContent, (File)this.alteredTempFile);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error initializing html addons.", (Throwable)e);
        }
    }

    public File getFile() throws IOException {
        return this.alteredTempFile;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.alteredContent);
    }

    public String getName() {
        return this.indexResource.getName();
    }

    public boolean isContainedIn(Resource r) throws MalformedURLException {
        return this.indexResource.isContainedIn(r);
    }

    public boolean exists() {
        return this.indexResource.exists();
    }

    public boolean isDirectory() {
        return this.indexResource.isDirectory();
    }

    public long lastModified() {
        return this.indexResource.lastModified();
    }

    public long length() {
        return this.alteredContent.length;
    }

    public URL getURL() {
        return this.indexResource.getURL();
    }

    public ReadableByteChannel getReadableByteChannel() throws IOException {
        return Channels.newChannel(new ByteArrayInputStream(this.alteredContent));
    }

    public boolean delete() throws SecurityException {
        throw new UnsupportedOperationException("Not supported");
    }

    public boolean renameTo(Resource dest) throws SecurityException {
        throw new UnsupportedOperationException("Not supported");
    }

    public String[] list() {
        throw new UnsupportedOperationException("Not supported");
    }

    public Resource addPath(String path) throws IOException, MalformedURLException {
        throw new UnsupportedOperationException("Not supported");
    }

    public void close() {
    }
}

