/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.server;

import java.util.LinkedList;
import java.util.List;
import javax.inject.Singleton;
import org.apache.zeppelin.server.ErrorData;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.utilities.ImmediateErrorHandler;

@Singleton
public class ImmediateErrorHandlerImpl
implements ImmediateErrorHandler {
    private final List<ErrorData> constructionErrors = new LinkedList<ErrorData>();
    private final List<ErrorData> destructionErrors = new LinkedList<ErrorData>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postConstructFailed(ActiveDescriptor<?> immediateService, Throwable exception) {
        ImmediateErrorHandlerImpl immediateErrorHandlerImpl = this;
        synchronized (immediateErrorHandlerImpl) {
            this.constructionErrors.add(new ErrorData(immediateService, exception));
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDestroyFailed(ActiveDescriptor<?> immediateService, Throwable exception) {
        ImmediateErrorHandlerImpl immediateErrorHandlerImpl = this;
        synchronized (immediateErrorHandlerImpl) {
            this.destructionErrors.add(new ErrorData(immediateService, exception));
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ErrorData> waitForAtLeastOneConstructionError(long waitTime) throws InterruptedException {
        ImmediateErrorHandlerImpl immediateErrorHandlerImpl = this;
        synchronized (immediateErrorHandlerImpl) {
            while (this.constructionErrors.size() <= 0 && waitTime > 0L) {
                long currentTime = System.currentTimeMillis();
                this.wait(waitTime);
                long elapsedTime = System.currentTimeMillis() - currentTime;
                waitTime -= elapsedTime;
            }
            return new LinkedList<ErrorData>(this.constructionErrors);
        }
    }
}

